/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.ExtensionAdapterSupport;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.client.DefaultVolumeSnapshotClient;
import io.fabric8.volumesnapshot.client.VolumeSnapshotClient;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;

public class VolumeSnapshotExtensionAdapter
extends ExtensionAdapterSupport
implements ExtensionAdapter<VolumeSnapshotClient> {
    static final ConcurrentMap<URL, Boolean> IS_VOLUME_SNAPSHOT;
    static final ConcurrentMap<URL, Boolean> USES_VOLUME_SNAPSHOT_APIGROUPS;
    public static final String API_GROUP = "snapshot.storage.k8s.io";

    public Class<VolumeSnapshotClient> getExtensionType() {
        return VolumeSnapshotClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isAdaptable(client, IS_VOLUME_SNAPSHOT, USES_VOLUME_SNAPSHOT_APIGROUPS, API_GROUP);
    }

    public VolumeSnapshotClient adapt(Client client) {
        return new DefaultVolumeSnapshotClient((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    static {
        Handlers.register(VolumeSnapshotClass.class, VolumeSnapshotClassOperationsImpl::new);
        Handlers.register(VolumeSnapshotContent.class, VolumeSnapshotContentOperationsImpl::new);
        Handlers.register(VolumeSnapshot.class, VolumeSnapshotOperationsImpl::new);
        IS_VOLUME_SNAPSHOT = new ConcurrentHashMap<URL, Boolean>();
        USES_VOLUME_SNAPSHOT_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();
    }
}

