/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSource;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSourceFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSourceFluentImpl;
import java.util.Objects;

public class VolumeSnapshotSourceBuilder
extends VolumeSnapshotSourceFluentImpl<VolumeSnapshotSourceBuilder>
implements VisitableBuilder<VolumeSnapshotSource, VolumeSnapshotSourceBuilder> {
    VolumeSnapshotSourceFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeSnapshotSourceBuilder() {
        this(false);
    }

    public VolumeSnapshotSourceBuilder(Boolean validationEnabled) {
        this(new VolumeSnapshotSource(), validationEnabled);
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeSnapshotSource(), validationEnabled);
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSourceFluent<?> fluent, VolumeSnapshotSource instance) {
        this(fluent, instance, false);
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSourceFluent<?> fluent, VolumeSnapshotSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPersistentVolumeClaimName(instance.getPersistentVolumeClaimName());
        fluent.withVolumeSnapshotContentName(instance.getVolumeSnapshotContentName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSource instance) {
        this(instance, (Boolean)false);
    }

    public VolumeSnapshotSourceBuilder(VolumeSnapshotSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPersistentVolumeClaimName(instance.getPersistentVolumeClaimName());
        this.withVolumeSnapshotContentName(instance.getVolumeSnapshotContentName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeSnapshotSource build() {
        VolumeSnapshotSource buildable = new VolumeSnapshotSource(this.fluent.getPersistentVolumeClaimName(), this.fluent.getVolumeSnapshotContentName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeSnapshotSourceBuilder that = (VolumeSnapshotSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

