/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentStatus;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentStatusFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotError;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotErrorBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotErrorFluentImpl;
import java.util.Objects;

public class VolumeSnapshotContentStatusFluentImpl<A extends VolumeSnapshotContentStatusFluent<A>>
extends BaseFluent<A>
implements VolumeSnapshotContentStatusFluent<A> {
    private Long creationTime;
    private VolumeSnapshotErrorBuilder error;
    private Boolean readyToUse;
    private Long restoreSize;
    private String snapshotHandle;

    public VolumeSnapshotContentStatusFluentImpl() {
    }

    public VolumeSnapshotContentStatusFluentImpl(VolumeSnapshotContentStatus instance) {
        this.withCreationTime(instance.getCreationTime());
        this.withError(instance.getError());
        this.withReadyToUse(instance.getReadyToUse());
        this.withRestoreSize(instance.getRestoreSize());
        this.withSnapshotHandle(instance.getSnapshotHandle());
    }

    @Override
    public Long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public A withCreationTime(Long creationTime) {
        this.creationTime = creationTime;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTime() {
        return this.creationTime != null;
    }

    @Override
    @Deprecated
    public VolumeSnapshotError getError() {
        return this.error != null ? this.error.build() : null;
    }

    @Override
    public VolumeSnapshotError buildError() {
        return this.error != null ? this.error.build() : null;
    }

    @Override
    public A withError(VolumeSnapshotError error) {
        this._visitables.get((Object)"error").remove(this.error);
        if (error != null) {
            this.error = new VolumeSnapshotErrorBuilder(error);
            this._visitables.get((Object)"error").add(this.error);
        } else {
            this.error = null;
            this._visitables.get((Object)"error").remove(this.error);
        }
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    public A withNewError(String message, String time) {
        return this.withError(new VolumeSnapshotError(message, time));
    }

    @Override
    public VolumeSnapshotContentStatusFluent.ErrorNested<A> withNewError() {
        return new ErrorNestedImpl();
    }

    @Override
    public VolumeSnapshotContentStatusFluent.ErrorNested<A> withNewErrorLike(VolumeSnapshotError item) {
        return new ErrorNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentStatusFluent.ErrorNested<A> editError() {
        return this.withNewErrorLike(this.getError());
    }

    @Override
    public VolumeSnapshotContentStatusFluent.ErrorNested<A> editOrNewError() {
        return this.withNewErrorLike(this.getError() != null ? this.getError() : new VolumeSnapshotErrorBuilder().build());
    }

    @Override
    public VolumeSnapshotContentStatusFluent.ErrorNested<A> editOrNewErrorLike(VolumeSnapshotError item) {
        return this.withNewErrorLike(this.getError() != null ? this.getError() : item);
    }

    @Override
    public Boolean getReadyToUse() {
        return this.readyToUse;
    }

    @Override
    public A withReadyToUse(Boolean readyToUse) {
        this.readyToUse = readyToUse;
        return (A)this;
    }

    @Override
    public Boolean hasReadyToUse() {
        return this.readyToUse != null;
    }

    @Override
    public Long getRestoreSize() {
        return this.restoreSize;
    }

    @Override
    public A withRestoreSize(Long restoreSize) {
        this.restoreSize = restoreSize;
        return (A)this;
    }

    @Override
    public Boolean hasRestoreSize() {
        return this.restoreSize != null;
    }

    @Override
    public String getSnapshotHandle() {
        return this.snapshotHandle;
    }

    @Override
    public A withSnapshotHandle(String snapshotHandle) {
        this.snapshotHandle = snapshotHandle;
        return (A)this;
    }

    @Override
    public Boolean hasSnapshotHandle() {
        return this.snapshotHandle != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSnapshotContentStatusFluentImpl that = (VolumeSnapshotContentStatusFluentImpl)o;
        if (this.creationTime != null ? !this.creationTime.equals(that.creationTime) : that.creationTime != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.readyToUse != null ? !this.readyToUse.equals(that.readyToUse) : that.readyToUse != null) {
            return false;
        }
        if (this.restoreSize != null ? !this.restoreSize.equals(that.restoreSize) : that.restoreSize != null) {
            return false;
        }
        return !(this.snapshotHandle != null ? !this.snapshotHandle.equals(that.snapshotHandle) : that.snapshotHandle != null);
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.error, this.readyToUse, this.restoreSize, this.snapshotHandle, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.creationTime != null) {
            sb.append("creationTime:");
            sb.append(this.creationTime + ",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error + ",");
        }
        if (this.readyToUse != null) {
            sb.append("readyToUse:");
            sb.append(this.readyToUse + ",");
        }
        if (this.restoreSize != null) {
            sb.append("restoreSize:");
            sb.append(this.restoreSize + ",");
        }
        if (this.snapshotHandle != null) {
            sb.append("snapshotHandle:");
            sb.append(this.snapshotHandle);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadyToUse() {
        return this.withReadyToUse(true);
    }

    class ErrorNestedImpl<N>
    extends VolumeSnapshotErrorFluentImpl<VolumeSnapshotContentStatusFluent.ErrorNested<N>>
    implements VolumeSnapshotContentStatusFluent.ErrorNested<N>,
    Nested<N> {
        VolumeSnapshotErrorBuilder builder;

        ErrorNestedImpl(VolumeSnapshotError item) {
            this.builder = new VolumeSnapshotErrorBuilder(this, item);
        }

        ErrorNestedImpl() {
            this.builder = new VolumeSnapshotErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentStatusFluentImpl.this.withError(this.builder.build());
        }

        @Override
        public N endError() {
            return this.and();
        }
    }
}

