/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.volumesnapshot.client.VolumeSnapshotClient;
import io.fabric8.volumesnapshot.server.mock.VolumeSnapshotMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class VolumeSnapshotServer
extends ExternalResource {
    protected VolumeSnapshotMockServer mock;
    private VolumeSnapshotClient client;
    private final boolean https;
    private final boolean crudMode;

    public VolumeSnapshotServer() {
        this(true, false);
    }

    public VolumeSnapshotServer(boolean https) {
        this(https, false);
    }

    public VolumeSnapshotServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new VolumeSnapshotMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), true) : new VolumeSnapshotMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createVolumeSnapshot();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public VolumeSnapshotClient get() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }
}

