/*
 * Copyright 2013-2014 Richard M. Hightower
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * __________                              _____          __   .__
 * \______   \ ____   ____   ____   /\    /     \ _____  |  | _|__| ____    ____
 *  |    |  _//  _ \ /  _ \ /    \  \/   /  \ /  \\__  \ |  |/ /  |/    \  / ___\
 *  |    |   (  <_> |  <_> )   |  \ /\  /    Y    \/ __ \|    <|  |   |  \/ /_/  >
 *  |______  /\____/ \____/|___|  / \/  \____|__  (____  /__|_ \__|___|  /\___  /
 *         \/                   \/              \/     \/     \/       \//_____/
 *      ____.                     ___________   _____    ______________.___.
 *     |    |____ ___  _______    \_   _____/  /  _  \  /   _____/\__  |   |
 *     |    \__  \\  \/ /\__  \    |    __)_  /  /_\  \ \_____  \  /   |   |
 * /\__|    |/ __ \\   /  / __ \_  |        \/    |    \/        \ \____   |
 * \________(____  /\_/  (____  / /_______  /\____|__  /_______  / / ______|
 *               \/           \/          \/         \/        \/  \/
 */

package org.boon.json;

import java.util.List;
import java.util.Map;

/**
 * Created by Richard on 2/5/14.
 */
public interface JsonParserEvents {

    boolean  objectStart(int index);
    boolean  objectEnd(int index, Map<String, Object> object);

    boolean  objectFieldName(int index, Map<String, Object> map, CharSequence name);
    boolean  objectField(int index, Map<String, Object> map, CharSequence name, Object field);

    boolean  arrayStart(int index);
    boolean  arrayEnd(int index, List<Object> list);
    boolean  arrayItem(int index, List<Object> list, Object item);


    boolean  number(int startIndex, int endIndex, Number number);
    boolean  string(int startIndex, int endIndex, CharSequence string);

    boolean  bool( int endIndex, boolean value);
    boolean  nullValue( int endIndex);

}
