/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.boon.StringScanner;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.Flt;

public class FloatList
extends AbstractList<Float> {
    private float[] values;
    private int end;

    public static FloatList toFloatList(Collection<?> inputList, String propertyPath) {
        if (inputList.size() == 0) {
            return new FloatList(0);
        }
        FloatList outputList = new FloatList(inputList.size());
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                outputList.add(BeanUtils.getPropertyFloat(o, properties));
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                outputList.add(fieldAccess.getFloat(o));
            }
        }
        return outputList;
    }

    public FloatList(int capacity) {
        this.values = new float[capacity];
    }

    public FloatList() {
        this.values = new float[10];
    }

    public FloatList(float[] values) {
        this.values = values;
        this.end = values.length;
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.values[index]);
    }

    public float idx(int index) {
        return this.values[index];
    }

    public float atIndex(int index) {
        return this.values[index];
    }

    public final float getFloat(int index) {
        return this.values[index];
    }

    @Override
    public boolean add(Float integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Flt.grow(this.values);
        }
        this.values[this.end] = integer.floatValue();
        ++this.end;
        return true;
    }

    public boolean addFloat(float value) {
        if (this.end + 1 >= this.values.length) {
            this.values = Flt.grow(this.values);
        }
        this.values[this.end] = value;
        ++this.end;
        return true;
    }

    public FloatList add(float integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Flt.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return this;
    }

    public boolean addArray(float ... integers) {
        if (this.end + integers.length >= this.values.length) {
            this.values = Flt.grow(this.values, (this.values.length + integers.length) * 2);
        }
        System.arraycopy(integers, 0, this.values, this.end, integers.length);
        this.end += integers.length;
        return true;
    }

    @Override
    public Float set(int index, Float element) {
        float oldValue = this.values[index];
        this.values[index] = element.floatValue();
        return Float.valueOf(oldValue);
    }

    public float idx(int index, float element) {
        float oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public float atIndex(int index, float element) {
        float oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public float setFloat(int index, float element) {
        float oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.end;
    }

    public float sum() {
        return Flt.sum(this.values, this.end);
    }

    public float[] toValueArray() {
        return Arrays.copyOfRange(this.values, 0, this.end);
    }

    public double reduceBy(Object function) {
        return Flt.reduceBy(this.values, this.end, function);
    }

    public double reduceBy(Object function, String name) {
        return Flt.reduceBy(this.values, this.end, function, name);
    }

    public double reduceBy(Flt.ReduceBy reduceBy) {
        return Flt.reduceBy(this.values, this.end, reduceBy);
    }

    public float mean() {
        return Flt.mean(this.values, this.end);
    }

    public float standardDeviation() {
        return Flt.standardDeviation(this.values, this.end);
    }

    public float variance() {
        return Flt.variance(this.values, this.end);
    }

    public float max() {
        return Flt.max(this.values, this.end);
    }

    public float min() {
        return Flt.min(this.values, this.end);
    }

    public float median() {
        return Flt.median(this.values, this.end);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.end);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatList values = (FloatList)o;
        if (this.end != values.end) {
            return false;
        }
        return Flt.equals(0, this.end, this.values, values.values);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values != null ? Flt.hashCode(0, this.end, this.values) : 0);
        result = 31 * result + this.end;
        return result;
    }

    @Override
    public void clear() {
        this.values = new float[10];
        this.end = 0;
    }
}

