/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.boon.StringScanner;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.Int;

public class IntList
extends AbstractList<Integer> {
    private int[] values;
    private int end;

    public static IntList toIntList(Collection<?> inputList, String propertyPath) {
        if (inputList.size() == 0) {
            return new IntList(0);
        }
        IntList outputList = new IntList(inputList.size());
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                outputList.add(BeanUtils.getPropertyInt(o, properties));
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                outputList.add(fieldAccess.getInt(o));
            }
        }
        return outputList;
    }

    public IntList(int capacity) {
        this.values = new int[capacity];
    }

    public IntList() {
        this.values = new int[10];
    }

    @Override
    public void clear() {
        this.values = new int[10];
        this.end = 0;
    }

    public IntList(int[] values) {
        this.values = values;
        this.end = values.length;
    }

    @Override
    public Integer get(int index) {
        return this.values[index];
    }

    public final int getInt(int index) {
        return this.values[index];
    }

    @Override
    public boolean add(Integer integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Int.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public boolean addInt(int integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Int.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public IntList add(int integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Int.grow(this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return this;
    }

    public boolean addArray(int ... integers) {
        if (this.end + integers.length >= this.values.length) {
            this.values = Int.grow(this.values, (this.values.length + integers.length) * 2);
        }
        System.arraycopy(integers, 0, this.values, this.end, integers.length);
        this.end += integers.length;
        return true;
    }

    @Override
    public Integer set(int index, Integer element) {
        int oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public int setInt(int index, int element) {
        int oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.end;
    }

    public int sum() {
        return Int.sum(this.values, this.end);
    }

    public int[] toValueArray() {
        return Arrays.copyOfRange(this.values, 0, this.end);
    }

    public long reduceBy(Object function) {
        return Int.reduceBy(this.values, this.end, function);
    }

    public long reduceBy(Object function, String name) {
        return Int.reduceBy(this.values, this.end, function, name);
    }

    public long reduceBy(Int.ReduceBy reduceBy) {
        return Int.reduceBy(this.values, this.end, reduceBy);
    }

    public int mean() {
        return Int.mean(this.values, this.end);
    }

    public int standardDeviation() {
        return Int.standardDeviation(this.values, this.end);
    }

    public int variance() {
        return Int.variance(this.values, this.end);
    }

    public int max() {
        return Int.max(this.values, this.end);
    }

    public int min() {
        return Int.min(this.values, this.end);
    }

    public int median() {
        return Int.median(this.values, this.end);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.end);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntList integers = (IntList)o;
        if (this.end != integers.end) {
            return false;
        }
        return Int.equals(0, this.end, this.values, integers.values);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values != null ? Int.hashCode(0, this.end, this.values) : 0);
        result = 31 * result + this.end;
        return result;
    }
}

