/*
 * Decompiled with CFR 0.152.
 */
package org.boon.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.collections.ConcurrentLinkedHashSet;
import org.boon.core.Conversions;

public class MultiMap<K, V>
implements Iterable<Map.Entry<K, Collection<V>>> {
    private int initialSize = 10;
    private Map<K, Collection<V>> map = new ConcurrentHashMap<K, Collection<V>>();
    private Class<? extends Collection> collectionClass = ConcurrentLinkedHashSet.class;

    public MultiMap(Class<? extends Collection> collectionClass, int initialSize) {
        this.collectionClass = collectionClass;
        this.initialSize = initialSize;
    }

    public MultiMap(Class<? extends Collection> collectionClass) {
        this.collectionClass = collectionClass;
    }

    public MultiMap() {
    }

    @Override
    public Iterator<Map.Entry<K, Collection<V>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void put(K key, V v) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        collection.add(v);
    }

    public V get(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    public boolean containsKey(K key) {
        Collection<V> collection = this.map.get(key);
        return collection != null && collection.size() != 0;
    }

    public Iterable<V> getAll(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        return collection;
    }

    public boolean remove(K key, V v) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.remove(v);
    }

    public boolean remove(K key) {
        return this.map.remove(key) != null;
    }

    private Collection<V> createCollection(K key) {
        Collection<Object> collection = Conversions.createCollection(this.collectionClass, this.initialSize);
        this.map.put(key, collection);
        return collection;
    }

    public Iterable<K> keySet() {
        return this.map.keySet();
    }

    public Iterable<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        Collection<Collection<V>> values = this.map.values();
        for (Collection<V> c : values) {
            for (V o : c) {
                list.add(o);
            }
        }
        return list;
    }
}

