/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.decorators;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.boon.Exceptions;
import org.boon.criteria.Update;
import org.boon.datarepo.ObjectEditor;
import org.boon.datarepo.impl.decorators.ObjectEditorDecoratorBase;

public class ObjectEditorLogNullCheckDecorator<KEY, ITEM>
extends ObjectEditorDecoratorBase<KEY, ITEM> {
    Logger logger = Logger.getLogger(ObjectEditorLogNullCheckDecorator.class.getName());
    Level level = Level.FINER;
    private boolean debug = false;

    void log(String msg, Object ... items) {
        if (this.debug) {
            System.out.printf(msg, items);
        }
        String message = String.format(msg, items);
        this.logger.log(this.level, message);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ObjectEditorLogNullCheckDecorator() {
    }

    public ObjectEditorLogNullCheckDecorator(ObjectEditor oe) {
        super(oe);
    }

    @Override
    public void put(ITEM item) {
        Exceptions.requireNonNull(item, "item cannot be null");
        this.log("put (item=%s)", item);
        super.put(item);
    }

    @Override
    public boolean add(ITEM item) {
        Exceptions.requireNonNull(item, "item cannot be null");
        this.log("addObject (item=%s)", item);
        return super.add(item);
    }

    @Override
    public ITEM get(KEY key) {
        Exceptions.requireNonNull(key, "key cannot be null");
        this.log("get (key=%s)", key);
        return super.get(key);
    }

    @Override
    public void modify(ITEM item) {
        Exceptions.requireNonNull(item, "item cannot be null");
        this.log("modify (item=%s)", item);
        super.modify(item);
    }

    @Override
    public void modify(ITEM item, String property, Object value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modifyByValue(ITEM item, String property, String value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modifyByValue(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, int value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, long value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, char value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Character.valueOf(value), "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, Character.valueOf(value));
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, short value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, byte value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, float value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Float.valueOf(value), "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, Float.valueOf(value));
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, String property, double value) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("modify (item=%s, property=%s, set=%s)", item, property, value);
        super.modify(item, property, value);
    }

    @Override
    public void modify(ITEM item, Update ... values) {
        Exceptions.requireNonNull(item, "item cannot be null");
        Exceptions.requireNonNull(values, "value cannot be null");
        this.log("modify (item=%s, property=%s, update=%s)", item, values);
        super.modify(item, values);
    }

    @Override
    public void update(KEY key, String property, Object value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void updateByValue(KEY key, String property, String value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("updateByValue (key=%s, property=%s, set=%s)", key, property, value);
        super.updateByValue(key, property, value);
    }

    @Override
    public void update(KEY key, String property, int value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, long value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, char value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Character.valueOf(value), "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, Character.valueOf(value));
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, short value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, byte value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, float value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Float.valueOf(value), "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, Float.valueOf(value));
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, String property, double value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("update (key=%s, property=%s, set=%s)", key, property, value);
        super.update(key, property, value);
    }

    @Override
    public void update(KEY key, Update ... values) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(values, "values cannot be null");
        this.log("update (key=%s, update=%s)", key, values);
        super.update(key, values);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, Object compare, Object value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, int compare, int value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, long compare, long value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, char compare, char value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Character.valueOf(compare), "compare cannot be null");
        Exceptions.requireNonNull(Character.valueOf(value), "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, Character.valueOf(compare), Character.valueOf(value));
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, short compare, short value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, byte compare, byte value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, float compare, float value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(Float.valueOf(compare), "compare cannot be null");
        Exceptions.requireNonNull(Float.valueOf(value), "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, Float.valueOf(compare), Float.valueOf(value));
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, double compare, double value) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        Exceptions.requireNonNull(value, "value cannot be null");
        this.log("compareAndUpdate (key=%s, property=%s, compare=%s, set=%s)", key, property, compare, value);
        return super.compareAndUpdate(key, property, compare, value);
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, int compare) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        this.log("compareAndIncrement (key=%s, property=%s, compare=%s)", key, property, compare);
        return super.compareAndIncrement(key, property, compare);
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, long compare) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        this.log("compareAndIncrement (key=%s, property=%s, compare=%s)", key, property, compare);
        return super.compareAndIncrement(key, property, compare);
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, short compare) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        this.log("compareAndIncrement (key=%s, property=%s, set=%s)", key, property, compare);
        return super.compareAndIncrement(key, property, compare);
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, byte compare) {
        Exceptions.requireNonNull(key, "key cannot be null");
        Exceptions.requireNonNull(property, "property cannot be null");
        Exceptions.requireNonNull(compare, "compare cannot be null");
        this.log("compareAndIncrement (key=%s, property=%s, set=%s)", key, property, compare);
        return super.compareAndIncrement(key, property, compare);
    }
}

