/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.boon.Lists;
import org.boon.core.Function;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.spi.SPIFactory;

public class UniqueLookupIndex<KEY, ITEM>
implements LookupIndex<KEY, ITEM> {
    protected Function<ITEM, KEY> keyGetter;
    protected Map<KEY, ITEM> map = null;
    private Logger log = Logger.getLogger(UniqueLookupIndex.class.getName());
    private Function<Object, KEY> keyTransformer;

    public UniqueLookupIndex(Class<?> keyType) {
        if (keyType == null) {
            return;
        }
        this.map = SPIFactory.getMapCreatorFactory().get().createMap(keyType);
    }

    @Override
    public ITEM get(KEY key) {
        key = this.getKey(key);
        return this.map.get(key);
    }

    @Override
    public void setKeyGetter(Function<ITEM, KEY> keyGetter) {
        this.keyGetter = keyGetter;
    }

    @Override
    public boolean add(ITEM item) {
        KEY key;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("addObject item = %s", item));
        }
        if ((key = this.keyGetter.apply(item)) == null) {
            return false;
        }
        if (this.map.containsKey(key)) {
            return false;
        }
        this.map.put(key, item);
        return true;
    }

    @Override
    public boolean delete(ITEM item) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("delete item = %s", item));
        }
        KEY key = this.keyGetter.apply(item);
        return this.map.remove(key = this.getKey(key)) != null;
    }

    @Override
    public List<ITEM> all() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("all called ");
        }
        return new ArrayList<ITEM>(this.map.values());
    }

    @Override
    public List<ITEM> getAll(KEY key) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getAll called ");
        }
        return Lists.list(this.get(key));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<ITEM> toCollection() {
        return new HashSet<ITEM>(this.map.values());
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean deleteByKey(KEY key) {
        return this.map.remove(key = this.getKey(key)) != null;
    }

    @Override
    public boolean isPrimaryKeyOnly() {
        return false;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean has(KEY key) {
        if (key == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    @Override
    public void setInputKeyTransformer(Function<Object, KEY> func) {
        this.keyTransformer = func;
    }

    @Override
    public void setBucketSize(int size) {
    }

    protected KEY getKey(KEY key) {
        if (this.keyTransformer != null) {
            key = this.keyTransformer.apply(key);
        }
        return key;
    }
}

