/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di.modules;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.Sets;
import org.boon.collections.MultiMap;
import org.boon.core.Supplier;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MethodAccess;
import org.boon.di.ProviderInfo;
import org.boon.di.modules.BaseModule;
import org.boon.di.modules.NamedUtils;

public class InstanceModule
extends BaseModule {
    private Map<Class, ProviderInfo> supplierTypeMap = new ConcurrentHashMap<Class, ProviderInfo>();
    private MultiMap<String, ProviderInfo> supplierNameMap = new MultiMap();
    private Object module;

    public InstanceModule(Object object) {
        this.module = object;
        ClassMeta<?> classMeta = ClassMeta.classMeta(object.getClass());
        Iterable<MethodAccess> methods = classMeta.methods();
        for (MethodAccess method : methods) {
            if (!method.isStatic() && method.name().startsWith("provide")) {
                this.addCreationMethod(method, false);
                continue;
            }
            if (method.isStatic() || !method.name().startsWith("create")) continue;
            this.addCreationMethod(method, true);
        }
    }

    private Supplier<Object> createSupplier(MethodAccess method) {
        return new InternalSupplier(method, this.module);
    }

    @Override
    public <T> T get(Class<T> type) {
        ProviderInfo pi = this.supplierTypeMap.get(type);
        if (pi != null) {
            return pi.supplier().get();
        }
        return null;
    }

    @Override
    public Object get(String name) {
        ProviderInfo pi = this.supplierNameMap.get(name);
        if (pi != null) {
            return pi.supplier().get();
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        return this.getSupplier(type, name).get();
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type) {
        return this.supplierTypeMap.get(type);
    }

    @Override
    public ProviderInfo getProviderInfo(String name) {
        return this.supplierNameMap.get(name);
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type, String name) {
        return this.doGetProvider(type, name);
    }

    private ProviderInfo doGetProvider(Class<?> type, String name) {
        Set<ProviderInfo> set = Sets.set(this.supplierNameMap.getAll(name));
        ProviderInfo nullTypeInfo = null;
        for (ProviderInfo info : set) {
            if (info.type() == null) {
                nullTypeInfo = info;
                continue;
            }
            if (!type.isAssignableFrom(info.type())) continue;
            return info;
        }
        return nullTypeInfo;
    }

    @Override
    public <T> Supplier<T> getSupplier(Class<T> type, String name) {
        try {
            Set<ProviderInfo> set = Sets.set(this.supplierNameMap.getAll(name));
            for (ProviderInfo s : set) {
                InternalSupplier supplier = (InternalSupplier)s.supplier();
                if (!type.isAssignableFrom(supplier.method.returnType())) continue;
                return supplier;
            }
            return new Supplier<T>(){

                @Override
                public T get() {
                    return null;
                }
            };
        }
        catch (Exception e) {
            Exceptions.handle(e);
            return null;
        }
    }

    @Override
    public <T> Supplier<T> getSupplier(Class<T> type) {
        Supplier supplier = (Supplier)((Object)this.supplierTypeMap.get(type));
        if (supplier == null) {
            supplier = new Supplier<T>(){

                @Override
                public T get() {
                    return null;
                }
            };
        }
        return supplier;
    }

    @Override
    public Iterable<Object> values() {
        return this.supplierTypeMap.values();
    }

    @Override
    public Iterable<String> names() {
        return this.supplierNameMap.keySet();
    }

    public Iterable types() {
        return this.supplierTypeMap.keySet();
    }

    @Override
    public boolean has(Class type) {
        return this.supplierTypeMap.containsKey(type);
    }

    @Override
    public boolean has(String name) {
        return this.supplierNameMap.containsKey(name);
    }

    private void addCreationMethod(MethodAccess method, boolean creates) {
        Class<?>[] superTypes;
        Object providerInfo = creates ? null : new Object();
        String named = NamedUtils.namedValueForMethod(method);
        boolean foundName = named != null;
        Class<?> cls = method.returnType();
        if (!foundName) {
            named = NamedUtils.namedValueForClass(cls);
            foundName = named != null;
        }
        Supplier<Object> supplier = this.createSupplier(method);
        this.supplierTypeMap.put(cls, new ProviderInfo<Object>(named, cls, supplier, providerInfo));
        Class<?> superClass = cls.getSuperclass();
        for (Class<?> superType : superTypes = cls.getInterfaces()) {
            this.supplierTypeMap.put(superType, new ProviderInfo<Object>(named, cls, supplier, providerInfo));
        }
        if (superClass != null) {
            while (superClass != Object.class) {
                this.supplierTypeMap.put(superClass, new ProviderInfo<Object>(named, cls, supplier, providerInfo));
                if (!foundName) {
                    named = NamedUtils.namedValueForClass(cls);
                    foundName = named != null;
                }
                for (Class<?> superType : superTypes = cls.getInterfaces()) {
                    this.supplierTypeMap.put(superType, new ProviderInfo<Object>(named, cls, supplier, providerInfo));
                }
                superClass = superClass.getSuperclass();
            }
        }
        if (foundName) {
            this.supplierNameMap.put(named, new ProviderInfo<Object>(named, cls, supplier, providerInfo));
        }
    }

    private static class InternalSupplier
    implements Supplier<Object> {
        private final Object module;
        private final MethodAccess method;

        InternalSupplier(MethodAccess method, Object module) {
            this.method = method;
            this.module = module;
        }

        @Override
        public Object get() {
            try {
                return this.method.invoke(this.module, new Object[0]);
            }
            catch (Exception e) {
                return Exceptions.handle(Object.class, e);
            }
        }
    }
}

