/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Arrays;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharScanner;
import org.boon.primitive.CharacterSource;

public class CharArrayCharacterSource
implements CharacterSource {
    private char[] chars;
    private int index = 0;
    private boolean foundEscape;
    private int ch;
    private final char[] EMPTY_CHARS = new char[0];

    public CharArrayCharacterSource(char[] chars) {
        this.chars = chars;
    }

    public CharArrayCharacterSource(String string) {
        this.chars = FastStringUtils.toCharArray(string);
    }

    @Override
    public final int nextChar() {
        this.ch = this.chars[this.index++];
        return this.ch;
    }

    @Override
    public final int safeNextChar() {
        this.ch = this.index + 1 < this.chars.length ? this.chars[this.index++] : -1;
        return this.ch;
    }

    @Override
    public final char[] findNextChar(int match, int esc) {
        int idx;
        int startIndex = idx = this.index;
        this.foundEscape = false;
        char[] _chars = this.chars;
        int ch = 0;
        while (idx < _chars.length) {
            ch = _chars[idx];
            if (ch == match || ch == esc) {
                if (ch == match) {
                    this.index = idx + 1;
                    this.ch = ch;
                    return Arrays.copyOfRange(_chars, startIndex, idx);
                }
                if (ch == esc) {
                    this.foundEscape = true;
                    if (idx + 1 < _chars.length) {
                        ++idx;
                    }
                }
            }
            ++idx;
        }
        this.index = idx;
        this.ch = ch;
        return this.EMPTY_CHARS;
    }

    @Override
    public boolean hadEscape() {
        return this.foundEscape;
    }

    @Override
    public char[] readNumber() {
        char[] results = CharScanner.readNumber(this.chars, this.index);
        this.index += results.length;
        return results;
    }

    @Override
    public final int currentChar() {
        return this.chars[this.index];
    }

    @Override
    public final boolean hasChar() {
        return this.index + 1 < this.chars.length;
    }

    @Override
    public final boolean consumeIfMatch(char[] match) {
        int idx = this.index;
        char[] _chars = this.chars;
        boolean ok = true;
        int i = 0;
        while (i < match.length && (ok &= match[i] == _chars[idx])) {
            ++i;
            ++idx;
        }
        if (ok) {
            this.index = idx;
            return true;
        }
        return false;
    }

    @Override
    public final int location() {
        return this.index;
    }

    @Override
    public void skipWhiteSpace() {
        this.index = CharScanner.skipWhiteSpace(this.chars, this.index);
    }

    @Override
    public String errorDetails(String message) {
        this.ch = this.index < this.chars.length ? this.chars[this.index] : this.chars[this.chars.length - 1];
        return CharScanner.errorDetails(message, this.chars, this.index, this.ch);
    }
}

