/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.List;
import org.boon.Lists;
import org.boon.core.Typ;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MethodAccess;
import org.boon.json.JsonFactory;
import org.boon.primitive.CharBuf;
import org.boon.template.BoonTemplate;
import org.boon.template.Command;

public class InvokeCommand
implements Command {
    private Object function;
    private String methodName;
    private MethodAccess methodAccess;
    private String commandName;

    public InvokeCommand(Object function, MethodAccess methodAccess) {
        this.methodAccess = methodAccess;
        this.function = function;
    }

    public InvokeCommand(Object function) {
        this.function = function;
        this.init();
    }

    public InvokeCommand(Object function, String methodName) {
        this.function = function;
        this.methodName = methodName;
        this.init();
    }

    public void init() {
        this.methodAccess = this.function instanceof Class && this.methodName != null ? Invoker.invokeMethodAccess((Class)this.function, this.methodName) : (this.methodName != null ? Invoker.invokeMethodAccess(this.function, this.methodName) : Invoker.invokeFunctionMethodAccess(this.function));
    }

    @Override
    public void processCommand(CharBuf output, String args, CharSequence block, Object context) {
        block = block.toString();
        if (args.trim().startsWith("[") || args.startsWith("{") || args.startsWith("'")) {
            String arguments = BoonTemplate.template("${", "}").replace(args, context).toString();
            Object o = JsonFactory.fromJson(arguments.replace('\'', '\"'));
            if (o instanceof List) {
                List<Object> argList = Lists.copy((List)o);
                if (this.commandName != null) {
                    argList.add(0, this.commandName);
                }
                this.addArgs(block, context, argList);
                this.addArgs(block, context, argList);
                if (this.methodAccess.returnType() == Typ.string || this.methodAccess.returnType() == Typ.chars) {
                    CharSequence out = (CharSequence)Invoker.invokeFromList(this.function, this.methodAccess.name(), argList);
                    output.add(out);
                } else {
                    Invoker.invokeFromList(this.function, this.methodAccess.name(), argList);
                }
            }
        } else if (this.methodAccess.returnType() == Typ.string || this.methodAccess.returnType() == Typ.chars) {
            CharSequence out = this.commandName != null ? (CharSequence)this.methodAccess.invoke(this.commandName, this.function, args, block.toString(), context) : (CharSequence)this.methodAccess.invoke(this.function, args, block.toString(), context);
            output.add(out);
        } else if (this.commandName != null) {
            this.methodAccess.invoke(this.commandName, this.function, output, args, block.toString(), context);
        } else {
            this.methodAccess.invoke(this.function, output, args, block.toString(), context);
        }
    }

    private void addArgs(CharSequence block, Object context, List<Object> argList) {
        if (argList.size() < this.methodAccess.parameterTypes().length) {
            if (Typ.isCharSequence(this.methodAccess.parameterTypes()[argList.size()])) {
                argList.add(block);
            } else {
                argList.add(context);
            }
        }
    }
}

