/*
 * Decompiled with CFR 0.152.
 */
package org.boon.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.boon.config.ContextConfig;
import org.boon.config.MetaConfigEvents;
import org.boon.core.Predicate;
import org.boon.di.Context;
import org.boon.di.Inject;

public class ContextConfigReader {
    private static final String CONFIG_CLASSPATH_RESOURCE = System.getProperty("BOON_CONFIG_CLASSPATH_RESOURCE", "classpath://etc/boon/");
    private static final String CONFIG_DIR = System.getProperty("BOON_CONFIG_DIR", "/etc/boon/");
    private static final String RUNTIME_MODULE_NAME = System.getProperty("BOON_RUNTIME_MODULE_NAME", "boon");
    private static final String MODULE_CONFIG_DIR = System.getProperty("BOON_MODULE_CONFIG_DIR", CONFIG_DIR + RUNTIME_MODULE_NAME + "/");
    @Inject
    private boolean useNameSpacePrefix = false;
    @Inject
    private ContextConfig contextConfig = ContextConfig.JSON;
    @Inject
    private String namespace;
    @Inject
    private List<String> resources = new ArrayList<String>();
    @Inject
    private Predicate rules;

    public Context read() {
        if (this.resources.size() == 0) {
            this.resources.add(MODULE_CONFIG_DIR);
            this.resources.add(CONFIG_CLASSPATH_RESOURCE);
        }
        MetaConfigEvents metaConfigEvents = null;
        if (this.rules != null) {
            metaConfigEvents = new MetaConfigEvents(){

                @Override
                public boolean parsedMeta(Map<String, Object> meta) {
                    return ContextConfigReader.this.handleMeta(meta);
                }
            };
        }
        return this.contextConfig.createContext(this.namespace, this.useNameSpacePrefix, metaConfigEvents, this.resources);
    }

    private boolean handleMeta(Map<String, Object> meta) {
        return this.rules.test(meta);
    }

    public ContextConfigReader resource(String resource) {
        this.resources.add(resource);
        return this;
    }

    public ContextConfigReader resources(String ... resources) {
        for (String resource : resources) {
            this.resources.add(resource);
        }
        return this;
    }

    public ContextConfigReader userNamespacePrefix() {
        this.useNameSpacePrefix = true;
        return this;
    }

    public ContextConfigReader rule(Predicate criteria) {
        this.rules = criteria;
        return this;
    }

    public ContextConfigReader namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public static ContextConfigReader config() {
        return new ContextConfigReader();
    }
}

