/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.decorators;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.boon.Lists;
import org.boon.criteria.Update;
import org.boon.datarepo.ObjectEditor;
import org.boon.datarepo.impl.decorators.ObjectEditorDecoratorBase;
import org.boon.datarepo.modification.ModificationEvent;
import org.boon.datarepo.modification.ModificationListener;
import org.boon.datarepo.modification.ModificationType;

public class ObjectEditorEventDecorator<KEY, ITEM>
extends ObjectEditorDecoratorBase<KEY, ITEM> {
    List<ModificationListener<KEY, ITEM>> listeners = new CopyOnWriteArrayList<ModificationListener<KEY, ITEM>>();

    public void add(ModificationListener l) {
        this.listeners.add(l);
    }

    public void remove(ModificationListener l) {
        this.listeners.add(l);
    }

    public ObjectEditorEventDecorator() {
    }

    public ObjectEditorEventDecorator(ObjectEditor oe) {
        super(oe);
    }

    @Override
    public void modify(ITEM item) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, null, null));
        super.modify(item);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, null, null));
    }

    @Override
    public void update(ITEM item) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, super.getKey(item), item, null, null));
        super.modify(item);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, super.getKey(item), item, null, null));
    }

    private void fire(ModificationEvent<KEY, ITEM> event) {
        for (ModificationListener<KEY, ITEM> l : this.listeners) {
            l.modification(event);
        }
    }

    @Override
    public void modify(ITEM item, String property, Object value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modifyByValue(ITEM item, String property, String value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modifyByValue(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, int value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, long value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, char value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, short value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, byte value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, float value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, String property, double value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY, super.getKey(item), item, property, value));
        super.modify(item, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY, super.getKey(item), item, property, value));
    }

    @Override
    public void modify(ITEM item, Update ... values) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_MODIFY_BY_VALUE_SETTERS, super.getKey(item), item, null, values));
        super.modify(item, values);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_MODIFY_BY_VALUE_SETTERS, super.getKey(item), item, null, values));
    }

    @Override
    public void update(KEY key, String property, Object value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void updateByValue(KEY key, String property, String value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, int value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, long value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, char value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, short value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, byte value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, float value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, String property, double value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, value));
        super.update(key, property, value);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, value));
    }

    @Override
    public void update(KEY key, Update ... values) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE_BY_VALUE_SETTERS, key, (Object)null, null, values));
        super.update(key, values);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE_BY_VALUE_SETTERS, key, (Object)null, null, values));
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, Object compare, Object value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, int compare, int value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, long compare, long value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, char compare, char value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(Character.valueOf(compare), Character.valueOf(value))));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(Character.valueOf(compare), Character.valueOf(value))));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, short compare, short value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, byte compare, byte value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, float compare, float value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(Float.valueOf(compare), Float.valueOf(value))));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(Float.valueOf(compare), Float.valueOf(value))));
        }
        return updated;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, double compare, double value) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        boolean updated = super.compareAndUpdate(key, property, compare, value);
        if (updated) {
            this.fire(ModificationEvent.createModification(ModificationType.AFTER_UPDATE, key, (Object)null, property, Lists.list(compare, value)));
        }
        return updated;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, int compare) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_INCREMENT, key, (Object)null, property, compare));
        boolean updated = super.compareAndIncrement(key, property, compare);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_INCREMENT, key, (Object)null, property, compare));
        return updated;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, long compare) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_INCREMENT, key, (Object)null, property, compare));
        boolean updated = super.compareAndIncrement(key, property, compare);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_INCREMENT, key, (Object)null, property, compare));
        return updated;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, short compare) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_INCREMENT, key, (Object)null, property, compare));
        boolean updated = super.compareAndIncrement(key, property, compare);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_INCREMENT, key, (Object)null, property, compare));
        return updated;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, byte compare) {
        this.fire(ModificationEvent.createModification(ModificationType.BEFORE_INCREMENT, key, (Object)null, property, compare));
        boolean updated = super.compareAndIncrement(key, property, compare);
        this.fire(ModificationEvent.createModification(ModificationType.AFTER_INCREMENT, key, (Object)null, property, compare));
        return updated;
    }
}

