/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.boon.Exceptions;
import org.boon.core.Function;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.impl.indexes.MultiValue;
import org.boon.datarepo.spi.SPIFactory;

public class LookupIndexDefault<KEY, ITEM>
implements LookupIndex<KEY, ITEM> {
    protected Function<ITEM, KEY> keyGetter;
    protected Function<ITEM, KEY> primaryKeyGetter;
    protected Map<KEY, MultiValue> map;
    private Logger log = Logger.getLogger(LookupIndexDefault.class.getName());
    protected boolean storeKeyInIndexOnly;
    private Function<Object, KEY> keyTransformer;
    protected int keyBucketSize = 3;

    public LookupIndexDefault(Class<?> keyType) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("key type %s ", keyType.getName()));
        }
        if (keyType == null) {
            return;
        }
        this.map = SPIFactory.getMapCreatorFactory().get().createMap(keyType);
    }

    protected void addManyKeys(ITEM item, List<KEY> keys) {
        for (KEY key : keys) {
            if (key == null) continue;
            this.put(item, key);
        }
    }

    @Override
    public boolean add(ITEM item) {
        KEY key;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("addObject item = %s", item));
        }
        if ((key = this.keyGetter.apply(item)) == null) {
            return false;
        }
        this.put(item, key);
        return true;
    }

    private void put(ITEM item, KEY key) {
        MultiValue mv = null;
        Object primaryKey = null;
        try {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.format("put item = %s with key = %s ", item, key));
            }
            if ((key = this.getKey(key)) instanceof Collection) {
                Collection collection = (Collection)key;
                for (Object keyComponent : collection) {
                    if (keyComponent == null) continue;
                    mv = this.map.get(keyComponent);
                    mv = this.mvCreateOrAddToMV(mv, item);
                    this.map.put(keyComponent, mv);
                }
                return;
            }
            mv = this.map.get(key);
            if (this.storeKeyInIndexOnly) {
                primaryKey = this.primaryKeyGetter.apply(item);
                mv = this.mvCreateOrAddToMV(mv, primaryKey);
            } else {
                mv = this.mvCreateOrAddToMV(mv, item);
            }
            this.map.put(key, mv);
        }
        catch (Exception ex) {
            Exceptions.handle(ex, "Problem putting item in lookupWithDefault index, item=", item, "key=", key, "mv=", mv, "primaryKey=", primaryKey);
        }
    }

    private MultiValue mvCreateOrAddToMV(MultiValue mv, Object obj) {
        return MultiValue.add(mv, obj, this.keyBucketSize);
    }

    protected final void removeManyKeys(ITEM item, List<KEY> keys) {
        for (KEY key : keys) {
            if (key == null) continue;
            this.removeKey(item, key);
        }
    }

    @Override
    public boolean delete(ITEM item) {
        KEY key = this.keyGetter.apply(item);
        return this.removeKey(item, key);
    }

    private boolean removeKey(ITEM item, KEY key) {
        if ((key = this.getKey(key)) == null) {
            return false;
        }
        if (key instanceof Collection) {
            Collection collection = (Collection)key;
            for (Object objKey : collection) {
                this.removeKey(item, objKey);
            }
        } else {
            MultiValue<ITEM> mv = this.map.get(key);
            if (mv == null) {
                return false;
            }
            if ((mv = MultiValue.remove(mv, item)) == null) {
                this.map.remove(key);
            }
        }
        return true;
    }

    @Override
    public void setKeyGetter(Function<ITEM, KEY> keyGetter) {
        Exceptions.requireNonNull(keyGetter, "keyGetter cannot be null");
        this.keyGetter = keyGetter;
    }

    public void setPrimaryKeyGetter(Function<ITEM, KEY> keyGetter) {
        Exceptions.requireNonNull(keyGetter, "keyGetter cannot be null");
        this.storeKeyInIndexOnly = true;
        this.primaryKeyGetter = keyGetter;
    }

    @Override
    public List<ITEM> all() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("all called");
        }
        ArrayList results = new ArrayList(this.map.size());
        for (MultiValue values : this.map.values()) {
            values.addTo(results);
        }
        return results;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<ITEM> toCollection() {
        return this.map.values();
    }

    @Override
    public ITEM get(KEY key) {
        MultiValue mv = this.map.get(key = this.getKey(key));
        if (mv == null) {
            return null;
        }
        return (ITEM)mv.getValue();
    }

    protected KEY getKey(KEY key) {
        if (this.keyTransformer != null) {
            key = this.keyTransformer.apply(key);
        }
        return key;
    }

    @Override
    public List<ITEM> getAll(KEY key) {
        MultiValue mv = this.map.get(key = this.getKey(key));
        if (mv == null) {
            return null;
        }
        return mv.getValues();
    }

    @Override
    public boolean deleteByKey(KEY key) {
        key = this.getKey(key);
        this.map.remove(key);
        return true;
    }

    @Override
    public boolean isPrimaryKeyOnly() {
        return this.storeKeyInIndexOnly;
    }

    @Override
    public void setInputKeyTransformer(Function<Object, KEY> func) {
        this.keyTransformer = func;
    }

    @Override
    public void setBucketSize(int size) {
        this.keyBucketSize = size;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean has(KEY key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("clear called");
        }
        this.map.clear();
    }
}

