package org.boon.json.annotations;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Stops field or property from being serialized into JSON.
 * Does not stop field from being populated.
 *
 * @author Rick Hightower
 *
 */
@Target({ ElementType.METHOD, ElementType.FIELD })
@Retention( RetentionPolicy.RUNTIME)
public @interface Expose {

    boolean deserialize() default true;
    boolean serialize();
}
