/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.util.List;
import org.boon.StringScanner;
import org.boon.primitive.CharBuf;
import org.boon.primitive.Chr;

public class Str {
    public static final String EMPTY_STRING = "";

    public static int len(String str) {
        return str.length();
    }

    public static String slc(String str, int start) {
        return new String(Chr.slc(str.toCharArray(), start));
    }

    public static String slc(String str, int start, int end) {
        return new String(Chr.slc(str.toCharArray(), start, end));
    }

    public static String slcEnd(String str, int end) {
        return new String(Chr.slcEnd(str.toCharArray(), end));
    }

    public static char idx(String str, int index) {
        int i = Str.calculateIndex(str.length(), index);
        char c = str.charAt(i);
        return c;
    }

    public static String idx(String str, int index, char c) {
        char[] chars = str.toCharArray();
        Chr.idx(chars, index, c);
        return new String(chars);
    }

    public static boolean in(char c, String str) {
        for (int index = 0; index < str.length(); ++index) {
            char current = str.charAt(index);
            if (c != current) continue;
            return true;
        }
        return false;
    }

    public static boolean in(char c, int offset, String str) {
        int off;
        int length = str.length();
        for (int index = off = Str.calculateIndex(length, offset); index < length; ++index) {
            char current = str.charAt(index);
            if (c != current) continue;
            return true;
        }
        return false;
    }

    public static boolean in(char c, int offset, int end, String str) {
        int length = str.length();
        int off = Str.calculateIndex(length, offset);
        int stop = Str.calculateIndex(length, end);
        for (int index = off; index < stop; ++index) {
            char current = str.charAt(index);
            if (c != current) continue;
            return true;
        }
        return false;
    }

    public static String add(String str, char c) {
        return new String(Chr.add(str.toCharArray(), c));
    }

    public static String add(String str, String str2) {
        return new String(Chr.add(str.toCharArray(), str2.toCharArray()));
    }

    public static String add(String ... strings) {
        int length = 0;
        for (String str : strings) {
            if (str == null) continue;
            length += str.length();
        }
        CharBuf builder = CharBuf.createExact(length);
        for (String str : strings) {
            if (str == null) continue;
            builder.add(str);
        }
        return builder.toString();
    }

    public static String compact(String str) {
        return new String(Chr.compact(str.toCharArray()));
    }

    private static int calculateIndex(int length, int originalIndex) {
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    public static String[] split(String str) {
        char[][] split = Chr.split(str.toCharArray());
        return Str.fromCharArrayOfArrayToStringArray(split);
    }

    public static String[] splitLines(String str) {
        char[][] split = Chr.splitLine(str.toCharArray());
        return Str.fromCharArrayOfArrayToStringArray(split);
    }

    public static String[] fromCharArrayOfArrayToStringArray(char[][] split) {
        String[] results = new String[split.length];
        for (int index = 0; index < split.length; ++index) {
            char[] array = split[index];
            results[index] = array.length == 0 ? EMPTY_STRING : new String(array);
        }
        return results;
    }

    public static String upper(String str) {
        return str.toUpperCase();
    }

    public static String lower(String str) {
        return str.toLowerCase();
    }

    public static String camelCaseUpper(String in) {
        return Str.camelCase(in, true);
    }

    public static String camelCaseLower(String in) {
        return Str.camelCase(in, false);
    }

    public static String camelCase(String in) {
        return Str.camelCase(in, false);
    }

    public static String camelCase(String inStr, boolean upper) {
        char[] in = inStr.toCharArray();
        char[] out = Chr.camelCase(in, upper);
        return new String(out);
    }

    public static String underBarCase(String inStr) {
        char[] in = inStr.toCharArray();
        char[] out = Chr.underBarCase(in);
        return new String(out);
    }

    public static String lpad(String inStr, int size, char fill) {
        return new String(Chr.lpad(inStr.toCharArray(), size, fill));
    }

    public static String zfill(int num, int size) {
        return new String(Chr.lpad(Integer.toString(num).toCharArray(), size, '0'));
    }

    public static String rpad(String inStr, int size, char fill) {
        return new String(Chr.rpad(inStr.toCharArray(), size, fill));
    }

    public static String[] split(String input, char split) {
        return StringScanner.split(input, split);
    }

    public static boolean in(String value, String str) {
        return str.contains(value);
    }

    public static String lines(String ... lines) {
        return Str.join('\n', lines);
    }

    public static String join(char delim, String ... args) {
        CharBuf builder = CharBuf.create(10 * args.length);
        int index = 0;
        for (String arg : args) {
            builder.add(arg);
            if (index != args.length - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }

    public static String join(String ... args) {
        CharBuf builder = CharBuf.create(10 * args.length);
        for (String arg : args) {
            builder.add(arg);
        }
        return builder.toString();
    }

    public static String joinCollection(char delim, List<?> args) {
        CharBuf builder = CharBuf.create(10 * args.size());
        int index = 0;
        for (Object arg : args) {
            if (arg == null) continue;
            builder.add(arg.toString());
            if (index != args.size() - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }
}

