/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.boon.Exceptions;
import org.boon.Sets;
import org.boon.StringScanner;
import org.boon.core.Dates;
import org.boon.core.Typ;
import org.boon.core.Value;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.primitive.CharBuf;

public class Conversions {
    private static final Logger log = Logger.getLogger(Conversions.class.getName());
    static final Set<String> TRUE_SET = Sets.set("t", "true", "True", "y", "yes", "1", "aye", "T", "TRUE", "ok");

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Value) {
            return ((Value)obj).bigDecimalValue();
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        if (obj instanceof Number) {
            double val = ((Number)obj).doubleValue();
            return BigDecimal.valueOf(val);
        }
        return null;
    }

    public static BigInteger toBigInteger(Object obj) {
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        if (obj instanceof Value) {
            return ((Value)obj).bigIntegerValue();
        }
        if (obj instanceof String) {
            return new BigInteger((String)obj);
        }
        if (obj instanceof Number) {
            long val = ((Number)obj).longValue();
            return BigInteger.valueOf(val);
        }
        return null;
    }

    public static int toInt(Object obj) {
        return Conversions.toInt(obj, Integer.MIN_VALUE);
    }

    public static int toInt(Object obj, int defaultValue) {
        block13: {
            if (obj.getClass() == Integer.TYPE) {
                return Integer.TYPE.cast(obj);
            }
            try {
                if (obj instanceof Number) {
                    return ((Number)obj).intValue();
                }
                if (obj instanceof Boolean || obj.getClass() == Boolean.class) {
                    boolean value = Conversions.toBoolean(obj);
                    return value ? 1 : 0;
                }
                if (!(obj instanceof CharSequence)) break block13;
                try {
                    return Integer.parseInt(((CharSequence)obj).toString());
                }
                catch (Exception ex) {
                    char[] chars = Conversions.toString(obj).toCharArray();
                    boolean found = false;
                    CharBuf builder = CharBuf.create(chars.length);
                    for (char c : chars) {
                        if (Character.isDigit(c) && !found) {
                            found = true;
                            builder.add(c);
                            continue;
                        }
                        if (Character.isDigit(c) && found) {
                            builder.add(c);
                            continue;
                        }
                        if (!Character.isDigit(c) && !found) continue;
                    }
                    try {
                        if (builder.len() > 0) {
                            return Integer.parseInt(builder.toString());
                        }
                    }
                    catch (Exception ex2) {
                        log.warning(String.format("unable to convert to byte and there was an exception %s", ex2.getMessage()));
                    }
                }
            }
            catch (Exception ex1) {
                log.warning(String.format("unable to convert to byte and there was an exception %s", ex1.getMessage()));
            }
        }
        return defaultValue;
    }

    public static byte toByte(Object obj) {
        return Conversions.toByte(obj, (byte)-128);
    }

    public static byte toByte(Object obj, byte defaultByte) {
        if (obj.getClass() == Byte.TYPE) {
            return Byte.TYPE.cast(obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        return (byte)Conversions.toInt(obj, defaultByte);
    }

    public static short toShort(Object obj) {
        return Conversions.toShort(obj, (short)Short.MIN_VALUE);
    }

    public static short toShort(Object obj, short shortDefault) {
        if (obj.getClass() == Short.TYPE) {
            return Short.TYPE.cast(obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        return (short)Conversions.toInt(obj, shortDefault);
    }

    public static char toChar(Object obj) {
        return Conversions.toChar(obj, '\u0000');
    }

    public static char toChar(Object obj, char defaultChar) {
        if (obj.getClass() == Character.TYPE) {
            return Character.TYPE.cast(obj).charValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof CharSequence) {
            return obj.toString().charAt(0);
        }
        if (obj instanceof Number) {
            return (char)Conversions.toInt(obj);
        }
        if (obj instanceof Boolean || obj.getClass() == Boolean.class) {
            boolean value = Conversions.toBoolean(obj);
            return value ? (char)'T' : 'F';
        }
        if (obj.getClass().isPrimitive()) {
            return (char)Conversions.toInt(obj);
        }
        String str = Conversions.toString(obj);
        if (str.length() > 0) {
            return str.charAt(0);
        }
        return defaultChar;
    }

    public static long toLong(Object obj) {
        return Conversions.toLong(obj, Long.MIN_VALUE);
    }

    public static long toLong(Object obj, long longDefault) {
        block14: {
            if (obj.getClass() == Long.TYPE) {
                return Long.TYPE.cast(obj);
            }
            try {
                if (obj instanceof Number) {
                    return ((Number)obj).longValue();
                }
                if (obj instanceof CharSequence) {
                    try {
                        return Long.parseLong(((CharSequence)obj).toString());
                    }
                    catch (Exception ex) {
                        char[] chars = Conversions.toString(obj).toCharArray();
                        CharBuf builder = CharBuf.create(chars.length);
                        boolean found = false;
                        for (char c : chars) {
                            if (Character.isDigit(c) && !found) {
                                found = true;
                                builder.add(c);
                                continue;
                            }
                            if (Character.isDigit(c) && found) {
                                builder.add(c);
                                continue;
                            }
                            if (!Character.isDigit(c) && !found) continue;
                        }
                        try {
                            if (builder.len() > 0) {
                                return Long.parseLong(builder.toString());
                            }
                            break block14;
                        }
                        catch (Exception ex2) {
                            log.warning(String.format("unable to convert to long and there was an exception %s", ex2.getMessage()));
                        }
                        break block14;
                    }
                }
                if (obj instanceof Date) {
                    return ((Date)obj).getTime();
                }
                return Conversions.toInt(obj);
            }
            catch (Exception ex) {
                log.warning(String.format("unable to convert to long and there was an exception %s", ex.getMessage()));
            }
        }
        return longDefault;
    }

    public static boolean toBoolean(Object obj) {
        if (obj.getClass() == Boolean.TYPE) {
            return Boolean.TYPE.cast(obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number || obj.getClass().isPrimitive()) {
            int value = Conversions.toInt(obj);
            return value != 0;
        }
        if (obj instanceof String || obj instanceof CharSequence || obj.getClass() == char[].class) {
            String str = Conversions.toString(obj);
            if (str.length() == 0) {
                return false;
            }
            return Sets.in(str, TRUE_SET);
        }
        if (Reflection.isArray(obj) || obj instanceof Collection) {
            return Reflection.len(obj) > 0;
        }
        return Conversions.toBoolean(Conversions.toString(obj));
    }

    public static double toDouble(Object obj) {
        if (obj.getClass() == Double.TYPE) {
            return (Double)obj;
        }
        try {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof CharSequence) {
                try {
                    return Double.parseDouble(((CharSequence)obj).toString());
                }
                catch (Exception ex) {
                    Exceptions.die(String.format("Unable to convert %s to a double", obj.getClass()));
                    return Double.NaN;
                }
            }
        }
        catch (Exception ex) {
            log.warning(String.format("unable to convert to double and there was an exception %s", ex.getMessage()));
        }
        Exceptions.die(String.format("Unable to convert %s to a double", obj.getClass()));
        return -666.0;
    }

    public static float toFloat(Object obj) {
        if (obj.getClass() == Float.TYPE) {
            return ((Float)obj).floatValue();
        }
        try {
            if (obj instanceof Float) {
                return ((Float)obj).floatValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof CharSequence) {
                try {
                    return Float.parseFloat(((CharSequence)obj).toString());
                }
                catch (Exception ex) {
                    Exceptions.die(String.format("Unable to convert %s to a float", obj.getClass()));
                    return Float.NaN;
                }
            }
        }
        catch (Exception ex) {
            log.warning(String.format("unable to convert to float and there was an exception %s", ex.getMessage()));
        }
        Exceptions.die(String.format("Unable to convert %s to a float", obj.getClass()));
        return -666.0f;
    }

    public static <T> T coerce(Class<T> clz, Object value) {
        if (value == null) {
            return null;
        }
        if (clz == value.getClass()) {
            return (T)value;
        }
        if (clz == Typ.string || clz == Typ.chars) {
            return (T)value.toString();
        }
        if (clz == Typ.integer || clz == Typ.intgr) {
            Integer i = Conversions.toInt(value);
            return (T)i;
        }
        if (clz == Typ.longWrapper || clz == Typ.lng) {
            Long l = Conversions.toLong(value);
            return (T)l;
        }
        if (clz == Typ.doubleWrapper || clz == Typ.dbl) {
            Double i = Conversions.toDouble(value);
            return (T)i;
        }
        if (clz == Typ.date) {
            return (T)Conversions.toDate(value);
        }
        if (clz == Typ.bigInteger) {
            return (T)Conversions.toBigInteger(value);
        }
        if (clz == Typ.bigDecimal) {
            return (T)Conversions.toBigDecimal(value);
        }
        if (clz == Typ.calendar) {
            return (T)Conversions.toCalendar(Conversions.toDate(value));
        }
        if (clz == Typ.floatWrapper || clz == Typ.flt) {
            Float i = Float.valueOf(Conversions.toFloat(value));
            return (T)i;
        }
        if (clz == Typ.stringArray) {
            Exceptions.die("Need to fix this");
            return null;
        }
        if (clz == Typ.bool || clz == Typ.bln) {
            Boolean b = Conversions.toBoolean(value);
            return (T)b;
        }
        if (Typ.isMap(clz)) {
            if (value instanceof Map) {
                return (T)value;
            }
            return (T)Conversions.toMap(value);
        }
        if (clz.isArray()) {
            return Conversions.toPrimitiveArrayIfPossible(clz, value);
        }
        if (Typ.isCollection(clz)) {
            return Conversions.toCollection(clz, value);
        }
        if (clz != null && clz.getPackage() != null && !clz.getPackage().getName().startsWith("java") && Typ.isMap(value.getClass()) && Typ.doesMapHaveKeyTypeString(value)) {
            return (T)MapObjectConversion.fromMap((Map)value);
        }
        if (clz.isEnum()) {
            return Conversions.toEnum(clz, value);
        }
        return null;
    }

    public static <T extends Enum> T toEnum(Class<T> cls, String value) {
        return Enum.valueOf(cls, value);
    }

    public static <T extends Enum> T toEnum(Class<T> cls, int value) {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])cls.getEnumConstants()) {
            if (e.ordinal() != value) continue;
            return (T)e;
        }
        Exceptions.die("Can't convert ordinal value " + value + " into enum of type " + cls);
        return null;
    }

    public static <T extends Enum> T toEnum(Class<T> cls, Object value) {
        if (value instanceof Value) {
            return ((Value)value).toEnum(cls);
        }
        if (value instanceof CharSequence) {
            return Conversions.toEnum(cls, value.toString());
        }
        if (value instanceof Number || value.getClass().isPrimitive()) {
            int i = Conversions.toInt(value);
            return Conversions.toEnum(cls, i);
        }
        Exceptions.die("Can't convert  value " + value + " into enum of type " + cls);
        return null;
    }

    public static <T> T toPrimitiveArrayIfPossible(Class<T> clz, Object value) {
        if (clz == Typ.intArray) {
            return (T)Conversions.iarray(value);
        }
        if (clz == Typ.byteArray) {
            return (T)Conversions.barray(value);
        }
        if (clz == Typ.charArray) {
            return (T)Conversions.carray(value);
        }
        if (clz == Typ.shortArray) {
            return (T)Conversions.sarray(value);
        }
        if (clz == Typ.longArray) {
            return (T)Conversions.larray(value);
        }
        if (clz == Typ.floatArray) {
            return (T)Conversions.farray(value);
        }
        if (clz == Typ.doubleArray) {
            return (T)Conversions.darray(value);
        }
        if (value.getClass() == clz) {
            return (T)value;
        }
        int index = 0;
        Object newInstance = Array.newInstance(clz.getComponentType(), Reflection.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            Reflection.idx(newInstance, index, iterator.next());
            ++index;
        }
        return (T)newInstance;
    }

    public static double[] darray(Object value) {
        if (value.getClass() == Typ.shortArray) {
            return (double[])value;
        }
        double[] values = new double[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toFloat(iterator.next());
            ++index;
        }
        return values;
    }

    public static float[] farray(Object value) {
        if (value.getClass() == Typ.floatArray) {
            return (float[])value;
        }
        float[] values = new float[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toFloat(iterator.next());
            ++index;
        }
        return values;
    }

    public static long[] larray(Object value) {
        if (value.getClass() == Typ.shortArray) {
            return (long[])value;
        }
        long[] values = new long[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toLong(iterator.next());
            ++index;
        }
        return values;
    }

    public static short[] sarray(Object value) {
        if (value.getClass() == Typ.shortArray) {
            return (short[])value;
        }
        short[] values = new short[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toShort(iterator.next());
            ++index;
        }
        return values;
    }

    public static int[] iarray(Object value) {
        if (value.getClass() == Typ.intArray) {
            return (int[])value;
        }
        int[] values = new int[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toInt(iterator.next());
            ++index;
        }
        return values;
    }

    public static byte[] barray(Object value) {
        if (value.getClass() == Typ.byteArray) {
            return (byte[])value;
        }
        byte[] values = new byte[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toByte(iterator.next());
            ++index;
        }
        return values;
    }

    public static char[] carray(Object value) {
        if (value.getClass() == Typ.charArray) {
            return (char[])value;
        }
        char[] values = new char[Reflection.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toChar(iterator.next());
            ++index;
        }
        return values;
    }

    public static Iterator iterator(Object value) {
        return Conversions.iterator(null, value);
    }

    public static <T> Iterator<T> iterator(Class<T> class1, final Object value) {
        if (Reflection.isArray(value)) {
            final int length = Reflection.arrayLength(value);
            return new Iterator<T>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < length;
                }

                @Override
                public T next() {
                    Object next = Reflection.idx(value, this.i);
                    ++this.i;
                    return next;
                }

                @Override
                public void remove() {
                }
            };
        }
        if (Typ.isCollection(value.getClass())) {
            return ((Collection)value).iterator();
        }
        if (Typ.isMap(value.getClass())) {
            Iterator iterator = ((Map)value).values().iterator();
            return iterator;
        }
        return Collections.singleton(value).iterator();
    }

    public static <T> T toCollection(Class<T> clz, Object value) {
        if (Typ.isList(clz)) {
            return (T)Conversions.toList(value);
        }
        if (Typ.isSortedSet(clz)) {
            return (T)Conversions.toSortedSet(value);
        }
        if (Typ.isSet(clz)) {
            return (T)Conversions.toSet(value);
        }
        return (T)Conversions.toList(value);
    }

    public static List toList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList((Collection)value);
        }
        ArrayList<Object> list = new ArrayList<Object>(Reflection.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Set toSet(Object value) {
        if (value instanceof Set) {
            return (Set)value;
        }
        if (value instanceof Collection) {
            return new HashSet((Collection)value);
        }
        HashSet<Object> set = new HashSet<Object>(Reflection.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static SortedSet toSortedSet(Object value) {
        if (value instanceof Set) {
            return (SortedSet)value;
        }
        if (value instanceof Collection) {
            return new TreeSet((Collection)value);
        }
        TreeSet<Object> set = new TreeSet<Object>();
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static Map<String, Object> toMap(Object value) {
        return MapObjectConversion.toMap(value);
    }

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static Number toWrapper(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return Conversions.toWrapper((int)l);
        }
        return l;
    }

    public static Number toWrapper(int i) {
        if (i >= -128 && i <= 127) {
            return (byte)i;
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return i;
    }

    public static Object wrapAsObject(boolean i) {
        return i;
    }

    public static Object wrapAsObject(byte i) {
        return i;
    }

    public static Object wrapAsObject(short i) {
        return i;
    }

    public static Object wrapAsObject(int i) {
        return i;
    }

    public static Object wrapAsObject(long i) {
        return i;
    }

    public static Object wrapAsObject(double i) {
        return i;
    }

    public static Object wrapAsObject(float i) {
        return Float.valueOf(i);
    }

    public static Object toArrayGuessType(Collection<?> value) {
        Class<?> componentType = Reflection.getComponentType(value);
        Object array = Array.newInstance(componentType, value.size());
        Iterator<?> iterator = value.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Reflection.idx(array, index, iterator.next());
            ++index;
        }
        return array;
    }

    public static Object toArray(Class<?> componentType, Collection<?> value) {
        Object array = Array.newInstance(componentType, value.size());
        Iterator<?> iterator = value.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Reflection.idx(array, index, iterator.next());
            ++index;
        }
        return array;
    }

    public static <V> V[] array(Class<V> type, Collection<V> array) {
        return (Object[])Conversions.toArray(type, array);
    }

    public static Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Value) {
            return ((Value)object).dateValue();
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof Long) {
            return new Date((Long)object);
        }
        if (object instanceof String) {
            String val = (String)object;
            char[] chars = FastStringUtils.toCharArray(val);
            if (Dates.isISO8601QuickCheck(chars)) {
                return Dates.fromISO8601DateLoose(chars);
            }
            return Conversions.toDateUS(val);
        }
        return null;
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date toDate(Calendar c) {
        return c.getTime();
    }

    public static Date toDate(long value) {
        return new Date(value);
    }

    public static Date toDate(Long value) {
        return new Date(value);
    }

    public static Date toDate(String value) {
        try {
            return Conversions.toDateUS(value);
        }
        catch (Exception ex) {
            try {
                return DateFormat.getDateInstance(3).parse(value);
            }
            catch (ParseException e) {
                Exceptions.die("Unable to parse date");
                return null;
            }
        }
    }

    public static Date toDateUS(String string) {
        String[] split = StringScanner.splitByChars(string, '.', '\\', '/', ':');
        if (split.length == 3) {
            return Dates.getUSDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]));
        }
        if (split.length >= 6) {
            return Dates.getUSDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]), Conversions.toInt(split[3]), Conversions.toInt(split[4]), Conversions.toInt(split[5]));
        }
        Exceptions.die(String.format("Not able to parse %s into a US date", string));
        return null;
    }

    public static Date toEuroDate(String string) {
        String[] split = StringScanner.splitByChars(string, '.', '\\', '/', ':');
        if (split.length == 3) {
            return Dates.getEuroDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]));
        }
        if (split.length >= 6) {
            return Dates.getEuroDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]), Conversions.toInt(split[3]), Conversions.toInt(split[4]), Conversions.toInt(split[5]));
        }
        Exceptions.die(String.format("Not able to parse %s into a Euro date", string));
        return null;
    }

    public static <TO, FROM> List<TO> map(Converter<TO, FROM> converter, List<FROM> fromList) {
        ArrayList<TO> toList = new ArrayList<TO>(fromList.size());
        for (FROM from : fromList) {
            toList.add(converter.convert(from));
        }
        return toList;
    }

    public static <TO, FROM> List<TO> mapFilterNulls(Converter<TO, FROM> converter, List<FROM> fromList) {
        ArrayList<TO> toList = new ArrayList<TO>(fromList.size());
        for (FROM from : fromList) {
            TO converted = converter.convert(from);
            if (converted == null) continue;
            toList.add(converted);
        }
        return toList;
    }

    public static Object unifyList(Object o) {
        return Conversions.unifyList(o, null);
    }

    public static Object unifyList(Object o, List list) {
        if (list == null && !Reflection.isArray(o) && !(o instanceof Iterable)) {
            return o;
        }
        if (list == null) {
            list = new ArrayList<Object>(400);
        }
        if (Reflection.isArray(o)) {
            int length = Reflection.len(o);
            for (int index = 0; index < length; ++index) {
                Conversions.unifyList(Reflection.idx(o, index), list);
            }
        } else if (o instanceof Iterable) {
            Iterable i = (Iterable)o;
            for (Object item : i) {
                list = (List)Conversions.unifyList(item, list);
            }
        } else {
            list.add(o);
        }
        return list;
    }

    public Number coerceNumber(Object inputArgument, Class<?> paraType) {
        Number number = (Number)inputArgument;
        if (paraType == Integer.TYPE || paraType == Integer.class) {
            return number.intValue();
        }
        if (paraType == Double.TYPE || paraType == Double.class) {
            return number.doubleValue();
        }
        if (paraType == Float.TYPE || paraType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (paraType == Short.TYPE || paraType == Short.class) {
            return number.shortValue();
        }
        if (paraType == Byte.TYPE || paraType == Byte.class) {
            return number.byteValue();
        }
        return null;
    }

    public static interface Converter<TO, FROM> {
        public TO convert(FROM var1);
    }
}

