/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.boon.Arrays;
import org.boon.Maps;

public class LazyMap
extends AbstractMap<String, Object> {
    private Map<String, Object> map;
    private int size;
    private String[] keys;
    private Object[] values;

    public LazyMap() {
        this.keys = new String[5];
        this.values = new Object[5];
    }

    public LazyMap(int initialSize) {
        this.keys = new String[initialSize];
        this.values = new Object[initialSize];
    }

    @Override
    public Object put(String key, Object value) {
        if (this.map == null) {
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            if (this.size == this.keys.length) {
                this.keys = Arrays.grow(this.keys);
                this.values = Arrays.grow(this.values);
            }
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.buildIfNeeded();
        return this.map.entrySet();
    }

    @Override
    public int size() {
        if (this.map == null) {
            return this.size;
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return this.size == 0;
        }
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map == null) {
            throw new RuntimeException("wrong type of map");
        }
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.buildIfNeeded();
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        this.buildIfNeeded();
        return this.map.get(key);
    }

    private void buildIfNeeded() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>(this.size, 0.01f);
            for (int index = 0; index < this.size; ++index) {
                this.map.put(this.keys[index], this.values[index]);
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public Object remove(Object key) {
        if (this.map == null) {
            throw new RuntimeException("wrong type of map");
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map m) {
        if (this.map == null) {
            throw new RuntimeException("wrong type of map");
        }
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.size = 0;
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.map == null) {
            return null;
        }
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.map == null) {
            return java.util.Arrays.asList(this.values);
        }
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        if (this.map == null) {
            return false;
        }
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        if (this.map == null) {
            return "{}".hashCode();
        }
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this.map.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        if (this.map == null) {
            return null;
        }
        if (this.map instanceof LinkedHashMap) {
            return ((LinkedHashMap)this.map).clone();
        }
        return Maps.copy(this);
    }

    public LazyMap clearAndCopy() {
        LazyMap map = new LazyMap();
        for (int index = 0; index < this.size; ++index) {
            map.put(this.keys[index], this.values[index]);
        }
        this.size = 0;
        return map;
    }
}

