/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.MapField;

public class BeanUtils {
    public static Map<String, FieldAccess> getPropertyFieldAccessMap(Class<?> clazz) {
        return Reflection.getPropertyFieldAccessMapFieldFirst(clazz);
    }

    public static Map<String, FieldAccess> getFieldsFromObject(Object item) {
        Map<String, FieldAccess> fields = null;
        fields = BeanUtils.getPropertyFieldAccessMap(item.getClass());
        if (item instanceof Map) {
            fields = BeanUtils.getFieldsFromMap(fields, (Map)item);
        }
        return fields;
    }

    private static Map<String, FieldAccess> getFieldsFromMap(Map<String, FieldAccess> fields, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            fields.put(entry.getKey(), new MapField(entry.getKey()));
        }
        return fields;
    }

    public static void setPropertyValue(Object root, Object newValue, String ... properties) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(properties);
        Object object = root;
        Object parent = root;
        int index = 0;
        for (String property : properties) {
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            FieldAccess field = fields.get(property);
            if (StringScanner.isDigits(property)) {
                object = Reflection.idx(object, Integer.parseInt(property));
            } else {
                if (field == null) {
                    Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
                }
                if (index == properties.length - 1) {
                    field.setValue(object, newValue);
                } else {
                    object = field.getObject(object);
                }
            }
            ++index;
        }
    }

    public static Object getPropertyValue(Object root, String ... properties) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(properties);
        Object object = root;
        for (String property : properties) {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
            FieldAccess field = fields.get(property);
            if (StringScanner.isDigits(property)) {
                object = Reflection.idx(object, Integer.parseInt(property));
                continue;
            }
            if (field == null) {
                Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
            }
            object = field.getObject(object);
        }
        return object;
    }

    public static Class<?> getPropertyType(Object root, String property) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(property);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(root.getClass());
        FieldAccess field = fields.get(property);
        return field.getType();
    }

    public static <T> T idxGeneric(Class<T> t, Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return (T)BeanUtils.getPropByPath(object, properties);
    }

    public static <T> List<T> idxList(Class<T> cls, Object items, String ... path) {
        return (List)BeanUtils.getPropByPath(items, path);
    }

    public static Object getPropByPath(Object item, String ... path) {
        Object o = item;
        for (int index = 0; index < path.length; ++index) {
            String propName = path[index];
            if (o == null) {
                return null;
            }
            if (Reflection.isArray(o) || o instanceof Collection) {
                o = BeanUtils.getCollecitonProp(o, propName, index, path);
                break;
            }
            o = BeanUtils.getProp(o, propName);
        }
        return Conversions.unifyList(o);
    }

    public static Object idx(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyValue(object, properties);
    }

    public static Object idxRelax(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropByPath(object, properties);
    }

    private static Object getCollecitonProp(Object o, String propName, int index, String[] path) {
        o = BeanUtils.getFieldValues(o, propName);
        if (index + 1 == path.length) {
            return o;
        }
        return BeanUtils.getCollecitonProp(o, path[++index], index, path);
    }

    public static Object getProp(Object object, String property) {
        Class<?> cls;
        Map<String, FieldAccess> fields;
        if (object == null) {
            return null;
        }
        if (StringScanner.isDigits(property)) {
            object = Reflection.idx(object, Integer.parseInt(property));
        }
        if (!(fields = Reflection.getPropertyFieldAccessors(cls = object.getClass())).containsKey(property)) {
            fields = Reflection.getAllAccessorFields(cls);
        }
        if (!fields.containsKey(property)) {
            return null;
        }
        return fields.get(property).getValue(object);
    }

    public static int getPropertyInt(Object root, String ... properties) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(properties);
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        if (field.getType() == Typ.intgr) {
            return field.getInt(object);
        }
        return Conversions.toInt(field.getValue(object));
    }

    private static Object baseForGetProperty(Object root, String[] properties) {
        Object object = root;
        Map<String, FieldAccess> fields = null;
        for (int index = 0; index < properties.length - 1; ++index) {
            fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            String property = properties[index];
            FieldAccess field = fields.get(property);
            if (StringScanner.isDigits(property)) {
                object = Reflection.idx(object, Integer.parseInt(property));
                continue;
            }
            if (field == null) {
                Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
            }
            object = field.getObject(object);
        }
        return object;
    }

    public static int idxInt(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyInt(object, properties);
    }

    public static byte getPropertyByte(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.bt) {
            return field.getByte(object);
        }
        return Conversions.toByte(field.getValue(object));
    }

    public static byte idxByte(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyByte(object, properties);
    }

    public static float getPropertyFloat(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.flt) {
            return field.getFloat(object);
        }
        return Conversions.toFloat(field.getValue(object));
    }

    public static float idxFloat(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyFloat(object, properties);
    }

    public static short getPropertyShort(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.shrt) {
            return field.getShort(object);
        }
        return Conversions.toShort(field.getValue(object));
    }

    public static short idxShort(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyShort(object, properties);
    }

    public static char getPropertyChar(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.chr) {
            return field.getChar(object);
        }
        return Conversions.toChar(field.getValue(object));
    }

    public static char idxChar(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyChar(object, properties);
    }

    public static double getPropertyDouble(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.dbl) {
            return field.getDouble(object);
        }
        return Conversions.toDouble(field.getValue(object));
    }

    public static double idxDouble(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyDouble(object, properties);
    }

    public static long getPropertyLong(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.lng) {
            return field.getLong(object);
        }
        return Conversions.toLong(field.getValue(object));
    }

    public static long idxLong(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyLong(object, properties);
    }

    public static boolean getPropertyBoolean(Object root, String ... properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.getType() == Typ.bln) {
            return field.getBoolean(object);
        }
        return Conversions.toBoolean(field.getValue(object));
    }

    public static boolean idxBoolean(Object object, String path) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(path);
        String[] properties = StringScanner.splitByDelimiters(path, ".[]");
        return BeanUtils.getPropertyBoolean(object, properties);
    }

    public static <V> Map<String, V> collectionToMap(String propertyKey, Collection<V> values) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>(values.size());
        Iterator<V> iterator = values.iterator();
        for (V v : values) {
            String key = BeanUtils.idxGeneric(Typ.string, v, propertyKey);
            map.put(key, v);
        }
        return map;
    }

    public static void copyProperties(Object object, Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> props = properties.entrySet();
        for (Map.Entry<String, Object> entry : props) {
            BeanUtils.setPropertyValue(object, entry.getValue(), entry.getKey());
        }
    }

    public static Object getFieldValues(Object object, String key) {
        if (object == null) {
            return null;
        }
        if (Reflection.isArray(object) || object instanceof Collection) {
            Iterator iter = Conversions.iterator(object);
            ArrayList<Object> list = new ArrayList<Object>(Reflection.len(object));
            while (iter.hasNext()) {
                list.add(BeanUtils.getFieldValues(iter.next(), key));
            }
            return list;
        }
        return BeanUtils.getFieldValue(object, key);
    }

    private static Object getFieldValue(Object object, String key) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        Map<String, FieldAccess> fields = Reflection.getPropertyFieldAccessMapFieldFirst(cls);
        if (!fields.containsKey(key)) {
            return null;
        }
        return fields.get(key).getValue(object);
    }

    public static <T> T copy(T item) {
        if (item instanceof Cloneable) {
            try {
                Method method = item.getClass().getMethod("clone", null);
                method.setAccessible(true);
                return (T)method.invoke(item, (Object[])null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                return BeanUtils.fieldByFieldCopy(item);
            }
        }
        return BeanUtils.fieldByFieldCopy(item);
    }

    private static <T> T fieldByFieldCopy(T item) {
        Class<?> aClass = item.getClass();
        Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(item.getClass());
        Object clone = Reflection.newInstance(aClass);
        for (FieldAccess field : fields.values()) {
            try {
                Object value;
                if (field.isStatic()) continue;
                if (!field.isPrimitive() && !Typ.isBasicType(field.getType())) {
                    value = field.getObject(item);
                    if (value == null) {
                        field.setObject(clone, null);
                        continue;
                    }
                    field.setObject(clone, BeanUtils.copy(value));
                    continue;
                }
                if (field.isPrimitive()) {
                    field.setValue(clone, field.getValue(item));
                    continue;
                }
                value = field.getObject(item);
                if (value == null) {
                    field.setObject(clone, null);
                    continue;
                }
                field.setObject(clone, value);
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, "" + field, ex);
            }
        }
        return (T)clone;
    }
}

