/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.Value;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;

public class MapObjectConversion {
    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz) {
        return MapObjectConversion.fromMap(map, Reflection.newInstance(clazz));
    }

    public static <T> T fromMap(FieldsAccessor fieldFieldsAccessor, Map<String, Object> map, Class<T> clazz) {
        return MapObjectConversion.fromMap(fieldFieldsAccessor, map, Reflection.newInstance(clazz));
    }

    public static Object fromMap(Map<String, Object> map) {
        return MapObjectConversion.fromMap(FieldAccessMode.FIELD.create(false), map);
    }

    public static Object fromMap(FieldsAccessor fieldFieldsAccessor, Map<String, Object> map) {
        String className = (String)map.get("class");
        Object newInstance = Reflection.newInstance(className);
        return MapObjectConversion.fromMap(fieldFieldsAccessor, map, newInstance);
    }

    public static <T> T fromMap(Map<String, Object> map, T newInstance) {
        return MapObjectConversion.fromMap(FieldAccessMode.FIELD.create(false), map, newInstance);
    }

    public static <T> T fromMap(FieldsAccessor fieldsAccessor, Map<String, Object> map, T newInstance) {
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(newInstance.getClass());
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            FieldAccess field = fields.get(entry.getKey());
            if (field == null) continue;
            Class<?> value = entry.getValue();
            if (value instanceof Value) {
                if (((Value)((Object)value)).isContainer()) {
                    value = ((Value)((Object)value)).toValue();
                } else {
                    field.setFromValue(newInstance, (Value)((Object)value));
                    continue;
                }
            }
            if (value == null) {
                field.setObject(newInstance, null);
                continue;
            }
            if (value.getClass() == field.getType()) {
                field.setObject(newInstance, value);
                continue;
            }
            if (Typ.isBasicType((Object)value)) {
                field.setValue(newInstance, value);
                continue;
            }
            if (value instanceof Value) {
                field.setValue(newInstance, value);
                continue;
            }
            if (value instanceof Map) {
                Class<?> clazz = field.getType();
                value = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromMap(fieldsAccessor, (Map<String, Object>)((Map)((Object)value)), field.getType()) : MapObjectConversion.fromMap(fieldsAccessor, (Map)((Object)value));
                field.setObject(newInstance, value);
                continue;
            }
            if (value instanceof Collection) {
                MapObjectConversion.processCollectionFromMapUsingFields(fieldsAccessor, newInstance, field, (Collection)((Object)value));
                continue;
            }
            if (value instanceof Map[]) {
                MapObjectConversion.processArrayOfMaps(fieldsAccessor, newInstance, field, value);
                continue;
            }
            field.setValue(newInstance, value);
        }
        return newInstance;
    }

    public static <T> T fromValueMap(FieldsAccessor fieldsAccessor, Map<String, Value> map, Class<T> clazz) {
        return MapObjectConversion.fromValueMap(fieldsAccessor, map, Reflection.newInstance(clazz));
    }

    public static <T> T fromValueMap(FieldsAccessor fieldsAccessor, Map<String, Value> map) {
        try {
            String className = map.get("class").toString();
            Object newInstance = Reflection.newInstance(className);
            return (T)MapObjectConversion.fromValueMap(fieldsAccessor, map, newInstance);
        }
        catch (Exception ex) {
            return (T)Exceptions.handle(Object.class, Boon.sputs("fromValueMap", "map", map, "fieldAccessor", fieldsAccessor), ex);
        }
    }

    public static <T> T fromValueMap(FieldsAccessor fieldsAccessor, Map<String, Value> amap, T newInstance) {
        Map.Entry<String, Value>[] entries;
        int size;
        ValueMap map = (ValueMap)amap;
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(newInstance.getClass());
        if (!map.hydrated()) {
            size = map.len();
            entries = map.items();
        } else {
            size = map.size();
            entries = map.entrySet().toArray(new Map.Entry[size]);
        }
        if (size == 0 || entries == null) {
            return newInstance;
        }
        for (int index = 0; index < size; ++index) {
            Map.Entry<String, Value> entry = entries[index];
            String key = entry.getKey();
            FieldAccess field = fields.get(key);
            Class<Object> ovalue = entry.getValue();
            if (field == null) continue;
            if (ovalue instanceof Value) {
                Class<Object> value = ovalue;
                if (value.isContainer()) {
                    Object objValue = value.toValue();
                    if (objValue instanceof Map) {
                        Class<?> clazz = field.getType();
                        objValue = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromValueMap(fieldsAccessor, (Map<String, Value>)((Map)objValue), field.getType()) : MapObjectConversion.fromValueMap(fieldsAccessor, (Map)objValue);
                        field.setObject(newInstance, objValue);
                        continue;
                    }
                    if (!(objValue instanceof Collection)) continue;
                    MapObjectConversion.handleCollectionOfValues(fieldsAccessor, newInstance, field, (Collection)objValue);
                    continue;
                }
                field.setFromValue(newInstance, (Value)((Object)value));
                continue;
            }
            if (ovalue instanceof Map) {
                Class<?> clazz = field.getType();
                ovalue = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromValueMap(fieldsAccessor, (Map<String, Value>)((Map)((Object)ovalue)), field.getType()) : MapObjectConversion.fromValueMap(fieldsAccessor, (Map)((Object)ovalue));
                field.setObject(newInstance, ovalue);
                continue;
            }
            if (ovalue instanceof Collection) {
                MapObjectConversion.handleCollectionOfValues(fieldsAccessor, newInstance, field, (Collection)((Object)ovalue));
                continue;
            }
            field.setValue(newInstance, ovalue);
        }
        return newInstance;
    }

    public static <T> T fromValueMap(FieldsAccessor fieldsAccessor, ValueMapImpl map, T newInstance) {
        Map.Entry<String, Value>[] entries;
        int size;
        Map<String, FieldAccess> fields = fieldsAccessor.getFields(newInstance.getClass());
        if (!map.hydrated()) {
            size = map.len();
            entries = map.items();
        } else {
            size = map.size();
            entries = map.entrySet().toArray(new Map.Entry[size]);
        }
        if (size == 0 || entries == null) {
            return newInstance;
        }
        for (int index = 0; index < size; ++index) {
            Map.Entry<String, Value> entry = entries[index];
            String key = entry.getKey();
            FieldAccess field = fields.get(key);
            Value value = entry.getValue();
            if (value.isContainer()) {
                Object objValue = value.toValue();
                if (objValue instanceof Map) {
                    Class<?> clazz = field.getType();
                    objValue = !clazz.isInterface() && !Typ.isAbstract(clazz) ? MapObjectConversion.fromValueMap(fieldsAccessor, (Map<String, Value>)((Map)objValue), field.getType()) : MapObjectConversion.fromValueMap(fieldsAccessor, (Map)objValue);
                    field.setObject(newInstance, objValue);
                    continue;
                }
                if (!(objValue instanceof Collection)) continue;
                MapObjectConversion.handleCollectionOfValues(fieldsAccessor, newInstance, field, (Collection)objValue);
                continue;
            }
            field.setFromValue(newInstance, value);
        }
        return newInstance;
    }

    private static void processCollectionFromMapUsingFields(FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<?> collection) {
        Class<?> componentType = Reflection.getComponentType(collection);
        if (Typ.isMap(componentType)) {
            MapObjectConversion.handleCollectionOfMaps(fieldsAccessor, newInstance, field, collection);
        } else if (Typ.isValue(componentType)) {
            MapObjectConversion.handleCollectionOfValues(fieldsAccessor, newInstance, field, collection);
        } else if (field.getType().isInterface() && Typ.implementsInterface(collection.getClass(), field.getType())) {
            field.setValue(newInstance, collection);
        } else {
            Collection<Object> newCollection = Reflection.createCollection(field.getType(), collection.size());
            newCollection.addAll(collection);
            field.setValue(newInstance, newCollection);
        }
    }

    private static void processArrayOfMaps(FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Object value) {
        Map[] maps = (Map[])value;
        List<Map<String, Object>> list = Lists.list(maps);
        MapObjectConversion.handleCollectionOfMaps(fieldsAccessor, newInstance, field, list);
    }

    private static void handleCollectionOfMaps(FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Map<String, Object>> collectionOfMaps) {
        Collection<Object> newCollection = Reflection.createCollection(field.getType(), collectionOfMaps.size());
        Class<?> componentClass = field.getComponentClass();
        if (componentClass != null) {
            for (Map<String, Object> mapComponent : collectionOfMaps) {
                newCollection.add(MapObjectConversion.fromMap(mapComponent, componentClass));
            }
            field.setObject(newInstance, newCollection);
        }
    }

    private static void handleCollectionOfValues(FieldsAccessor fieldsAccessor, Object newInstance, FieldAccess field, Collection<Value> acollectionOfValues) {
        Collection<Value> collectionOfValues = acollectionOfValues;
        if (collectionOfValues instanceof ValueList) {
            collectionOfValues = ((ValueList)collectionOfValues).list();
        }
        Collection<Object> newCollection = Reflection.createCollection(field.getType(), collectionOfValues.size());
        Class<?> componentClass = field.getComponentClass();
        if (componentClass != null) {
            for (Value value : (List)collectionOfValues) {
                if (value.isContainer()) {
                    Object oValue = value.toValue();
                    if (!(oValue instanceof Map)) continue;
                    newCollection.add(MapObjectConversion.fromValueMap(fieldsAccessor, (Map<String, Value>)((Map)oValue), componentClass));
                    continue;
                }
                newCollection.add(Conversions.coerce(componentClass, value.toValue()));
            }
            field.setObject(newInstance, newCollection);
        }
    }

    public static Map<String, Object> toMap(Object object) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, FieldAccess> fieldMap = Reflection.getAllAccessorFields(object.getClass());
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(fieldMap.values());
        Collections.reverse(fields);
        class FieldToEntryConverter
        implements Conversions.Converter<Maps.Entry<String, Object>, FieldAccess> {
            final /* synthetic */ Object val$object;

            FieldToEntryConverter(Object object) {
                this.val$object = object;
            }

            @Override
            public Maps.Entry<String, Object> convert(FieldAccess from) {
                if (from.isReadOnly()) {
                    return null;
                }
                Maps.EntryImpl<String, Object> entry = new Maps.EntryImpl<String, Object>(from.getName(), from.getValue(this.val$object));
                return entry;
            }
        }
        List<Maps.Entry<String, Object>> entries = Conversions.mapFilterNulls(new FieldToEntryConverter(object), new ArrayList<FieldAccess>(fields));
        map.put("class", object.getClass().getName());
        for (Maps.Entry<String, Object> entry : entries) {
            Object value = entry.value();
            if (value == null) continue;
            if (Typ.isBasicType(value)) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Reflection.isArray(value) && Typ.isBasicType(value.getClass().getComponentType())) {
                map.put(entry.key(), entry.value());
                continue;
            }
            if (Reflection.isArray(value)) {
                int length = Reflection.arrayLength(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(length);
                for (int index = 0; index < length; ++index) {
                    Object item = Reflection.idx(value, index);
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Class<?> componentType = Reflection.getComponentType(collection, fieldMap.get(entry.key()));
                if (Typ.isBasicType(componentType)) {
                    map.put(entry.key(), value);
                    continue;
                }
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(collection.size());
                for (Object item : collection) {
                    if (item == null) continue;
                    list.add(MapObjectConversion.toMap(item));
                }
                map.put(entry.key(), list);
                continue;
            }
            if (value instanceof Map) continue;
            map.put(entry.key(), MapObjectConversion.toMap(value));
        }
        return map;
    }

    public static <T> List<T> convertListOfMapsToObjects(FieldsAccessor fieldsAccessor, Class<T> componentType, List<Object> list) {
        ArrayList<Class<T>> newList = new ArrayList<Class<T>>(list.size());
        for (Object obj : list) {
            if (obj instanceof Value) {
                obj = ((Value)obj).toValue();
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (map instanceof ValueMapImpl) {
                    newList.add(MapObjectConversion.fromValueMap(fieldsAccessor, (Map<String, Value>)map, componentType));
                    continue;
                }
                newList.add(MapObjectConversion.fromMap(fieldsAccessor, (Map<String, Object>)map, componentType));
                continue;
            }
            newList.add((Class<T>)Conversions.coerce(componentType, obj));
        }
        return newList;
    }
}

