/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Sets;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.Pair;
import org.boon.core.Sys;
import org.boon.core.Typ;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.PropertyField;
import org.boon.core.reflection.fields.ReflectField;
import org.boon.core.reflection.fields.UnsafeField;
import org.boon.primitive.CharBuf;
import sun.misc.Unsafe;

public class Reflection {
    private static final Logger log = Logger.getLogger(Reflection.class.getName());
    private static final Set<String> fieldSortNames = Sets.safeSet("name", "orderBy", "title", "key");
    private static final Set<String> fieldSortNamesSuffixes = Sets.safeSet("Name", "Title", "Key");
    private static boolean _useUnsafe;
    private static final boolean useUnsafe;
    private static final Context _context;
    private static WeakReference<Context> weakContext;

    public static Unsafe getUnsafe() {
        if (Reflection.context().control == null) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Reflection.context().control = (Unsafe)f.get(null);
                return Reflection.context().control;
            }
            catch (Exception e) {
                return null;
            }
        }
        return Reflection.context().control;
    }

    private static void setSortableField(Class<?> clazz, String fieldName) {
        Reflection.context()._sortableFields.put(clazz.getName(), fieldName);
    }

    private static String getSortableField(Class<?> clazz) {
        return (String)Reflection.context()._sortableFields.get(clazz.getName());
    }

    public static Object contextToHold() {
        return Reflection.context();
    }

    private static Context context() {
        if (_context != null) {
            return _context;
        }
        Context context = (Context)weakContext.get();
        if (context == null) {
            context = new Context();
            weakContext = new WeakReference<Context>(context);
        }
        return context;
    }

    public static Collection<Object> createCollection(Class<?> type, int size) {
        if (type == List.class) {
            return new ArrayList<Object>(size);
        }
        if (type == SortedSet.class) {
            return new TreeSet<Object>();
        }
        if (type == Set.class) {
            return new LinkedHashSet<Object>(size);
        }
        if (Typ.isList(type)) {
            return new ArrayList<Object>();
        }
        if (Typ.isSortedSet(type)) {
            return new TreeSet<Object>();
        }
        if (Typ.isSet(type)) {
            return new LinkedHashSet<Object>(size);
        }
        return new ArrayList<Object>(size);
    }

    private static void setAccessorFieldInCache(Class<? extends Object> theClass, boolean useUnsafe, Map<String, FieldAccess> map) {
        if (useUnsafe) {
            Reflection.context()._allAccessorUnsafeFieldsCache.put(theClass, map);
        } else {
            Reflection.context()._allAccessorReflectionFieldsCache.put(theClass, map);
        }
    }

    private static void setPropertyAccessorFieldsInCache(Class<? extends Object> theClass, Map<String, FieldAccess> map) {
        Reflection.context()._allAccessorPropertyFieldsCache.put(theClass, map);
    }

    private static Map<String, FieldAccess> getPropertyAccessorFieldsFromCache(Class<? extends Object> theClass) {
        return (Map)Reflection.context()._allAccessorPropertyFieldsCache.get(theClass);
    }

    private static Map<String, FieldAccess> getAccesorFieldFromCache(Class<? extends Object> theClass, boolean useUnsafe) {
        if (useUnsafe) {
            return (Map)Reflection.context()._allAccessorUnsafeFieldsCache.get(theClass);
        }
        return (Map)Reflection.context()._allAccessorReflectionFieldsCache.get(theClass);
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessMapFieldFirst(Class<?> clazz) {
        Map<String, FieldAccess> fieldsFallbacks = null;
        Map<String, FieldAccess> fieldsPrimary = null;
        fieldsPrimary = Reflection.getAllAccessorFields(clazz, true);
        fieldsFallbacks = Reflection.getPropertyFieldAccessors(clazz);
        Reflection.combineFieldMaps(fieldsFallbacks, fieldsPrimary);
        return fieldsPrimary;
    }

    private static void combineFieldMaps(Map<String, FieldAccess> fieldsFallbacks, Map<String, FieldAccess> fieldsPrimary) {
        for (Map.Entry<String, FieldAccess> field : fieldsFallbacks.entrySet()) {
            if (fieldsPrimary.containsKey(field.getKey())) continue;
            fieldsPrimary.put(field.getKey(), field.getValue());
        }
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessMapPropertyFirst(Class<?> clazz) {
        Map<String, FieldAccess> fieldsFallbacks = null;
        Map<String, FieldAccess> fieldsPrimary = null;
        fieldsFallbacks = Reflection.getAllAccessorFields(clazz, true);
        fieldsPrimary = Reflection.getPropertyFieldAccessors(clazz);
        Reflection.combineFieldMaps(fieldsFallbacks, fieldsPrimary);
        return fieldsPrimary;
    }

    public static boolean hasStringField(Object value1, String name) {
        Class<?> clz = value1.getClass();
        return Reflection.classHasStringField(clz, name);
    }

    public static boolean classHasStringField(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getType().equals(Typ.string) || !field.getName().equals(name) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return true;
        }
        return false;
    }

    public static boolean hasField(Object value1, String name) {
        return Reflection.classHasField(value1.getClass(), name);
    }

    public static boolean classHasField(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getName().equals(name) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return true;
        }
        return false;
    }

    public static String getFirstComparableOrPrimitive(Object value1) {
        return Reflection.getFirstComparableOrPrimitiveFromClass(value1.getClass());
    }

    public static String getFirstComparableOrPrimitiveFromClass(Class<?> clz) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getType().isPrimitive() && (!Typ.isComparable(field.getType()) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz)) continue;
            return field.getName();
        }
        return null;
    }

    public static String getFirstStringFieldNameEndsWith(Object value, String name) {
        return Reflection.getFirstStringFieldNameEndsWithFromClass(value.getClass(), name);
    }

    public static String getFirstStringFieldNameEndsWithFromClass(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getName().endsWith(name) || !field.getType().equals(Typ.string) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return field.getName();
        }
        return null;
    }

    public static String getSortableField(Object value1) {
        return Reflection.getSortableFieldFromClass(value1.getClass());
    }

    public static String getSortableFieldFromClass(Class<?> clazz) {
        String fieldName = Reflection.getSortableField(clazz);
        if (fieldName == null) {
            for (String name : fieldSortNames) {
                if (!Reflection.classHasStringField(clazz, name)) continue;
                fieldName = name;
                break;
            }
            if (fieldName == null) {
                String name;
                Iterator<String> i$ = fieldSortNamesSuffixes.iterator();
                while (i$.hasNext() && (fieldName = Reflection.getFirstStringFieldNameEndsWithFromClass(clazz, name = i$.next())) == null) {
                }
            }
            if (fieldName == null) {
                fieldName = Reflection.getFirstComparableOrPrimitiveFromClass(clazz);
            }
            if (fieldName == null) {
                Reflection.setSortableField(clazz, "NOT FOUND");
                Exceptions.die("Could not find a sortable field for type " + clazz);
            }
            Reflection.setSortableField(clazz, fieldName);
        }
        return fieldName;
    }

    public static boolean hasField(Class<?> aClass, String name) {
        Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(aClass);
        return fields.containsKey(name);
    }

    public static boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static int len(Object obj) {
        if (Reflection.isArray(obj)) {
            return Reflection.arrayLength(obj);
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        Exceptions.die("Not an array like object");
        return 0;
    }

    public static int arrayLength(Object obj) {
        return Array.getLength(obj);
    }

    private static void handle(Exception ex) {
        throw new ReflectionException(ex);
    }

    public static Object newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return Reflection.newInstance(clazz);
        }
        catch (Exception ex) {
            log.info(String.format("Unable to create this class %s", className));
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object newInstance = null;
        try {
            newInstance = _useUnsafe ? Reflection.getUnsafe().allocateInstance(clazz) : (Object)clazz.newInstance();
        }
        catch (Exception ex) {
            Reflection.handle(ex);
        }
        return (T)newInstance;
    }

    public static Class<?> getComponentType(Collection<?> collection, FieldAccess fieldAccess) {
        Class<?> clz = fieldAccess.getComponentClass();
        if (clz == null) {
            clz = Reflection.getComponentType(collection);
        }
        return clz;
    }

    public static Class<?> getComponentType(Collection<?> value) {
        if (value.size() > 0) {
            Object next = value.iterator().next();
            return next.getClass();
        }
        return Typ.object;
    }

    public static Map<String, FieldAccess> getAllAccessorFields(Class<? extends Object> theClass) {
        return Reflection.getAllAccessorFields(theClass, true);
    }

    public static Map<String, FieldAccess> getAllAccessorFields(Class<? extends Object> theClass, boolean useUnsafe) {
        Map<String, FieldAccess> map = Reflection.getAccesorFieldFromCache(theClass, useUnsafe);
        if (map == null) {
            List<FieldAccess> list = Conversions.map(new FieldConverter(useUnsafe), Reflection.getAllFields(theClass));
            map = new LinkedHashMap<String, FieldAccess>(list.size());
            for (FieldAccess fieldAccess : list) {
                map.put(fieldAccess.getAlias(), fieldAccess);
            }
            Reflection.setAccessorFieldInCache(theClass, useUnsafe, map);
        }
        return map;
    }

    public static List<Field> getAllFields(Class<? extends Object> theClass) {
        List<Field> list = Reflection.getFields(theClass);
        while (theClass != Typ.object) {
            theClass = theClass.getSuperclass();
            Reflection.getFields(theClass, list);
        }
        return list;
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessors(Class<? extends Object> theClass) {
        Map<String, FieldAccess> fields = Reflection.getPropertyAccessorFieldsFromCache(theClass);
        if (fields == null) {
            Map<String, Pair<Method>> methods = Reflection.getPropertySetterGetterMethods(theClass);
            fields = new LinkedHashMap<String, FieldAccess>();
            for (Map.Entry<String, Pair<Method>> entry : methods.entrySet()) {
                Pair<Method> methodPair = entry.getValue();
                String key = entry.getKey();
                PropertyField pf = new PropertyField(key, methodPair.getFirst(), methodPair.getSecond());
                fields.put(pf.getAlias(), pf);
            }
            Reflection.setPropertyAccessorFieldsInCache(theClass, fields);
        }
        return fields;
    }

    public static Map<String, Pair<Method>> getPropertySetterGetterMethods(Class<? extends Object> theClass) {
        String name;
        Method[] methods = theClass.getMethods();
        LinkedHashMap<String, Pair<Method>> methodMap = new LinkedHashMap<String, Pair<Method>>(methods.length);
        ArrayList<Method> getterMethodList = new ArrayList<Method>(methods.length);
        for (int index = 0; index < methods.length; ++index) {
            Method method = methods[index];
            name = method.getName();
            if (method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && name.startsWith("set")) {
                Pair<Method> pair = new Pair<Method>();
                pair.setFirst(method);
                String propertyName = Str.slc(name, 3);
                propertyName = Str.lower(Str.slc(propertyName, 0, 1)) + Str.slc(propertyName, 1);
                methodMap.put(propertyName, pair);
            }
            if (method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE || !name.startsWith("get") && !name.startsWith("is") || name.equals("getClass")) continue;
            getterMethodList.add(method);
        }
        for (Method method : getterMethodList) {
            name = method.getName();
            String propertyName = null;
            if (name.startsWith("is")) {
                propertyName = name.substring(2);
            } else if (name.startsWith("get")) {
                propertyName = name.substring(3);
            }
            propertyName = Str.lower(propertyName.substring(0, 1)) + propertyName.substring(1);
            Pair<Method> pair = (Pair<Method>)methodMap.get(propertyName);
            if (pair == null) {
                pair = new Pair<Method>();
                methodMap.put(propertyName, pair);
            }
            pair.setSecond(method);
        }
        return methodMap;
    }

    public static void getFields(Class<? extends Object> theClass, List<Field> list) {
        List<Field> more = Reflection.getFields(theClass);
        list.addAll(more);
    }

    public static List<Field> getFields(Class<? extends Object> theClass) {
        List<Field> list = Lists.list(theClass.getDeclaredFields());
        for (Field field : list) {
            field.setAccessible(true);
        }
        return list;
    }

    public static Iterator iterator(final Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (Reflection.isArray(o)) {
            return new Iterator(){
                int index = 0;
                int length = Reflection.len(o);

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                public Object next() {
                    Object value = Reflection.idx(o, this.index);
                    ++this.index;
                    return value;
                }

                @Override
                public void remove() {
                }
            };
        }
        return null;
    }

    public static String joinBy(char delim, Object ... args) {
        CharBuf builder = CharBuf.create(256);
        int index = 0;
        for (Object arg : args) {
            builder.add(arg.toString());
            if (index != args.length - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }

    public static List<Map<String, Object>> toListOfMaps(Collection<?> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object o : collection) {
            list.add(MapObjectConversion.toMap(o));
        }
        return list;
    }

    public static Object idx(Object object, int index) {
        if (Reflection.isArray(object)) {
            object = Array.get(object, index);
        } else if (object instanceof List) {
            object = Lists.idx((List)object, index);
        }
        return object;
    }

    public static void idx(Object object, int index, Object value) {
        try {
            if (Reflection.isArray(object)) {
                Array.set(object, index, value);
            } else if (object instanceof List) {
                Lists.idx((List)object, index, value);
            }
        }
        catch (Exception notExpected) {
            String msg = Str.lines("An unexpected error has occurred", "This is likely a programming error!", String.format("Object is %s, index is %s, and set is %s", object, index, value), String.format("The object is an array? %s", object == null ? "null" : Boolean.valueOf(object.getClass().isArray())), String.format("The object is of type %s", object == null ? "null" : object.getClass().getName()), String.format("The set is of type %s", value == null ? "null" : value.getClass().getName()), "");
            Exceptions.handle(msg, (Throwable)notExpected);
        }
    }

    static {
        try {
            Class.forName("sun.misc.Unsafe");
            _useUnsafe = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            _useUnsafe = false;
        }
        useUnsafe = _useUnsafe = _useUnsafe && !Boolean.getBoolean("org.boon.noUnsafe");
        weakContext = new WeakReference<Object>(null);
        boolean noStatics = Boolean.getBoolean("org.boon.noStatics");
        if (noStatics || Sys.inContainer()) {
            _context = null;
            weakContext = new WeakReference<Context>(new Context());
        } else {
            _context = new Context();
        }
        try {
            if (_useUnsafe) {
                Field field = String.class.getDeclaredField("value");
            }
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    private static class FieldConverter
    implements Conversions.Converter<FieldAccess, Field> {
        boolean thisUseUnsafe;

        FieldConverter(boolean useUnsafe) {
            this.thisUseUnsafe = useUnsafe;
        }

        @Override
        public FieldAccess convert(Field from) {
            if (useUnsafe && this.thisUseUnsafe) {
                return UnsafeField.createUnsafeField(from);
            }
            return new ReflectField(from);
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException() {
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }

    private static class Context {
        private Unsafe control;
        private Map<String, String> _sortableFields = new ConcurrentHashMap<String, String>();
        private Map<Class<?>, Map<String, FieldAccess>> _allAccessorReflectionFieldsCache = new ConcurrentHashMap(200);
        private Map<Class<?>, Map<String, FieldAccess>> _allAccessorPropertyFieldsCache = new ConcurrentHashMap(200);
        private Map<Class<?>, Map<String, FieldAccess>> _allAccessorUnsafeFieldsCache = new ConcurrentHashMap(200);

        private Context() {
        }
    }
}

