/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.boon.Lists;
import org.boon.core.Function;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Criteria;
import org.boon.criteria.Selector;
import org.boon.criteria.Sort;
import org.boon.criteria.Visitor;
import org.boon.datarepo.Filter;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.ResultSet;
import org.boon.datarepo.SearchableCollection;
import org.boon.datarepo.impl.RepoDefault;
import org.boon.datarepo.impl.indexes.UniqueLookupIndex;
import org.boon.datarepo.spi.FilterComposer;
import org.boon.datarepo.spi.SearchIndex;
import org.boon.datarepo.spi.SearchableCollectionComposer;

public class SearchableCollectionDefault<KEY, ITEM>
implements SearchableCollection<KEY, ITEM>,
SearchableCollectionComposer {
    private Logger log = Logger.getLogger(RepoDefault.class.getName());
    protected Map<String, LookupIndex> lookupIndexMap = new LinkedHashMap<String, LookupIndex>();
    protected Map<String, SearchIndex> searchIndexMap = new LinkedHashMap<String, SearchIndex>();
    protected Set<LookupIndex> indexes = new LinkedHashSet<LookupIndex>();
    protected Filter filter;
    protected Map<String, FieldAccess> fields = new LinkedHashMap<String, FieldAccess>();
    protected UniqueLookupIndex<KEY, ITEM> primaryIndex;
    protected Function<ITEM, KEY> primaryKeyGetter;
    protected String primaryKeyName;
    protected boolean removeDuplication = true;

    @Override
    public boolean delete(ITEM item) {
        for (LookupIndex index : this.indexes) {
            index.delete(item);
        }
        return true;
    }

    @Override
    public boolean add(ITEM item) {
        Objects.requireNonNull(item, "No nulls allowed in repo");
        KEY key = this.getKey(item);
        if (this.primaryIndex.has(key)) {
            return false;
        }
        this.validateIndexes(item);
        return true;
    }

    @Override
    public void validateIndexes(ITEM item) {
        for (LookupIndex index : this.indexes) {
            index.add(item);
        }
    }

    @Override
    public ITEM get(KEY key) {
        UniqueLookupIndex<KEY, ITEM> lookupIndex = this.primaryIndex;
        return lookupIndex.get(key);
    }

    @Override
    public KEY getKey(ITEM item) {
        return this.primaryKeyGetter.apply(item);
    }

    @Override
    public void setRemoveDuplication(boolean removeDuplication) {
        this.removeDuplication = removeDuplication;
    }

    @Override
    public int count(KEY key, String property, int value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, short value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, byte value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, long value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, char value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, Character.valueOf(value)));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, float value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, Float.valueOf(value)));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, double value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public int count(KEY key, String property, Object value) {
        SearchIndex index = this.searchIndexMap.get(property);
        if (index == null) {
            throw new IllegalStateException(String.format("No searchIndex was found so you can't do a count for \n key %s \t property %s \t set %s", key, property, value));
        }
        return index.count(key);
    }

    @Override
    public <T> T max(KEY key, String property, Class<T> type) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null) {
            return (T)this.fields.get(property).getValue(item);
        }
        return null;
    }

    @Override
    public String maxString(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null) {
            return (String)this.fields.get(property).getObject(item);
        }
        return null;
    }

    @Override
    public Number maxNumber(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null) {
            return (Number)this.fields.get(property).getValue(item);
        }
        return Double.NaN;
    }

    @Override
    public int maxInt(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null) {
            return this.fields.get(property).getInt(item);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public long maxLong(KEY key, String property) {
        FieldAccess field;
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null && (field = this.fields.get(property)).getType() == Long.TYPE) {
            return field.getLong(item);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public double maxDouble(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.max()) != null) {
            return this.fields.get(property).getDouble(item);
        }
        return -2.147483648E9;
    }

    @Override
    public <T> T min(KEY key, String property, Class<T> type) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null) {
            return (T)this.fields.get(property).getValue(item);
        }
        return null;
    }

    @Override
    public String minString(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null) {
            return (String)this.fields.get(property).getObject(item);
        }
        return "";
    }

    @Override
    public Number minNumber(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null) {
            return (Number)this.fields.get(property).getValue(item);
        }
        return Double.NaN;
    }

    @Override
    public int minInt(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null) {
            return this.fields.get(property).getInt(item);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public long minLong(KEY key, String property) {
        FieldAccess field;
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null && (field = this.fields.get(property)).getType() == Long.TYPE) {
            return field.getLong(item);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public double minDouble(KEY key, String property) {
        Object item;
        SearchIndex index = this.searchIndexMap.get(property);
        if (index != null && (item = index.min()) != null) {
            return this.fields.get(property).getDouble(item);
        }
        return Double.MAX_VALUE;
    }

    @Override
    public ResultSet<ITEM> results(Criteria ... expressions) {
        return this.filter.filter(expressions);
    }

    @Override
    public List<ITEM> query(Criteria ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this.all();
        }
        if (this.removeDuplication) {
            return this.filter.filter(expressions).removeDuplication().asList();
        }
        return this.filter.filter(expressions).asList();
    }

    @Override
    public List<ITEM> sortedQuery(String sortBy, Criteria ... expressions) {
        Sort asc = Sort.asc(sortBy);
        return this.sortedQuery(asc, expressions);
    }

    @Override
    public List<ITEM> sortedQuery(Sort sortBy, Criteria ... expressions) {
        List<ITEM> results = this.query(expressions);
        sortBy.sort(results);
        return results;
    }

    @Override
    public List<Map<String, Object>> queryAsMaps(Criteria ... expressions) {
        List<ITEM> items = this.query(expressions);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(items.size());
        for (ITEM item : items) {
            results.add(MapObjectConversion.toMap(item));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> sortedQuery(String sortBy, List<Selector> selectors, Criteria ... expressions) {
        Sort asc = Sort.asc(sortBy);
        return this.sortedQuery(asc, selectors, expressions);
    }

    @Override
    public List<Map<String, Object>> sortedQuery(Sort sortBy, List<Selector> selectors, Criteria ... expressions) {
        List<Map<String, Object>> results = this.query(selectors, expressions);
        sortBy.sort(results);
        return results;
    }

    private void visit(KEY key, ITEM item, Visitor<KEY, ITEM> visitor, Object o, List<String> path, int levels) {
        if (o == null) {
            return;
        }
        if (++levels > 20) {
            return;
        }
        visitor.visit(key, item, o, path);
        if (o.getClass().isPrimitive()) {
            return;
        }
        if (o.getClass().getName().startsWith("java")) {
            return;
        }
        if (Reflection.isArray(o) || o instanceof Collection) {
            int index = 0;
            Iterator iterator = Reflection.iterator(o);
            while (iterator.hasNext()) {
                path.add(String.format("[%s]", index));
                Object objectItem = iterator.next();
                this.visit(key, item, visitor, objectItem, path, levels);
                path.remove(path.size() - 1);
                ++index;
            }
        }
        Map<String, FieldAccess> accessorFields = Reflection.getAllAccessorFields(o.getClass());
        for (FieldAccess field : accessorFields.values()) {
            if (field.isStatic()) continue;
            path.add(field.getName());
            this.visit(key, item, visitor, field.getValue(o), path, levels);
            path.remove(path.size() - 1);
        }
    }

    @Override
    public void query(Visitor<KEY, ITEM> visitor, Criteria ... expressions) {
        List<ITEM> items = this.query(expressions);
        for (ITEM item : items) {
            KEY key = this.primaryKeyGetter.apply(item);
            int levels = 0;
            this.visit(key, item, visitor, item, Lists.list("root"), levels);
        }
    }

    @Override
    public void sortedQuery(Visitor<KEY, ITEM> visitor, String sortBy, Criteria ... expressions) {
        Sort asc = Sort.asc(sortBy);
        this.sortedQuery(visitor, asc, expressions);
    }

    @Override
    public void sortedQuery(Visitor<KEY, ITEM> visitor, Sort sortBy, Criteria ... expressions) {
        List<ITEM> items = this.sortedQuery(sortBy, expressions);
        for (ITEM item : items) {
            KEY key = this.primaryKeyGetter.apply(item);
            int levels = 0;
            this.visit(key, item, visitor, item, Lists.list("root"), levels);
        }
    }

    @Override
    public List<Map<String, Object>> query(List<Selector> selectors, Criteria ... expressions) {
        List<ITEM> results = this.query(expressions);
        return Selector.performSelection(selectors, results, this.fields);
    }

    @Override
    public void invalidateIndex(String property, ITEM item) {
        LookupIndex index = this.searchIndexMap.get(property);
        if (index != null) {
            index.delete(item);
        }
        if ((index = this.lookupIndexMap.get(property)) != null) {
            index.delete(item);
        }
        this.filter.invalidate();
    }

    @Override
    public void validateIndex(String property, ITEM item) {
        LookupIndex index = this.searchIndexMap.get(property);
        if (index != null) {
            index.add(item);
        }
        if ((index = this.lookupIndexMap.get(property)) != null) {
            index.add(item);
        }
    }

    @Override
    public void clear() {
        for (LookupIndex index : this.indexes) {
            index.clear();
        }
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void addSearchIndex(String name, SearchIndex si) {
        this.log.config(String.format("search index added name %s", name));
        this.searchIndexMap.put(name, si);
        this.indexes.add(si);
    }

    @Override
    public void addLookupIndex(String name, LookupIndex si) {
        this.log.config(String.format("lookup index added name %s", name));
        this.lookupIndexMap.put(name, si);
        this.indexes.add(si);
    }

    @Override
    public List<ITEM> all() {
        return this.primaryIndex.all();
    }

    @Override
    public void setPrimaryKeyName(String primaryKey) {
        this.primaryKeyName = primaryKey;
    }

    public Collection<ITEM> toCollection() {
        return this.primaryIndex.toCollection();
    }

    @Override
    public boolean isEmpty() {
        return this.primaryIndex.toCollection().isEmpty();
    }

    @Override
    public Iterator<ITEM> iterator() {
        return this.primaryIndex.toCollection().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.primaryIndex.toCollection().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.primaryIndex.toCollection().toArray(a);
    }

    @Override
    public void setPrimaryKeyGetter(Function getter) {
        this.log.config(String.format("primary key getter set %s", getter));
        this.primaryKeyGetter = getter;
    }

    @Override
    public void init() {
        this.primaryIndex = (UniqueLookupIndex)this.lookupIndexMap.get(this.primaryKeyName);
        if (this.filter instanceof FilterComposer) {
            FilterComposer fc = (FilterComposer)((Object)this.filter);
            fc.setFields(this.fields);
            fc.setLookupIndexMap(this.lookupIndexMap);
            fc.setSearchIndexMap(this.searchIndexMap);
            fc.setSearchableCollection(this);
            fc.init();
        }
        this.indexes.add(this.primaryIndex);
    }

    @Override
    public void setFields(Map<String, FieldAccess> fields) {
        this.fields = fields;
    }

    @Override
    public int size() {
        return this.primaryIndex.size();
    }

    @Override
    public boolean addAll(Collection<? extends ITEM> items) {
        for (ITEM item : items) {
            this.add(item);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Object key = null;
        Object item = null;
        try {
            key = o;
            this.removeByKey(key);
        }
        catch (ClassCastException ex) {
            item = o;
            this.delete(item);
        }
        return true;
    }

    @Override
    public void removeByKey(KEY key) {
        ITEM item = this.get(key);
        this.delete(item);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            KEY key = null;
            Object item = null;
            try {
                key = (KEY)object;
                item = this.get(key);
            }
            catch (ClassCastException ex) {
                Object itemArg = object;
                key = this.getKey(itemArg);
                item = this.get(key);
            }
            if (item != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        for (Object o : items) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (Object object : c) {
            KEY key = null;
            Object item = null;
            try {
                key = (KEY)object;
                item = this.get(key);
            }
            catch (ClassCastException ex) {
                item = object;
            }
            if (item != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        Object key = null;
        Object item = null;
        try {
            key = o;
            item = this.get(key);
        }
        catch (ClassCastException ex) {
            Object itemArg = o;
            key = this.getKey(itemArg);
            item = this.get(key);
        }
        return item == null;
    }
}

