/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.json.JsonParser;
import org.boon.json.JsonParserImpl;
import org.boon.json.implementation.JsonAsciiParser;
import org.boon.json.implementation.JsonFastParser;
import org.boon.json.implementation.JsonParserLax;
import org.boon.json.implementation.JsonUTF8Parser;
import org.boon.json.implementation.PlistParser;

public class JsonParserFactory {
    private Charset charset = null;
    private boolean lax;
    private boolean chop = false;
    private boolean lazyChop = true;
    private FieldAccessMode fieldAccessType = FieldAccessMode.FIELD;
    private boolean useAnnotations;

    public FieldAccessMode getFieldAccessType() {
        return this.fieldAccessType;
    }

    public boolean isChop() {
        return this.chop;
    }

    public JsonParserFactory setChop(boolean chop) {
        this.chop = chop;
        return this;
    }

    public boolean isLazyChop() {
        return this.lazyChop;
    }

    public JsonParserFactory setLazyChop(boolean lazyChop) {
        this.lazyChop = lazyChop;
        return this;
    }

    public JsonParserFactory lax() {
        this.lax = true;
        return this;
    }

    public JsonParserFactory strict() {
        this.lax = false;
        return this;
    }

    public JsonParserFactory setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JsonParser createFastParser() {
        JsonFastParser jsonParser = new JsonFastParser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), false, true);
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParser createUTF8DirectByteParser() {
        JsonUTF8Parser jsonParser = new JsonUTF8Parser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations));
        jsonParser.setCharset(StandardCharsets.UTF_8);
        return jsonParser;
    }

    public JsonParser createASCIIParser() {
        JsonAsciiParser jsonParser = new JsonAsciiParser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations));
        jsonParser.setCharset(StandardCharsets.US_ASCII);
        return jsonParser;
    }

    public JsonParser createLaxParser() {
        JsonParserLax jsonParser = new JsonParserLax(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), false, this.chop, this.lazyChop);
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParser createPlistParser() {
        if (this.charset == null) {
            this.charset = StandardCharsets.US_ASCII;
        }
        PlistParser jsonParser = new PlistParser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), false, this.chop, this.lazyChop);
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParser createLazyFinalParser() {
        JsonFastParser jsonParser = new JsonFastParser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), false, this.chop, this.lazyChop);
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParser createJsonParserForJsonPath() {
        JsonFastParser jsonParser = new JsonFastParser(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), false, this.chop, this.lazyChop);
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParser create() {
        if (this.charset == null) {
            this.charset = StandardCharsets.UTF_8;
        }
        return new JsonParserImpl(FieldAccessMode.create(this.fieldAccessType, this.useAnnotations), this.charset, this.lax, this.chop, this.lazyChop);
    }

    public boolean isUsePropertiesFirst() {
        return this.fieldAccessType == FieldAccessMode.PROPERTY_THEN_FIELD;
    }

    public JsonParserFactory usePropertiesFirst() {
        this.fieldAccessType = FieldAccessMode.PROPERTY_THEN_FIELD;
        return this;
    }

    public boolean isUseFieldsFirst() {
        return this.fieldAccessType == FieldAccessMode.FIELD_THEN_PROPERTY;
    }

    public JsonParserFactory useFieldsFirst() {
        this.fieldAccessType = FieldAccessMode.FIELD_THEN_PROPERTY;
        return this;
    }

    public JsonParserFactory useFieldsOnly() {
        this.fieldAccessType = FieldAccessMode.FIELD;
        return this;
    }

    public JsonParserFactory usePropertyOnly() {
        this.fieldAccessType = FieldAccessMode.PROPERTY;
        return this;
    }

    public JsonParserFactory useAnnotations() {
        this.useAnnotations = true;
        return this;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public JsonParserFactory setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
        return this;
    }
}

