/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.core.Typ;
import org.boon.core.Value;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.json.JsonParser;
import org.boon.json.implementation.BaseJsonParser;
import org.boon.json.implementation.JsonFastParser;
import org.boon.json.implementation.JsonParserLax;
import org.boon.primitive.CharBuf;

public class JsonParserImpl
extends BaseJsonParser
implements JsonParser {
    private final JsonParser objectParser;
    private final JsonParser basicParser;
    private int bufSize = 32;
    private CharBuf charBuf;

    public JsonParserImpl(FieldsAccessor fields, Charset charset, boolean lax, boolean chop, boolean lazyChop) {
        super(fields);
        this.charset = charset;
        if (lax) {
            this.basicParser = new JsonParserLax(fields, false, chop, lazyChop);
            this.objectParser = new JsonParserLax(fields, true);
        } else {
            this.basicParser = new JsonFastParser(fields, false, chop, lazyChop);
            this.objectParser = new JsonFastParser(fields, true);
        }
        ((BaseJsonParser)this.basicParser).setCharset(charset);
        ((BaseJsonParser)this.objectParser).setCharset(charset);
    }

    @Override
    public final <T> T parse(Class<T> type, String value) {
        if (type == Object.class || type == Map.class || type == List.class || Typ.isBasicType(type)) {
            T obj = this.basicParser.parse(type, value);
            return obj;
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, byte[] value) {
        if (type == Object.class || type == Map.class || type == List.class) {
            if (value.length < 100000) {
                return this.basicParser.parse(type, value);
            }
            return this.basicParser.parseAsStream(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, byte[] value, Charset charset) {
        if (type == Object.class || type == Map.class || type == List.class) {
            return this.basicParser.parse(type, value, charset);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, CharSequence value) {
        if (type == Object.class || type == Map.class || type == List.class) {
            return this.basicParser.parse(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, char[] value) {
        if (type == Object.class || type == Map.class || type == List.class) {
            return this.basicParser.parse(type, value);
        }
        Map objectMap = this.objectParser.parse(Map.class, value);
        return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)objectMap, type);
    }

    @Override
    public final <T> T parse(Class<T> type, Reader reader) {
        this.charBuf = IO.read(reader, this.charBuf, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseFile(Class<T> type, String fileName) {
        int bufSize = this.bufSize;
        try {
            Path filePath = IO.path(fileName);
            long size = Files.size(filePath);
            size = size > 2000000000L ? (long)bufSize : size;
            this.bufSize = (int)size;
            if (size < 1000000L) {
                T t = this.parse(type, Files.newInputStream(filePath, new OpenOption[0]));
                return t;
            }
            T t = this.parse(type, Files.newBufferedReader(filePath, this.charset));
            return t;
        }
        catch (IOException ex) {
            T t = Exceptions.handle(type, fileName, ex);
            return t;
        }
        finally {
            this.bufSize = bufSize;
        }
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.basicParser.parse(bytes, charset);
    }

    @Override
    public Object parse(char[] chars) {
        return this.basicParser.parse(chars);
    }

    @Override
    public final <T> T parse(Class<T> type, InputStream input) {
        this.charBuf = IO.read(input, this.charBuf, this.charset, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    @Override
    public final <T> T parse(Class<T> type, InputStream input, Charset charset) {
        this.charBuf = IO.read(input, this.charBuf, charset, this.bufSize);
        return this.parse(type, this.charBuf.readForRecycle());
    }

    @Override
    public final <T> T parseDirect(Class<T> type, byte[] value) {
        if (value.length < 20000 && this.charset == StandardCharsets.UTF_8) {
            CharBuf builder = CharBuf.createFromUTF8Bytes(value);
            return this.parse(type, builder.toCharArray());
        }
        return this.parse(type, new ByteArrayInputStream(value));
    }

    @Override
    public final <T> T parseAsStream(Class<T> type, byte[] value) {
        this.charBuf = IO.read(new InputStreamReader((InputStream)new ByteArrayInputStream(value), this.charset), this.charBuf, value.length);
        return this.basicParser.parse(type, this.charBuf.readForRecycle());
    }
}

