/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.Value;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.ValueMapImpl;
import org.boon.json.JsonParser;
import org.boon.primitive.CharBuf;

public abstract class BaseJsonParser
implements JsonParser {
    protected static final int COMMA = 44;
    protected static final int CLOSED_CURLY = 125;
    protected static final int CLOSED_BRACKET = 93;
    protected static final int LETTER_E = 101;
    protected static final int LETTER_BIG_E = 69;
    protected static final int MINUS = 45;
    protected static final int PLUS = 43;
    protected static final int DECIMAL_POINT = 46;
    protected static final int ALPHA_0 = 48;
    protected static final int ALPHA_1 = 49;
    protected static final int ALPHA_2 = 50;
    protected static final int ALPHA_3 = 51;
    protected static final int ALPHA_4 = 52;
    protected static final int ALPHA_5 = 53;
    protected static final int ALPHA_6 = 54;
    protected static final int ALPHA_7 = 55;
    protected static final int ALPHA_8 = 56;
    protected static final int ALPHA_9 = 57;
    protected static final int DOUBLE_QUOTE = 34;
    protected static final int ESCAPE = 92;
    protected final FieldsAccessor fieldsAccessor;
    protected static final boolean internKeys = Boolean.parseBoolean(System.getProperty("org.boon.json.implementation.internKeys", "false"));
    protected static ConcurrentHashMap<String, String> internedKeysCache;
    protected Charset charset = StandardCharsets.UTF_8;
    protected int bufSize = 256;
    private final CharBuf builder = CharBuf.create(20);
    private CharBuf fileInputBuf;
    int[] indexHolder = new int[1];

    public BaseJsonParser(FieldsAccessor fieldsAccessor) {
        this.fieldsAccessor = fieldsAccessor;
    }

    protected String charDescription(char c) {
        String charString = c == ' ' ? "[SPACE]" : (c == '\t' ? "[TAB]" : (c == '\n' ? "[NEWLINE]" : "'" + c + "'"));
        charString = charString + " with an int value of " + c;
        return charString;
    }

    protected final <T> T convert(Class<T> type, Object object) {
        if (type == Map.class || type == List.class) {
            return (T)object;
        }
        if (object instanceof ValueMapImpl) {
            return (T)MapObjectConversion.fromValueMap(this.fieldsAccessor, (Map<String, Value>)((Map)object), type);
        }
        if (object instanceof Map) {
            return (T)MapObjectConversion.fromMap(this.fieldsAccessor, (Map<String, Object>)((Map)object), type);
        }
        if (object instanceof Value && Typ.isBasicType(type)) {
            return (T)((Value)object).toValue();
        }
        if (object instanceof List) {
            return (T)MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, type, (List)object);
        }
        return (T)object;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Map<String, Object> parseMap(String jsonString) {
        return (Map)this.parse(jsonString);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, String jsonString) {
        List list = this.parse(List.class, jsonString);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, Reader reader) {
        List list = this.parse(List.class, reader);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input) {
        List list = this.parse(List.class, input);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input, Charset charset) {
        List list = this.parse(List.class, input, charset);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes) {
        List list = this.parse(List.class, jsonBytes);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes, Charset charset) {
        List list = this.parse(List.class, jsonBytes, charset);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, char[] chars) {
        List list = this.parse(List.class, chars);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, CharSequence jsonSeq) {
        List list = this.parse(List.class, jsonSeq);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseListFromFile(Class<T> componentType, String fileName) {
        List list = this.parseFile(List.class, fileName);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public Date parseDate(String jsonString) {
        return Conversions.toDate(this.parse(jsonString));
    }

    @Override
    public Date parseDate(InputStream input) {
        return Conversions.toDate(this.parse(input));
    }

    @Override
    public Date parseDate(InputStream input, Charset charset) {
        return Conversions.toDate(this.parse(input));
    }

    @Override
    public Date parseDate(byte[] jsonBytes) {
        return Conversions.toDate(this.parse(jsonBytes));
    }

    @Override
    public Date parseDate(byte[] jsonBytes, Charset charset) {
        return Conversions.toDate(this.parse(jsonBytes, charset));
    }

    @Override
    public Date parseDate(char[] chars) {
        return Conversions.toDate(this.parse(chars));
    }

    @Override
    public Date parseDate(CharSequence jsonSeq) {
        return Conversions.toDate(this.parse(jsonSeq));
    }

    @Override
    public Date parseDateFromFile(String fileName) {
        return Conversions.toDate(this.parseFile(fileName));
    }

    @Override
    public float[] parseFloatArray(String jsonString) {
        List list = (List)this.parse(jsonString);
        return Conversions.farray(list);
    }

    @Override
    public double[] parseDoubleArray(String jsonString) {
        List list = (List)this.parse(jsonString);
        return Conversions.darray(list);
    }

    @Override
    public long[] parseLongArray(String jsonString) {
        List list = (List)this.parse(jsonString);
        return Conversions.larray(list);
    }

    @Override
    public int[] parseIntArray(String jsonString) {
        List list = (List)this.parse(jsonString);
        return Conversions.iarray(list);
    }

    @Override
    public <T extends Enum> T parseEnum(Class<T> type, String jsonString) {
        Object obj = this.parse(jsonString);
        return Conversions.toEnum(type, obj);
    }

    @Override
    public short parseShort(String jsonString) {
        return Conversions.toShort(this.parse(jsonString));
    }

    @Override
    public byte parseByte(String jsonString) {
        return Conversions.toByte(this.parse(jsonString));
    }

    @Override
    public char parseChar(String jsonString) {
        return Conversions.toChar(this.parse(jsonString));
    }

    @Override
    public char[] parseCharArray(String jsonString) {
        return Conversions.carray(this.parse(jsonString));
    }

    @Override
    public byte[] parseByteArray(String jsonString) {
        return Conversions.barray(this.parse(jsonString));
    }

    @Override
    public short[] parseShortArray(String jsonString) {
        return Conversions.sarray(this.parse(jsonString));
    }

    @Override
    public int parseInt(String jsonString) {
        return Conversions.toInt(this.parse(jsonString));
    }

    @Override
    public int parseInt(InputStream input) {
        return Conversions.toInt(this.parse(input));
    }

    @Override
    public int parseInt(InputStream input, Charset charset) {
        return Conversions.toInt(this.parse(input, charset));
    }

    @Override
    public int parseInt(byte[] jsonBytes) {
        return Conversions.toInt(this.parse(jsonBytes));
    }

    @Override
    public int parseInt(byte[] jsonBytes, Charset charset) {
        return Conversions.toInt(this.parse(jsonBytes, charset));
    }

    @Override
    public int parseInt(char[] chars) {
        return Conversions.toInt(this.parse(chars));
    }

    @Override
    public int parseInt(CharSequence jsonSeq) {
        return Conversions.toInt(this.parse(jsonSeq));
    }

    @Override
    public int parseIntFromFile(String fileName) {
        return Conversions.toInt(this.parseFile(fileName));
    }

    @Override
    public long parseLong(String jsonString) {
        return Conversions.toLong(this.parse(jsonString));
    }

    @Override
    public long parseLong(InputStream input) {
        return Conversions.toLong(this.parse(input));
    }

    @Override
    public long parseLong(InputStream input, Charset charset) {
        return Conversions.toLong(this.parse(input, charset));
    }

    @Override
    public long parseLong(byte[] jsonBytes) {
        return Conversions.toLong(this.parse(jsonBytes));
    }

    @Override
    public long parseLong(byte[] jsonBytes, Charset charset) {
        return Conversions.toLong(this.parse(jsonBytes, charset));
    }

    @Override
    public long parseLong(char[] chars) {
        return Conversions.toLong(this.parse(chars));
    }

    @Override
    public long parseLong(CharSequence jsonSeq) {
        return Conversions.toLong(this.parse(jsonSeq));
    }

    @Override
    public long parseLongFromFile(String fileName) {
        return Conversions.toLong(this.parseFile(fileName));
    }

    @Override
    public double parseDouble(String value) {
        return Conversions.toDouble(this.parse(value));
    }

    @Override
    public double parseDouble(InputStream value) {
        return Conversions.toDouble(this.parse(value));
    }

    @Override
    public double parseDouble(byte[] value) {
        return Conversions.toDouble(this.parse(value));
    }

    @Override
    public double parseDouble(char[] value) {
        return Conversions.toDouble(this.parse(value));
    }

    @Override
    public double parseDouble(CharSequence value) {
        return Conversions.toDouble(this.parse(value));
    }

    @Override
    public double parseDouble(byte[] value, Charset charset) {
        return Conversions.toDouble(this.parse(value, charset));
    }

    @Override
    public double parseDouble(InputStream value, Charset charset) {
        return Conversions.toDouble(this.parse(value, charset));
    }

    @Override
    public double parseDoubleFromFile(String fileName) {
        return Conversions.toDouble(this.parseFile(fileName));
    }

    @Override
    public float parseFloat(String value) {
        return Conversions.toFloat(this.parse(value));
    }

    @Override
    public float parseFloat(InputStream value) {
        return Conversions.toFloat(this.parse(value));
    }

    @Override
    public float parseFloat(byte[] value) {
        return Conversions.toFloat(this.parse(value));
    }

    @Override
    public float parseFloat(char[] value) {
        return Conversions.toFloat(this.parse(value));
    }

    @Override
    public float parseFloat(CharSequence value) {
        return Conversions.toFloat(this.parse(value));
    }

    @Override
    public float parseFloat(byte[] value, Charset charset) {
        return Conversions.toFloat(this.parse(value, charset));
    }

    @Override
    public float parseFloat(InputStream value, Charset charset) {
        return Conversions.toFloat(this.parse(value, charset));
    }

    @Override
    public float parseFloatFromFile(String fileName) {
        return Conversions.toFloat(this.parseFile(fileName));
    }

    @Override
    public BigDecimal parseBigDecimal(String value) {
        return Conversions.toBigDecimal(this.parse(value));
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value) {
        return Conversions.toBigDecimal(this.parse(value));
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value) {
        return Conversions.toBigDecimal(this.parse(value));
    }

    @Override
    public BigDecimal parseBigDecimal(char[] value) {
        return Conversions.toBigDecimal(this.parse(value));
    }

    @Override
    public BigDecimal parseBigDecimal(CharSequence value) {
        return Conversions.toBigDecimal(this.parse(value));
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value, Charset charset) {
        return Conversions.toBigDecimal(this.parse(value, charset));
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value, Charset charset) {
        return Conversions.toBigDecimal(this.parse(value, charset));
    }

    @Override
    public BigDecimal parseBigDecimalFromFile(String fileName) {
        return Conversions.toBigDecimal(this.parseFile(fileName));
    }

    @Override
    public BigInteger parseBigInteger(String value) {
        return Conversions.toBigInteger(this.parse(value));
    }

    @Override
    public BigInteger parseBigInteger(InputStream value) {
        return Conversions.toBigInteger(this.parse(value));
    }

    @Override
    public BigInteger parseBigInteger(byte[] value) {
        return Conversions.toBigInteger(this.parse(value));
    }

    @Override
    public BigInteger parseBigInteger(char[] value) {
        return Conversions.toBigInteger(this.parse(value));
    }

    @Override
    public BigInteger parseBigInteger(CharSequence value) {
        return Conversions.toBigInteger(this.parse(value));
    }

    @Override
    public BigInteger parseBigInteger(byte[] value, Charset charset) {
        return Conversions.toBigInteger(this.parse(value, charset));
    }

    @Override
    public BigInteger parseBigInteger(InputStream value, Charset charset) {
        return Conversions.toBigInteger(this.parse(value, charset));
    }

    @Override
    public BigInteger parseBigIntegerFile(String fileName) {
        return Conversions.toBigInteger(this.parseFile(fileName));
    }

    @Override
    public Object parse(String jsonString) {
        return this.parse(FastStringUtils.toCharArray(jsonString));
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.parse(bytes, this.charset);
    }

    @Override
    public Object parse(CharSequence charSequence) {
        return this.parse(FastStringUtils.toCharArray(charSequence));
    }

    @Override
    public Object parse(Reader reader) {
        this.fileInputBuf = IO.read(reader, this.fileInputBuf, this.bufSize);
        return this.parse(this.fileInputBuf.readForRecycle());
    }

    @Override
    public Object parse(InputStream input) {
        return this.parse(input, this.charset);
    }

    @Override
    public Object parse(InputStream input, Charset charset) {
        return this.parse(new InputStreamReader(input, charset));
    }

    @Override
    public Object parseDirect(byte[] value) {
        this.builder.addAsUTF(value);
        return this.parse(this.builder.readForRecycle());
    }

    @Override
    public <T> T parseDirect(Class<T> type, byte[] value) {
        this.builder.addAsUTF(value);
        return this.parse(type, this.builder.readForRecycle());
    }

    @Override
    public <T> T parseAsStream(Class<T> type, byte[] value) {
        return this.parse(type, new ByteArrayInputStream(value));
    }

    @Override
    public <T> T parse(Class<T> type, CharSequence charSequence) {
        return this.parse(type, charSequence.toString());
    }

    @Override
    public Object parseAsStream(byte[] value) {
        return this.parse(new ByteArrayInputStream(value));
    }

    @Override
    public Object parseFile(String fileName) {
        try {
            Path filePath = IO.path(fileName);
            long size = Files.size(filePath);
            size = size > 2000000000L ? 1000000L : size;
            BufferedReader reader = Files.newBufferedReader(IO.path(fileName), this.charset);
            this.fileInputBuf = IO.read(reader, this.fileInputBuf, (int)size);
            return this.parse(this.fileInputBuf.readForRecycle());
        }
        catch (IOException ex) {
            return Exceptions.handle(Object.class, fileName, ex);
        }
    }

    @Override
    public <T> T parse(Class<T> type, Reader reader) {
        this.fileInputBuf = IO.read(reader, this.fileInputBuf, this.bufSize);
        return this.parse(type, this.fileInputBuf.readForRecycle());
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input) {
        this.fileInputBuf = IO.read(input, this.fileInputBuf, this.charset, this.bufSize);
        return this.parse(type, this.fileInputBuf.readForRecycle());
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input, Charset charset) {
        this.fileInputBuf = IO.read(input, this.fileInputBuf, charset, 256);
        return this.parse(type, this.fileInputBuf.readForRecycle());
    }

    @Override
    public <T> T parseFile(Class<T> type, String fileName) {
        try {
            Path filePath = IO.path(fileName);
            long size = Files.size(filePath);
            size = size > 2000000000L ? 1000000L : size;
            BufferedReader reader = Files.newBufferedReader(IO.path(fileName), this.charset);
            this.fileInputBuf = IO.read(reader, this.fileInputBuf, (int)size);
            return this.parse(type, this.fileInputBuf.readForRecycle());
        }
        catch (IOException ex) {
            return Exceptions.handle(type, fileName, ex);
        }
    }

    @Override
    public Map<String, Object> parseMap(char[] value) {
        return (Map)this.parse(value);
    }

    @Override
    public Map<String, Object> parseMap(byte[] value) {
        return (Map)this.parse(value);
    }

    @Override
    public Map<String, Object> parseMap(byte[] value, Charset charset) {
        return (Map)this.parse(value, charset);
    }

    @Override
    public Map<String, Object> parseMap(InputStream value, Charset charset) {
        return (Map)this.parse(value, charset);
    }

    @Override
    public Map<String, Object> parseMap(CharSequence value) {
        return (Map)this.parse(value);
    }

    @Override
    public Map<String, Object> parseMap(InputStream value) {
        return (Map)this.parse(value);
    }

    @Override
    public Map<String, Object> parseMap(Reader value) {
        return (Map)this.parse(value);
    }

    @Override
    public Map<String, Object> parseMapFromFile(String file) {
        return (Map)this.parseFile(file);
    }

    protected static boolean isDecimalChar(int currentChar) {
        switch (currentChar) {
            case 43: 
            case 45: 
            case 46: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDelimiter(int c) {
        return c == 44 || c == 125 || c == 93;
    }

    protected static final boolean isNumberDigit(int c) {
        return c >= 48 && c <= 57;
    }

    protected static final boolean isDoubleQuote(int c) {
        return c == 34;
    }

    protected static final boolean isEscape(int c) {
        return c == 92;
    }

    @Override
    public void close() {
    }

    protected static boolean hasEscapeChar(char[] array, int index, int[] indexHolder) {
        while (index < array.length) {
            char currentChar = array[index];
            if (BaseJsonParser.isDoubleQuote(currentChar)) {
                indexHolder[0] = index;
                return false;
            }
            if (BaseJsonParser.isEscape(currentChar)) {
                indexHolder[0] = index;
                return true;
            }
            ++index;
        }
        indexHolder[0] = index;
        return false;
    }

    protected static int findEndQuote(char[] array, int index) {
        char currentChar;
        boolean escape = false;
        while (index < array.length && (!BaseJsonParser.isDoubleQuote(currentChar = array[index]) || escape)) {
            escape = BaseJsonParser.isEscape(currentChar);
            ++index;
        }
        return index;
    }

    static {
        if (internKeys) {
            internedKeysCache = new ConcurrentHashMap();
        }
    }
}

