/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.boon.IO;
import org.boon.core.LazyMap;
import org.boon.core.Typ;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.json.JsonException;
import org.boon.json.implementation.BaseJsonParser;
import org.boon.primitive.Byt;
import org.boon.primitive.ByteScanner;
import org.boon.primitive.CharBuf;

public abstract class JsonBaseByteArrayParser
extends BaseJsonParser {
    protected byte[] charArray;
    protected int __index;
    protected int __currentChar;
    protected static final int NEW_LINE = 10;
    protected static final int RETURN = 13;
    protected static final int SPACE = 32;
    protected static final int TAB = 9;
    protected static final int BELL = 8;
    protected static final int FORM_FEED = 12;
    protected static final int COLON = 58;
    protected static final int OPEN_CURLY = 123;
    protected static final int OPEN_BRACKET = 91;
    protected static final int LETTER_N = 110;
    protected static final int LETTER_U = 117;
    protected static final int LETTER_L = 108;
    protected static final int LETTER_T = 116;
    protected static final int LETTER_R = 114;
    protected static final int LETTER_F = 102;
    protected static final int LETTER_A = 97;
    protected static final int LETTER_S = 115;
    protected final CharBuf builder = CharBuf.create(20);
    protected static final byte[] NULL = Byt.bytes("null");
    protected static final byte[] TRUE = Byt.bytes("true");
    protected static final byte[] FALSE = Byt.bytes("false");

    public JsonBaseByteArrayParser(FieldsAccessor fieldsAccessor) {
        super(fieldsAccessor);
    }

    protected final boolean hasMore() {
        return this.__index + 1 < this.charArray.length;
    }

    protected final int nextChar() {
        try {
            if (this.hasMore()) {
                ++this.__index;
                this.__currentChar = this.charArray[this.__index];
                return this.__currentChar;
            }
            return this.__currentChar;
        }
        catch (Exception ex) {
            throw new RuntimeException(this.exceptionDetails("failure in next " + ex.getLocalizedMessage()), ex);
        }
    }

    protected final String exceptionDetails(String message) {
        CharBuf buf = CharBuf.create(255);
        buf.addLine(message);
        buf.addLine("");
        buf.addLine("The current character read is " + this.charDescription(this.__currentChar));
        buf.addLine(message);
        int line = 0;
        int lastLineIndex = 0;
        for (int i = 0; i < this.__index; ++i) {
            if (this.charArray[i] != 10) continue;
            ++line;
            lastLineIndex = i + 1;
        }
        int count = 0;
        int i = lastLineIndex;
        while (i < this.charArray.length && this.charArray[i] != 10) {
            ++i;
            ++count;
        }
        buf.addLine("line number " + line + 1);
        buf.addLine("index number " + this.__index);
        try {
            buf.addLine(new String(this.charArray, lastLineIndex, count, this.charset));
        }
        catch (Exception ex) {
            try {
                int index = this.__index - 10 < 0 ? 0 : this.__index - 10;
                buf.addLine(new String(this.charArray, index, this.__index, this.charset));
            }
            catch (Exception ex2) {
                buf.addLine(new String(this.charArray, 0, this.charArray.length, this.charset));
            }
        }
        for (i = 0; i < this.__index - lastLineIndex - 1; ++i) {
            buf.add('.');
        }
        buf.add('^');
        return buf.toString();
    }

    private static int skipWhiteSpaceFastBytes(byte[] array, int index) {
        while (index < array.length) {
            byte c = array[index];
            if (c > 32) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    protected final void skipWhiteSpace() {
        this.__index = JsonBaseByteArrayParser.skipWhiteSpaceFastBytes(this.charArray, this.__index);
        this.__currentChar = this.charArray[this.__index];
    }

    protected String charDescription(int c) {
        String charString = c == 32 ? "[SPACE]" : (c == 9 ? "[TAB]" : (c == 10 ? "[NEWLINE]" : "'" + (char)c + "'"));
        charString = charString + " with an int value of " + c;
        return charString;
    }

    private Object decode(byte[] cs) {
        this.charArray = cs;
        this.__index = 0;
        return this.decodeValue();
    }

    @Override
    public <T> T parse(Class<T> type, String str) {
        return this.parse(type, str.getBytes(this.charset));
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes) {
        if (type == Map.class || type == List.class || Typ.isBasicType(type)) {
            return (T)this.decode(bytes);
        }
        Map objectMap = (Map)this.decode(bytes);
        return (T)MapObjectConversion.fromMap((Map<String, Object>)objectMap, type);
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.decode(bytes);
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input) {
        return this.parse(type, IO.input(input));
    }

    @Override
    public <T> T parse(Class<T> type, CharSequence charSequence) {
        return this.parse(type, charSequence.toString());
    }

    @Override
    public <T> T parse(Class<T> type, char[] chars) {
        return this.parse(type, new String(chars));
    }

    protected void complain(String complaint) {
        throw new JsonException(this.exceptionDetails(complaint));
    }

    protected final Object decodeValue() {
        Object value = null;
        block12: while (this.__index < this.charArray.length) {
            this.__currentChar = this.charArray[this.__index];
            switch (this.__currentChar) {
                case 10: {
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 32: {
                    break;
                }
                case 34: {
                    value = this.decodeString();
                    break block12;
                }
                case 116: {
                    value = this.decodeTrue();
                    break block12;
                }
                case 102: {
                    value = this.decodeFalse();
                    break block12;
                }
                case 110: {
                    value = this.decodeNull();
                    break block12;
                }
                case 91: {
                    value = this.decodeJsonArray();
                    break block12;
                }
                case 123: {
                    value = this.decodeJsonObject();
                    break block12;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    value = this.decodeNumber(false);
                    break block12;
                }
                case 45: {
                    value = this.decodeNumber(true);
                    break block12;
                }
                default: {
                    throw new JsonException(this.exceptionDetails("Unable to determine the current character, it is not a string, number, array, or object"));
                }
            }
            ++this.__index;
        }
        return value;
    }

    protected final Object decodeJsonObject() {
        if (this.__currentChar == 123 && this.hasMore()) {
            this.nextChar();
        }
        this.skipWhiteSpace();
        if (this.__currentChar == 125 && this.hasMore()) {
            this.nextChar();
            return Collections.EMPTY_MAP;
        }
        LazyMap map = new LazyMap();
        do {
            this.skipWhiteSpace();
            if (this.__currentChar == 34) {
                String key = this.decodeString();
                if (internKeys) {
                    String keyPrime = (String)internedKeysCache.get(key);
                    if (keyPrime == null) {
                        key = key.intern();
                        internedKeysCache.put(key, key);
                    } else {
                        key = keyPrime;
                    }
                }
                this.skipWhiteSpace();
                if (this.__currentChar != 58) {
                    this.complain("expecting current character to be " + this.charDescription(this.__currentChar) + "\n");
                }
                this.nextChar();
                this.skipWhiteSpace();
                Object value = this.decodeValue();
                this.skipWhiteSpace();
                map.put(key, value);
                if (this.__currentChar != 125 && this.__currentChar != 44) {
                    this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
                }
            }
            if (this.__currentChar == 125) {
                this.nextChar();
                break;
            }
            if (this.__currentChar == 44) {
                this.nextChar();
                continue;
            }
            this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
        } while (this.hasMore());
        return map;
    }

    private final Object decodeNumber(boolean minus) {
        int currentChar;
        byte[] array = this.charArray;
        int startIndex = this.__index;
        int index = this.__index;
        boolean doubleFloat = false;
        boolean simple = true;
        int digitsPastPoint = 0;
        int sign = 1;
        if (minus) {
            minus = true;
            sign = -1;
            this.nextChar();
        }
        do {
            currentChar = array[index];
            if (doubleFloat) {
                ++digitsPastPoint;
            }
            if (JsonBaseByteArrayParser.isNumberDigit(currentChar)) continue;
            if (currentChar <= 32 || JsonBaseByteArrayParser.isDelimiter(currentChar)) break;
            if (!JsonBaseByteArrayParser.isDecimalChar(currentChar)) continue;
            doubleFloat = true;
            if (currentChar == 46) continue;
            simple = false;
        } while (++index < array.length);
        this.__index = index;
        this.__currentChar = currentChar;
        return this.getNumberFromSpan(startIndex, doubleFloat, simple, digitsPastPoint, minus, sign);
    }

    private final Object getNumberFromSpan(int startIndex, boolean doubleFloat, boolean simple, int digitsPastPoint, boolean minus, int sign) {
        Number value = doubleFloat ? (Number)ByteScanner.simpleDouble(this.charArray, simple, minus, digitsPastPoint - 1, startIndex, this.__index) : (Number)(ByteScanner.isInteger(this.charArray, startIndex, this.__index - startIndex, minus) ? (Number)(ByteScanner.parseInt(this.charArray, startIndex, this.__index - startIndex) * sign) : (Number)(ByteScanner.parseLong(this.charArray, startIndex, this.__index - startIndex) * (long)sign));
        return value;
    }

    protected final Object decodeNull() {
        if (this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 110 && this.charArray[++this.__index] == 117 && this.charArray[++this.__index] == 108 && this.charArray[++this.__index] == 108) {
            this.nextChar();
            return null;
        }
        throw new JsonException(this.exceptionDetails("null not parsed properly"));
    }

    protected final boolean decodeTrue() {
        if (this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 116 && this.charArray[++this.__index] == 114 && this.charArray[++this.__index] == 117 && this.charArray[++this.__index] == 101) {
            this.nextChar();
            return true;
        }
        throw new JsonException(this.exceptionDetails("true not parsed properly"));
    }

    protected final boolean decodeFalse() {
        if (this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 102 && this.charArray[++this.__index] == 97 && this.charArray[++this.__index] == 108 && this.charArray[++this.__index] == 115 && this.charArray[++this.__index] == 101) {
            this.nextChar();
            return false;
        }
        throw new JsonException(this.exceptionDetails("false not parsed properly"));
    }

    protected abstract String decodeString();

    protected final List decodeJsonArray() {
        if (this.__currentChar == 91) {
            this.nextChar();
        }
        this.skipWhiteSpace();
        if (this.__currentChar == 93) {
            this.nextChar();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int arrayIndex = 0;
        do {
            this.skipWhiteSpace();
            Object arrayItem = this.decodeValue();
            list.add(arrayItem);
            ++arrayIndex;
            this.skipWhiteSpace();
            if (this.__currentChar == 44) {
                this.nextChar();
                continue;
            }
            if (this.__currentChar == 93) {
                this.nextChar();
                break;
            }
            String charString = this.charDescription(this.__currentChar);
            this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array index of %s \n", charString, arrayIndex));
        } while (this.hasMore());
        return list;
    }

    @Override
    public <T> T parseDirect(Class<T> type, byte[] value) {
        return this.parse(type, value);
    }

    @Override
    public <T> T parseAsStream(Class<T> type, byte[] value) {
        return this.parse(type, new ByteArrayInputStream(value));
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes, Charset charset) {
        return this.parse(type, bytes);
    }

    @Override
    public <T> T parseFile(Class<T> type, String fileName) {
        return this.parse(type, IO.input(fileName));
    }

    @Override
    public Object parse(char[] chars) {
        return this.parse(new String(chars));
    }

    @Override
    public Object parse(String string) {
        return this.parse(string.getBytes(this.charset));
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.parse(bytes);
    }
}

