/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.CharSequenceValue;
import org.boon.core.value.LazyValueMap;
import org.boon.core.value.MapItemValue;
import org.boon.core.value.NumberValue;
import org.boon.core.value.ValueContainer;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;
import org.boon.json.JsonException;
import org.boon.json.implementation.JsonParserCharArray;

public class JsonFastParser
extends JsonParserCharArray {
    private static ValueContainer EMPTY_LIST = new ValueContainer(Collections.emptyList());
    private final boolean useValues;
    private final boolean chop;
    private final boolean lazyChop;
    private final boolean checkDates;

    public JsonFastParser() {
        this(FieldAccessMode.FIELD);
    }

    public JsonFastParser(FieldAccessMode mode) {
        this(mode, true);
    }

    public JsonFastParser(FieldAccessMode mode, boolean useAnnotations) {
        this(FieldAccessMode.create(mode, useAnnotations));
    }

    public JsonFastParser(FieldsAccessor fieldsAccessor) {
        this(fieldsAccessor, false);
    }

    public JsonFastParser(FieldsAccessor fieldsAccessor, boolean useValues) {
        this(fieldsAccessor, useValues, false);
    }

    public JsonFastParser(FieldsAccessor fieldsAccessor, boolean useValues, boolean chop) {
        this(fieldsAccessor, useValues, chop, !chop);
    }

    public JsonFastParser(FieldsAccessor fieldsAccessor, boolean useValues, boolean chop, boolean lazyChop) {
        this(fieldsAccessor, useValues, chop, lazyChop, true);
    }

    public JsonFastParser(FieldsAccessor fieldsAccessor, boolean useValues, boolean chop, boolean lazyChop, boolean checkDates) {
        super(fieldsAccessor);
        this.useValues = useValues;
        this.chop = chop;
        this.lazyChop = lazyChop;
        this.checkDates = checkDates;
    }

    protected final Value decodeJsonObjectLazyFinalParse() {
        char[] array = this.charArray;
        if (this.__currentChar == '{') {
            ++this.__index;
        }
        ValueMap map = (ValueMap)((Object)(this.useValues ? new ValueMapImpl() : new LazyValueMap(this.lazyChop)));
        ValueContainer value = new ValueContainer(map);
        block7: while (this.__index < array.length) {
            this.skipWhiteSpace();
            switch (this.__currentChar) {
                case '\"': {
                    Value key = this.decodeStringOverlay();
                    this.skipWhiteSpace();
                    if (this.__currentChar != ':') {
                        this.complain("expecting current character to be " + this.charDescription(this.__currentChar) + "\n");
                    }
                    ++this.__index;
                    Value item = this.decodeValueOverlay();
                    this.skipWhiteSpace();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                }
            }
            switch (this.__currentChar) {
                case '}': {
                    ++this.__index;
                    break block7;
                }
                case ',': {
                    break;
                }
                default: {
                    this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
                }
            }
            ++this.__index;
        }
        return value;
    }

    @Override
    protected Value decodeValue() {
        return this.decodeValueOverlay();
    }

    private Value decodeValueOverlay() {
        this.skipWhiteSpace();
        switch (this.__currentChar) {
            case '\"': {
                return this.decodeStringOverlay();
            }
            case '{': {
                return this.decodeJsonObjectLazyFinalParse();
            }
            case 't': {
                return this.decodeTrue() ? ValueContainer.TRUE : ValueContainer.FALSE;
            }
            case 'f': {
                return !this.decodeFalse() ? ValueContainer.FALSE : ValueContainer.TRUE;
            }
            case 'n': {
                return this.decodeNull() == null ? ValueContainer.NULL : ValueContainer.NULL;
            }
            case '[': {
                return this.decodeJsonArrayOverlay();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.decodeNumberOverlay(false);
            }
            case '-': {
                return this.decodeNumberOverlay(true);
            }
        }
        throw new JsonException(this.exceptionDetails("Unable to determine the current character, it is not a string, number, array, or object"));
    }

    private final Value decodeNumberOverlay(boolean minus) {
        char currentChar;
        char[] array = this.charArray;
        int startIndex = this.__index;
        int index = this.__index;
        boolean doubleFloat = false;
        if (minus && index + 1 < array.length) {
            ++index;
        }
        do {
            if (JsonFastParser.isNumberDigit(currentChar = array[index])) continue;
            if (currentChar <= ' ' || JsonFastParser.isDelimiter(currentChar)) break;
            if (!JsonFastParser.isDecimalChar(currentChar)) continue;
            doubleFloat = true;
        } while (++index < array.length);
        this.__index = index;
        this.__currentChar = currentChar;
        Type type = doubleFloat ? Type.DOUBLE : Type.INTEGER;
        NumberValue value = new NumberValue(this.chop, type, startIndex, this.__index, this.charArray);
        return value;
    }

    private Value decodeStringOverlay() {
        char[] array = this.charArray;
        int index = this.__index;
        char currentChar = this.charArray[index];
        if (index < array.length && currentChar == '\"') {
            ++index;
        }
        int startIndex = index;
        boolean encoded = JsonFastParser.hasEscapeChar(array, index, this.indexHolder);
        index = this.indexHolder[0];
        if (encoded) {
            index = JsonFastParser.findEndQuote(array, index);
        }
        CharSequenceValue value = new CharSequenceValue(this.chop, Type.STRING, startIndex, index, array, encoded, this.checkDates);
        if (index < array.length) {
            ++index;
        }
        this.__index = index;
        return value;
    }

    private Value decodeJsonArrayOverlay() {
        char[] array = this.charArray;
        if (this.__currentChar == '[') {
            ++this.__index;
        }
        this.skipWhiteSpace();
        if (this.__currentChar == ']') {
            ++this.__index;
            return EMPTY_LIST;
        }
        AbstractList list = this.useValues ? new ArrayList() : new ValueList(this.lazyChop);
        ValueContainer value = new ValueContainer(list);
        block4: while (this.__index < array.length) {
            Value item = this.decodeValueOverlay();
            list.add((Object)item);
            this.skipWhiteSpace();
            switch (this.__currentChar) {
                case ',': {
                    break;
                }
                case ']': {
                    ++this.__index;
                    break block4;
                }
                default: {
                    this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array size of %s \n", this.charDescription(this.__currentChar), list.size()));
                }
            }
            ++this.__index;
        }
        return value;
    }

    @Override
    protected final Object decodeFromChars(char[] cs) {
        Value value = (Value)super.decodeFromChars(cs);
        if (value.isContainer()) {
            return value.toValue();
        }
        return value;
    }
}

