/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.boon.core.LazyMap;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.json.JsonException;
import org.boon.json.JsonParser;
import org.boon.json.implementation.BaseJsonParser;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;
import org.boon.primitive.Chr;

public class JsonParserCharArray
extends BaseJsonParser
implements JsonParser {
    protected char[] charArray;
    protected int __index;
    protected char __currentChar;
    protected static final char[] NULL = Chr.chars("null");
    protected static final char[] TRUE = Chr.chars("true");
    protected static char[] FALSE = Chr.chars("false");
    private CharBuf builder = CharBuf.create(20);

    public JsonParserCharArray() {
        super(FieldAccessMode.create(FieldAccessMode.FIELD, true));
    }

    public JsonParserCharArray(FieldAccessMode mode, boolean useAnnotations) {
        super(FieldAccessMode.create(mode, useAnnotations));
    }

    public JsonParserCharArray(FieldsAccessor fieldsAccessor) {
        super(fieldsAccessor);
    }

    protected Object decodeFromChars(char[] cs) {
        this.__index = 0;
        this.charArray = cs;
        Object value = this.decodeValue();
        return value;
    }

    protected final Object decodeFromString(String cs) {
        return this.decodeFromChars(FastStringUtils.toCharArray(cs));
    }

    protected final Object decodeFromBytes(byte[] bytes) {
        char[] chars = FastStringUtils.toCharArrayFromBytes(bytes, this.charset);
        return this.decodeFromChars(chars);
    }

    protected final Object decodeFromBytes(byte[] bytes, Charset charset) {
        char[] chars = FastStringUtils.toCharArrayFromBytes(bytes, charset);
        return this.decodeFromChars(chars);
    }

    protected final boolean hasMore() {
        return this.__index + 1 < this.charArray.length;
    }

    protected final char nextChar() {
        try {
            if (this.hasMore()) {
                ++this.__index;
                this.__currentChar = this.charArray[this.__index];
                return this.__currentChar;
            }
            return '\u0000';
        }
        catch (Exception ex) {
            throw new JsonException(this.exceptionDetails("unable to advance character"), ex);
        }
    }

    protected String exceptionDetails(String message) {
        CharBuf buf = CharBuf.create(255);
        buf.addLine(message);
        buf.addLine("");
        buf.addLine("The current character read is " + this.charDescription(this.__currentChar));
        buf.addLine(message);
        int line = 0;
        int lastLineIndex = 0;
        for (int i = 0; i < this.__index && i < this.charArray.length; ++i) {
            if (this.charArray[i] != '\n') continue;
            ++line;
            lastLineIndex = i + 1;
        }
        int count = 0;
        int i = lastLineIndex;
        while (i < this.charArray.length && this.charArray[i] != '\n') {
            ++i;
            ++count;
        }
        buf.addLine("line number " + line + 1);
        buf.addLine("index number " + this.__index);
        try {
            buf.addLine(new String(this.charArray, lastLineIndex, count));
        }
        catch (Exception ex) {
            try {
                int index = this.__index - 10 < 0 ? 0 : this.__index - 10;
                buf.addLine(new String(this.charArray, index, this.__index));
            }
            catch (Exception ex2) {
                buf.addLine(new String(this.charArray, 0, this.charArray.length));
            }
        }
        for (i = 0; i < this.__index - lastLineIndex; ++i) {
            buf.add('.');
        }
        buf.add('^');
        return buf.toString();
    }

    private static int skipWhiteSpaceFast(char[] array, int index) {
        while (index < array.length) {
            char c = array[index];
            if (c > ' ') {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    protected final void skipWhiteSpace() {
        this.__index = JsonParserCharArray.skipWhiteSpaceFast(this.charArray, this.__index);
        this.__currentChar = this.charArray[this.__index];
    }

    protected final Object decodeJsonObject() {
        if (this.__currentChar == '{') {
            ++this.__index;
        }
        LazyMap map = new LazyMap();
        while (this.__index < this.charArray.length) {
            this.skipWhiteSpace();
            if (this.__currentChar == '\"') {
                String key = this.decodeString();
                if (internKeys) {
                    String keyPrime = (String)internedKeysCache.get(key);
                    if (keyPrime == null) {
                        key = key.intern();
                        internedKeysCache.put(key, key);
                    } else {
                        key = keyPrime;
                    }
                }
                this.skipWhiteSpace();
                if (this.__currentChar != ':') {
                    this.complain("expecting current character to be " + this.charDescription(this.__currentChar) + "\n");
                }
                ++this.__index;
                this.skipWhiteSpace();
                Object value = this.decodeValueInternal();
                this.skipWhiteSpace();
                map.put(key, value);
            }
            if (this.__currentChar == '}') {
                ++this.__index;
                break;
            }
            if (this.__currentChar != ',') {
                this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
            }
            ++this.__index;
        }
        return map;
    }

    protected final void complain(String complaint) {
        throw new JsonException(this.exceptionDetails(complaint));
    }

    protected Object decodeValue() {
        return this.decodeValueInternal();
    }

    private final Object decodeValueInternal() {
        Object value = null;
        this.skipWhiteSpace();
        switch (this.__currentChar) {
            case '\"': {
                value = this.decodeString();
                break;
            }
            case 't': {
                value = this.decodeTrue();
                break;
            }
            case 'f': {
                value = this.decodeFalse();
                break;
            }
            case 'n': {
                value = this.decodeNull();
                break;
            }
            case '[': {
                value = this.decodeJsonArray();
                break;
            }
            case '{': {
                value = this.decodeJsonObject();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = this.decodeNumber(false);
                break;
            }
            case '-': {
                value = this.decodeNumber(true);
                break;
            }
            default: {
                throw new JsonException(this.exceptionDetails("Unable to determine the current character, it is not a string, number, array, or object"));
            }
        }
        return value;
    }

    private final Object decodeNumber(boolean minus) {
        char currentChar;
        char[] array = this.charArray;
        int startIndex = this.__index;
        int index = this.__index;
        boolean doubleFloat = false;
        boolean simple = true;
        int digitsPastPoint = 0;
        int sign = 1;
        if (minus) {
            minus = true;
            sign = -1;
            this.nextChar();
        }
        do {
            currentChar = array[index];
            if (doubleFloat) {
                ++digitsPastPoint;
            }
            if (JsonParserCharArray.isNumberDigit(currentChar)) continue;
            if (currentChar <= ' ' || JsonParserCharArray.isDelimiter(currentChar)) break;
            if (!JsonParserCharArray.isDecimalChar(currentChar)) continue;
            doubleFloat = true;
            if (currentChar == '.') continue;
            simple = false;
        } while (++index < array.length);
        this.__index = index;
        this.__currentChar = currentChar;
        return this.getNumberFromSpan(startIndex, doubleFloat, simple, digitsPastPoint, minus, sign);
    }

    private final Object getNumberFromSpan(int startIndex, boolean doubleFloat, boolean simple, int digitsPastPoint, boolean minus, int sign) {
        Number value = doubleFloat ? (Number)CharScanner.simpleDouble(this.charArray, simple, minus, digitsPastPoint - 1, startIndex, this.__index) : (Number)(CharScanner.isInteger(this.charArray, startIndex, this.__index - startIndex, minus) ? (Number)(CharScanner.parseInt(this.charArray, startIndex, this.__index - startIndex) * sign) : (Number)(CharScanner.parseLong(this.charArray, startIndex, this.__index - startIndex) * (long)sign));
        return value;
    }

    protected final Object decodeNull() {
        if (this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 'n' && this.charArray[++this.__index] == 'u' && this.charArray[++this.__index] == 'l' && this.charArray[++this.__index] == 'l') {
            ++this.__index;
            return null;
        }
        throw new JsonException(this.exceptionDetails("null not parse properly"));
    }

    protected final boolean decodeTrue() {
        if (this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 't' && this.charArray[++this.__index] == 'r' && this.charArray[++this.__index] == 'u' && this.charArray[++this.__index] == 'e') {
            ++this.__index;
            return true;
        }
        throw new JsonException(this.exceptionDetails("true not parsed properly"));
    }

    protected final boolean decodeFalse() {
        if (this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 'f' && this.charArray[++this.__index] == 'a' && this.charArray[++this.__index] == 'l' && this.charArray[++this.__index] == 's' && this.charArray[++this.__index] == 'e') {
            ++this.__index;
            return false;
        }
        throw new JsonException(this.exceptionDetails("false not parsed properly"));
    }

    private String decodeString() {
        char[] array = this.charArray;
        int index = this.__index;
        char currentChar = this.charArray[index];
        if (index < array.length && currentChar == '\"') {
            ++index;
        }
        int startIndex = index;
        boolean encoded = JsonParserCharArray.hasEscapeChar(array, index, this.indexHolder);
        index = this.indexHolder[0];
        String value = null;
        if (encoded) {
            index = JsonParserCharArray.findEndQuote(array, index);
            value = this.builder.decodeJsonString(array, startIndex, index).toString();
            this.builder.recycle();
        } else {
            value = new String(array, startIndex, index - startIndex);
        }
        if (index < this.charArray.length) {
            ++index;
        }
        this.__index = index;
        return value;
    }

    protected final List decodeJsonArray() {
        if (this.__currentChar == '[') {
            ++this.__index;
        }
        this.skipWhiteSpace();
        if (this.__currentChar == ']') {
            ++this.__index;
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            this.skipWhiteSpace();
            Object arrayItem = this.decodeValueInternal();
            list.add(arrayItem);
            this.skipWhiteSpace();
            char c = this.__currentChar;
            if (c == ',') {
                ++this.__index;
                continue;
            }
            if (c == ']') {
                ++this.__index;
                break;
            }
            String charString = this.charDescription(c);
            this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array index of %s \n", charString, list.size()));
        } while (this.hasMore());
        return list;
    }

    @Override
    public final <T> T parse(Class<T> type, String str) {
        Object object = this.decodeFromString(str);
        return this.convert(type, object);
    }

    @Override
    public final <T> T parse(Class<T> type, byte[] value) {
        Object object = this.decodeFromBytes(value);
        return this.convert(type, object);
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes, Charset charset) {
        Object object = this.decodeFromBytes(bytes, charset);
        return this.convert(type, object);
    }

    @Override
    public Object parse(char[] chars) {
        return this.decodeFromChars(chars);
    }

    @Override
    public final <T> T parse(Class<T> type, char[] chars) {
        Object object = this.decodeFromChars(chars);
        return this.convert(type, object);
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.decodeFromBytes(bytes);
    }
}

