/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.boon.Exceptions;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.json.JsonException;
import org.boon.json.JsonParser;
import org.boon.json.JsonParserFactory;
import org.boon.json.implementation.BaseJsonParser;

public class JsonParserConcurrent
extends BaseJsonParser
implements JsonParser {
    private Worker[] workers;
    private Future[] futures;
    private TransferQueue<Action> workQueue = new LinkedTransferQueue<Action>();
    private TransferQueue<Action> actionQueue = new LinkedTransferQueue<Action>();
    private final ExecutorService pool;

    public JsonParserConcurrent(JsonParserFactory factory) {
        super(FieldAccessMode.create(factory.getFieldAccessType(), true));
        int cores = Runtime.getRuntime().availableProcessors();
        this.workers = new Worker[cores];
        this.pool = Executors.newFixedThreadPool(cores);
        this.futures = new Future[cores];
        for (int index = 0; index < cores; ++index) {
            final Worker worker = new Worker();
            worker.parser = factory.createFastParser();
            worker.parent = this;
            Future<?> future = this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    worker.run();
                }
            });
            this.workers[index] = worker;
            this.futures[index] = future;
        }
    }

    public JsonParserConcurrent() {
        super(FieldAccessMode.create(FieldAccessMode.FIELD, true));
        JsonParserFactory factory = new JsonParserFactory();
        int cores = Runtime.getRuntime().availableProcessors();
        this.workers = new Worker[cores];
        this.pool = Executors.newFixedThreadPool(cores);
        this.futures = new Future[cores];
        for (int index = 0; index < cores; ++index) {
            final Worker worker = new Worker();
            worker.parser = factory.createFastParser();
            worker.parent = this;
            Future<?> future = this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    worker.run();
                }
            });
            this.workers[index] = worker;
            this.futures[index] = future;
        }
    }

    @Override
    public Object parse(String jsonString) {
        Action action = this.createAction();
        action.payload = jsonString;
        action.type = ActionType.OBJECT;
        action.medium = Medium.STRING;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    private <T> T getResult(Class<T> clazz, Action action) {
        T object = null;
        try {
            object = (T)action.returnQueue.poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (object != null) {
            action.returnQueue.clear();
            action.charSet = null;
            action.finalType = null;
            this.actionQueue.offer(action);
        }
        if (object instanceof Exception) {
            if (object instanceof JsonException) {
                throw (RuntimeException)object;
            }
            return Exceptions.handle(clazz, (Exception)object);
        }
        return object;
    }

    private void addJob(Action action) {
        try {
            if (this.workQueue.hasWaitingConsumer()) {
                this.workQueue.transfer(action);
            } else {
                this.workQueue.put(action);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private Action createAction() {
        Action action = (Action)this.actionQueue.poll();
        if (action == null) {
            action = new Action();
        }
        return action;
    }

    @Override
    public Object parse(char[] value) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.CHARS;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(byte[] value) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.BYTES;
        action.charSet = null;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(byte[] value, Charset charset) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.BYTES;
        action.charSet = charset;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(InputStream value, Charset charset) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.INPUT_STREAM;
        action.charSet = charset;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(CharSequence value) {
        Action action = this.createAction();
        action.payload = value.toString();
        action.type = ActionType.OBJECT;
        action.medium = Medium.STRING;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(InputStream value) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.INPUT_STREAM;
        action.charSet = null;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parse(Reader value) {
        Action action = this.createAction();
        action.payload = value;
        action.type = ActionType.OBJECT;
        action.medium = Medium.READER;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public Object parseFile(String file) {
        Action action = this.createAction();
        action.payload = file;
        action.type = ActionType.OBJECT;
        action.medium = Medium.FILE_NAME;
        this.addJob(action);
        return this.getResult(Object.class, action);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, String jsonString) {
        Action action = this.createAction();
        action.payload = jsonString;
        action.type = ActionType.LIST;
        action.medium = Medium.STRING;
        action.finalType = componentType;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input) {
        Action action = this.createAction();
        action.payload = input;
        action.type = ActionType.LIST;
        action.medium = Medium.INPUT_STREAM;
        action.finalType = componentType;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input, Charset charset) {
        Action action = this.createAction();
        action.payload = input;
        action.type = ActionType.LIST;
        action.medium = Medium.INPUT_STREAM;
        action.finalType = componentType;
        action.charSet = charset;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes) {
        Action action = this.createAction();
        action.payload = jsonBytes;
        action.type = ActionType.LIST;
        action.medium = Medium.BYTES;
        action.finalType = componentType;
        action.charSet = null;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes, Charset charset) {
        Action action = this.createAction();
        action.payload = jsonBytes;
        action.type = ActionType.LIST;
        action.medium = Medium.BYTES;
        action.finalType = componentType;
        action.charSet = charset;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, char[] chars) {
        Action action = this.createAction();
        action.payload = chars;
        action.type = ActionType.LIST;
        action.medium = Medium.CHARS;
        action.finalType = componentType;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, CharSequence jsonSeq) {
        Action action = this.createAction();
        action.payload = jsonSeq.toString();
        action.type = ActionType.LIST;
        action.medium = Medium.STRING;
        action.finalType = componentType;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> List<T> parseListFromFile(Class<T> componentType, String fileName) {
        Action action = this.createAction();
        action.payload = fileName;
        action.type = ActionType.LIST;
        action.medium = Medium.FILE_NAME;
        action.finalType = componentType;
        this.addJob(action);
        List list = this.getResult(List.class, action);
        return list;
    }

    @Override
    public <T> T parse(Class<T> type, String jsonString) {
        Action action = this.createAction();
        action.payload = jsonString;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.STRING;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes) {
        Action action = this.createAction();
        action.payload = bytes;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.BYTES;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes, Charset charset) {
        Action action = this.createAction();
        action.payload = bytes;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.BYTES;
        action.charSet = charset;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, CharSequence charSequence) {
        Action action = this.createAction();
        action.payload = charSequence.toString();
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.STRING;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, char[] chars) {
        Action action = this.createAction();
        action.payload = chars;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.CHARS;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, Reader reader) {
        Action action = this.createAction();
        action.payload = reader;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.READER;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input) {
        Action action = this.createAction();
        action.payload = input;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.INPUT_STREAM;
        action.finalType = type;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input, Charset charset) {
        Action action = this.createAction();
        action.payload = input;
        action.type = ActionType.TYPED_OBJECT;
        action.medium = Medium.INPUT_STREAM;
        action.finalType = type;
        action.charSet = charset;
        this.addJob(action);
        return this.getResult(type, action);
    }

    @Override
    public <T> T parseDirect(Class<T> type, byte[] value) {
        return this.parse(type, value);
    }

    @Override
    public <T> T parseAsStream(Class<T> type, byte[] value) {
        return this.parse(type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.workQueue.clear();
        try {
            int index;
            for (index = 0; index < this.workers.length; ++index) {
                this.workers[index].run.set(false);
            }
            for (index = 0; index < this.futures.length; ++index) {
                this.futures[index].cancel(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.pool.shutdown();
        }
    }

    static enum Medium {
        BYTES,
        STRING,
        CHARS,
        INPUT_STREAM,
        READER,
        FILE_NAME;

    }

    static enum ActionType {
        OBJECT,
        TYPED_OBJECT,
        LIST;

    }

    private static class Action {
        ActionType type;
        Medium medium;
        Object payload;
        Charset charSet;
        Class<?> finalType;
        TransferQueue<Object> returnQueue = new LinkedTransferQueue<Object>();

        private Action() {
        }
    }

    private static class Worker {
        JsonParser parser;
        JsonParserConcurrent parent;
        AtomicBoolean run = new AtomicBoolean(true);

        private Worker() {
        }

        void run() {
            try {
                while (this.run.get()) {
                    Action action = (Action)this.parent.workQueue.take();
                    this.workOn(action);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }

        private void workOn(Action action) {
            switch (action.type) {
                case OBJECT: {
                    this.workOnObject(action);
                    return;
                }
                case LIST: {
                    this.workOnList(action);
                    return;
                }
                case TYPED_OBJECT: {
                    this.workOnTypedObject(action);
                    return;
                }
            }
        }

        private void workOnTypedObject(Action action) {
            Object object = null;
            Class<?> componentType = action.finalType;
            try {
                switch (action.medium) {
                    case CHARS: {
                        object = this.parser.parse(componentType, (char[])action.payload);
                        break;
                    }
                    case STRING: {
                        object = this.parser.parse(componentType, (String)action.payload);
                        break;
                    }
                    case INPUT_STREAM: {
                        if (action.charSet == null) {
                            object = this.parser.parse(componentType, (InputStream)action.payload);
                            break;
                        }
                        object = this.parser.parse(componentType, (InputStream)action.payload, action.charSet);
                        break;
                    }
                    case BYTES: {
                        if (action.charSet == null) {
                            object = this.parser.parse(componentType, (byte[])action.payload);
                            break;
                        }
                        object = this.parser.parse(componentType, (byte[])action.payload, action.charSet);
                        break;
                    }
                    case READER: {
                        object = this.parser.parse(componentType, (Reader)action.payload);
                    }
                }
                if (action.returnQueue.hasWaitingConsumer()) {
                    action.returnQueue.transfer(object);
                } else {
                    action.returnQueue.put(object);
                }
            }
            catch (Exception ex) {
                try {
                    action.returnQueue.put(ex);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        private void workOnList(Action action) {
            Class<?> componentType = action.finalType;
            List<?> object = null;
            try {
                switch (action.medium) {
                    case CHARS: {
                        object = this.parser.parseList(componentType, (char[])action.payload);
                        break;
                    }
                    case STRING: {
                        object = this.parser.parseList(componentType, (String)action.payload);
                        break;
                    }
                    case INPUT_STREAM: {
                        if (action.charSet == null) {
                            object = this.parser.parseList(componentType, (InputStream)action.payload);
                            break;
                        }
                        object = this.parser.parseList(componentType, (InputStream)action.payload, action.charSet);
                        break;
                    }
                    case BYTES: {
                        if (action.charSet == null) {
                            object = this.parser.parseList(componentType, (byte[])action.payload);
                            break;
                        }
                        object = this.parser.parseList(componentType, (byte[])action.payload, action.charSet);
                        break;
                    }
                    case READER: {
                        object = this.parser.parseList(componentType, (Reader)action.payload);
                    }
                }
                if (action.returnQueue.hasWaitingConsumer()) {
                    action.returnQueue.transfer(object);
                } else {
                    action.returnQueue.put(object);
                }
            }
            catch (Exception ex) {
                try {
                    action.returnQueue.put(ex);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        private void workOnObject(Action action) {
            Object object = null;
            try {
                switch (action.medium) {
                    case CHARS: {
                        object = this.parser.parse((char[])action.payload);
                        break;
                    }
                    case STRING: {
                        object = this.parser.parse((String)action.payload);
                        break;
                    }
                    case INPUT_STREAM: {
                        if (action.charSet == null) {
                            object = this.parser.parse((InputStream)action.payload);
                            break;
                        }
                        object = this.parser.parse((InputStream)action.payload, action.charSet);
                        break;
                    }
                    case BYTES: {
                        if (action.charSet == null) {
                            object = this.parser.parse((byte[])action.payload);
                            break;
                        }
                        object = this.parser.parse((byte[])action.payload, action.charSet);
                        break;
                    }
                    case READER: {
                        object = this.parser.parse((Reader)action.payload);
                    }
                }
                if (action.returnQueue.hasWaitingConsumer()) {
                    action.returnQueue.transfer(object);
                } else {
                    action.returnQueue.put(object);
                }
            }
            catch (Exception ex) {
                try {
                    action.returnQueue.put(ex);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }
}

