/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.streaming.version1;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.boon.IO;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.reflection.fields.FieldsAccessorFieldThenProp;
import org.boon.json.JsonParser;
import org.boon.json.streaming.version1.JsonSlurper;
import org.boon.primitive.Byt;

public class StreamingJavaParserV1
implements JsonParser {
    JsonSlurper slurper = new JsonSlurper();
    FieldsAccessor fieldsAccessor = new FieldsAccessorFieldThenProp(false);

    @Override
    public Map<String, Object> parseMap(String value) {
        return (Map)this.slurper.parseText(value);
    }

    @Override
    public Map<String, Object> parseMap(char[] value) {
        return (Map)this.slurper.parseText(new String(value));
    }

    @Override
    public Map<String, Object> parseMap(byte[] value) {
        return (Map)this.slurper.parseText(new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public Map<String, Object> parseMap(byte[] value, Charset charset) {
        return (Map)this.slurper.parseText(new String(value, charset));
    }

    @Override
    public Map<String, Object> parseMap(InputStream value, Charset charset) {
        return (Map)this.slurper.parseText(IO.read(value, charset));
    }

    @Override
    public Map<String, Object> parseMap(CharSequence value) {
        return (Map)this.slurper.parseText(IO.read(value.toString()));
    }

    @Override
    public Map<String, Object> parseMap(InputStream value) {
        return (Map)this.slurper.parseText(IO.read(value));
    }

    @Override
    public Map<String, Object> parseMap(Reader value) {
        return (Map)this.slurper.parseText(IO.read(value));
    }

    @Override
    public Map<String, Object> parseMapFromFile(String file) {
        return (Map)this.slurper.parseText(IO.read(file));
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, String jsonString) {
        List list = (List)this.slurper.parseText(jsonString);
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input) {
        List list = (List)this.slurper.parseText(IO.read(input));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, Reader reader) {
        List list = (List)this.slurper.parseText(IO.read(reader));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, InputStream input, Charset charset) {
        List list = (List)this.slurper.parseText(IO.read(input, charset));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes) {
        List list = (List)this.slurper.parseText(new String(jsonBytes, StandardCharsets.UTF_8));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, byte[] jsonBytes, Charset charset) {
        List list = (List)this.slurper.parseText(new String(jsonBytes, charset));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, char[] chars) {
        List list = (List)this.slurper.parseText(new String(chars));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseList(Class<T> componentType, CharSequence jsonSeq) {
        List list = (List)this.slurper.parseText(new String(jsonSeq.toString()));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> List<T> parseListFromFile(Class<T> componentType, String fileName) {
        List list = (List)this.slurper.parseText(IO.read(fileName));
        return MapObjectConversion.convertListOfMapsToObjects(this.fieldsAccessor, componentType, list);
    }

    @Override
    public <T> T parse(Class<T> type, String jsonString) {
        Map map = (Map)this.slurper.parseText(jsonString);
        if (type == Map.class) {
            return (T)map;
        }
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes) {
        return this.parse(type, new String(bytes, StandardCharsets.UTF_8));
    }

    @Override
    public <T> T parse(Class<T> type, byte[] bytes, Charset charset) {
        return this.parse(type, new String(bytes, charset));
    }

    @Override
    public <T> T parse(Class<T> type, CharSequence charSequence) {
        return this.parse(type, charSequence.toString());
    }

    @Override
    public <T> T parse(Class<T> type, char[] chars) {
        return this.parse(type, new String(chars));
    }

    @Override
    public <T> T parse(Class<T> type, Reader reader) {
        return this.parse(type, IO.read(reader));
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input) {
        Map map = (Map)this.slurper.parseText(IO.read(input));
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public <T> T parse(Class<T> type, InputStream input, Charset charset) {
        Map map = (Map)this.slurper.parseText(IO.read(input, charset));
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public <T> T parseDirect(Class<T> type, byte[] value) {
        Map map = (Map)this.slurper.parseText(new String(value, StandardCharsets.UTF_8));
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public <T> T parseAsStream(Class<T> type, byte[] value) {
        Map map = (Map)this.slurper.parseText(new String(value, StandardCharsets.UTF_8));
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public <T> T parseFile(Class<T> type, String fileName) {
        Map map = (Map)this.slurper.parseText(IO.read(fileName));
        return (T)MapObjectConversion.fromMap((Map<String, Object>)map, type);
    }

    @Override
    public int parseInt(String jsonString) {
        return (Integer)this.slurper.parseText(jsonString);
    }

    @Override
    public int parseInt(InputStream input) {
        return (Integer)this.slurper.parseText(IO.read(input));
    }

    @Override
    public int parseInt(InputStream input, Charset charset) {
        return (Integer)this.slurper.parseText(IO.read(input, charset));
    }

    @Override
    public int parseInt(byte[] jsonBytes) {
        return (Integer)this.slurper.parseText(new String(jsonBytes, StandardCharsets.UTF_8));
    }

    @Override
    public int parseInt(byte[] jsonBytes, Charset charset) {
        return (Integer)this.slurper.parseText(new String(jsonBytes, charset));
    }

    @Override
    public int parseInt(char[] chars) {
        return (Integer)this.slurper.parseText(new String(chars));
    }

    @Override
    public int parseInt(CharSequence jsonSeq) {
        return (Integer)this.slurper.parseText(jsonSeq.toString());
    }

    @Override
    public int parseIntFromFile(String fileName) {
        return (Integer)this.slurper.parseText(IO.read(fileName));
    }

    @Override
    public long parseLong(String jsonString) {
        return (Long)this.slurper.parseText(jsonString);
    }

    @Override
    public long parseLong(InputStream input) {
        return (Long)this.slurper.parseText(IO.read(input));
    }

    @Override
    public long parseLong(InputStream input, Charset charset) {
        return (Long)this.slurper.parseText(IO.read(input, charset));
    }

    @Override
    public long parseLong(byte[] jsonBytes) {
        return (Long)this.slurper.parseText(Byt.utfString(jsonBytes));
    }

    @Override
    public long parseLong(byte[] jsonBytes, Charset charset) {
        return (Long)this.slurper.parseText(new String(jsonBytes, charset));
    }

    @Override
    public long parseLong(char[] chars) {
        return (Long)this.slurper.parseText(new String(chars));
    }

    @Override
    public long parseLong(CharSequence jsonSeq) {
        return (Long)this.slurper.parseText(jsonSeq.toString());
    }

    @Override
    public long parseLongFromFile(String fileName) {
        return (Long)this.slurper.parseText(IO.read(fileName));
    }

    @Override
    public double parseDouble(String value) {
        return (Double)this.slurper.parseText(value);
    }

    @Override
    public double parseDouble(InputStream value) {
        return (Double)this.slurper.parseText(IO.read(value));
    }

    @Override
    public double parseDouble(byte[] value) {
        return (Double)this.slurper.parseText(Byt.utfString(value));
    }

    @Override
    public double parseDouble(char[] value) {
        return (Double)this.slurper.parseText(new String(value));
    }

    @Override
    public double parseDouble(CharSequence value) {
        return (Double)this.slurper.parseText(value.toString());
    }

    @Override
    public double parseDouble(byte[] value, Charset charset) {
        return (Double)this.slurper.parseText(new String(value, charset));
    }

    @Override
    public double parseDouble(InputStream value, Charset charset) {
        return (Double)this.slurper.parseText(IO.read(value, charset));
    }

    @Override
    public double parseDoubleFromFile(String fileName) {
        return (Double)this.slurper.parseText(IO.read(fileName));
    }

    @Override
    public float parseFloat(String value) {
        return ((Float)this.slurper.parseText(value)).floatValue();
    }

    @Override
    public float parseFloat(InputStream value) {
        return ((Float)this.slurper.parseText(IO.read(value))).floatValue();
    }

    @Override
    public float parseFloat(byte[] value) {
        return ((Float)this.slurper.parseText(Byt.utfString(value))).floatValue();
    }

    @Override
    public float parseFloat(char[] value) {
        return ((Float)this.slurper.parseText(new String(value))).floatValue();
    }

    @Override
    public float parseFloat(CharSequence value) {
        return ((Float)this.slurper.parseText(value.toString())).floatValue();
    }

    @Override
    public float parseFloat(byte[] value, Charset charset) {
        return ((Float)this.slurper.parseText(new String(value, charset))).floatValue();
    }

    @Override
    public float parseFloat(InputStream value, Charset charset) {
        return ((Float)this.slurper.parseText(IO.read(value, charset))).floatValue();
    }

    @Override
    public float parseFloatFromFile(String fileName) {
        return ((Float)this.slurper.parseText(IO.read(fileName))).floatValue();
    }

    @Override
    public BigDecimal parseBigDecimal(String value) {
        return (BigDecimal)this.slurper.parseText(value);
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value) {
        return (BigDecimal)this.slurper.parseText(IO.read(value));
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value) {
        return (BigDecimal)this.slurper.parseText(Byt.utfString(value));
    }

    @Override
    public BigDecimal parseBigDecimal(char[] value) {
        return (BigDecimal)this.slurper.parseText(new String(value));
    }

    @Override
    public BigDecimal parseBigDecimal(CharSequence value) {
        return (BigDecimal)this.slurper.parseText(value.toString());
    }

    @Override
    public BigDecimal parseBigDecimal(byte[] value, Charset charset) {
        return (BigDecimal)this.slurper.parseText(new String(value, charset));
    }

    @Override
    public BigDecimal parseBigDecimal(InputStream value, Charset charset) {
        return (BigDecimal)this.slurper.parseText(IO.read(value, charset));
    }

    @Override
    public BigDecimal parseBigDecimalFromFile(String fileName) {
        return (BigDecimal)this.slurper.parseText(IO.read(fileName));
    }

    @Override
    public BigInteger parseBigInteger(String value) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(InputStream value) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(byte[] value) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(char[] value) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(CharSequence value) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(byte[] value, Charset charset) {
        return null;
    }

    @Override
    public BigInteger parseBigInteger(InputStream value, Charset charset) {
        return null;
    }

    @Override
    public BigInteger parseBigIntegerFile(String fileName) {
        return null;
    }

    @Override
    public Date parseDate(String jsonString) {
        return null;
    }

    @Override
    public Date parseDate(InputStream input) {
        return null;
    }

    @Override
    public Date parseDate(InputStream input, Charset charset) {
        return null;
    }

    @Override
    public Date parseDate(byte[] jsonBytes) {
        return null;
    }

    @Override
    public Date parseDate(byte[] jsonBytes, Charset charset) {
        return null;
    }

    @Override
    public Date parseDate(char[] chars) {
        return null;
    }

    @Override
    public Date parseDate(CharSequence jsonSeq) {
        return null;
    }

    @Override
    public Date parseDateFromFile(String fileName) {
        return null;
    }

    @Override
    public short parseShort(String jsonString) {
        return 0;
    }

    @Override
    public byte parseByte(String jsonString) {
        return 0;
    }

    @Override
    public char parseChar(String jsonString) {
        return '\u0000';
    }

    @Override
    public <T extends Enum> T parseEnum(Class<T> type, String jsonString) {
        return null;
    }

    @Override
    public char[] parseCharArray(String jsonString) {
        return new char[0];
    }

    @Override
    public byte[] parseByteArray(String jsonString) {
        return new byte[0];
    }

    @Override
    public short[] parseShortArray(String jsonString) {
        return new short[0];
    }

    @Override
    public int[] parseIntArray(String jsonString) {
        return new int[0];
    }

    @Override
    public float[] parseFloatArray(String jsonString) {
        return new float[0];
    }

    @Override
    public double[] parseDoubleArray(String jsonString) {
        return new double[0];
    }

    @Override
    public long[] parseLongArray(String jsonString) {
        return new long[0];
    }

    @Override
    public Object parse(String jsonString) {
        return this.slurper.parseText(jsonString);
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.slurper.parseText(Byt.utfString(bytes));
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.slurper.parseText(new String(bytes, charset));
    }

    @Override
    public Object parse(CharSequence charSequence) {
        return this.slurper.parseText(charSequence.toString());
    }

    @Override
    public Object parse(char[] chars) {
        return this.slurper.parseText(new String(chars));
    }

    @Override
    public Object parse(Reader reader) {
        return this.slurper.parseText(IO.read(reader));
    }

    @Override
    public Object parse(InputStream input) {
        return this.slurper.parseText(IO.read(input));
    }

    @Override
    public Object parse(InputStream input, Charset charset) {
        return this.slurper.parseText(IO.read(input, charset));
    }

    @Override
    public Object parseDirect(byte[] value) {
        return this.slurper.parseText(Byt.utfString(value));
    }

    @Override
    public Object parseAsStream(byte[] value) {
        return this.slurper.parseText(Byt.utfString(value));
    }

    @Override
    public Object parseFile(String fileName) {
        return this.slurper.parseText(IO.read(fileName));
    }

    @Override
    public void close() {
    }
}

