/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.boon.Exceptions;
import org.boon.primitive.Byt;
import org.boon.primitive.Input;
import org.boon.primitive.InputByteArray;
import org.boon.primitive.Output;

public class ByteBuf
implements Output {
    protected int capacity = 16;
    protected int length = 0;
    protected byte[] buffer;

    public static ByteBuf createExact(int capacity) {
        return new ByteBuf(capacity){

            @Override
            public ByteBuf add(byte[] chars) {
                Byt._idx(this.buffer, this.length, chars);
                this.length += chars.length;
                return this;
            }
        };
    }

    public static ByteBuf create(int capacity) {
        return new ByteBuf(capacity);
    }

    public static ByteBuf create(byte[] buffer) {
        ByteBuf buf = new ByteBuf(buffer.length);
        buf.buffer = buffer;
        return buf;
    }

    protected ByteBuf(int capacity) {
        this.capacity = capacity;
        this.init();
    }

    protected ByteBuf() {
        this.init();
    }

    private void init() {
        this.buffer = new byte[this.capacity];
    }

    public ByteBuf add(String str) {
        this.add(Byt.bytes(str));
        return this;
    }

    public ByteBuf add(int value) {
        if (4 + this.length < this.capacity) {
            Byt.intTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 4);
            this.capacity = this.buffer.length;
            Byt.intTo(this.buffer, this.length, value);
        }
        this.length += 4;
        return this;
    }

    public ByteBuf add(float value) {
        if (4 + this.length < this.capacity) {
            Byt.floatTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 4);
            this.capacity = this.buffer.length;
            Byt.floatTo(this.buffer, this.length, value);
        }
        this.length += 4;
        return this;
    }

    public ByteBuf add(char value) {
        if (2 + this.length < this.capacity) {
            Byt.charTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 2);
            this.capacity = this.buffer.length;
            Byt.charTo(this.buffer, this.length, value);
        }
        this.length += 2;
        return this;
    }

    public ByteBuf add(short value) {
        if (2 + this.length < this.capacity) {
            Byt.shortTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 2);
            this.capacity = this.buffer.length;
            Byt.shortTo(this.buffer, this.length, value);
        }
        this.length += 2;
        return this;
    }

    public ByteBuf addByte(int value) {
        this.add((byte)value);
        return this;
    }

    public ByteBuf add(byte value) {
        if (1 + this.length < this.capacity) {
            Byt.idx(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer);
            this.capacity = this.buffer.length;
            Byt.idx(this.buffer, this.length, value);
        }
        ++this.length;
        return this;
    }

    public ByteBuf add(long value) {
        if (8 + this.length < this.capacity) {
            Byt.longTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 8);
            this.capacity = this.buffer.length;
            Byt.longTo(this.buffer, this.length, value);
        }
        this.length += 8;
        return this;
    }

    public ByteBuf addUnsignedInt(long value) {
        if (4 + this.length < this.capacity) {
            Byt.unsignedIntTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 4);
            this.capacity = this.buffer.length;
            Byt.unsignedIntTo(this.buffer, this.length, value);
        }
        this.length += 4;
        return this;
    }

    public ByteBuf add(double value) {
        if (8 + this.length < this.capacity) {
            Byt.doubleTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 8);
            this.capacity = this.buffer.length;
            Byt.doubleTo(this.buffer, this.length, value);
        }
        this.length += 8;
        return this;
    }

    public ByteBuf add(byte[] array) {
        if (array.length + this.length < this.capacity) {
            Byt._idx(this.buffer, this.length, array);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + array.length);
            this.capacity = this.buffer.length;
            Byt._idx(this.buffer, this.length, array);
        }
        this.length += array.length;
        return this;
    }

    public ByteBuf add(byte[] array, int length) {
        if (this.length + length < this.capacity) {
            Byt._idx(this.buffer, this.length, array, length);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + length);
            this.capacity = this.buffer.length;
            Byt._idx(this.buffer, length, array, length);
        }
        this.length += length;
        return this;
    }

    public ByteBuf add(byte[] array, int offset, int length) {
        if (this.length + length < this.capacity) {
            Byt._idx(this.buffer, length, array, offset, length);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + length);
            this.capacity = this.buffer.length;
            Byt._idx(this.buffer, length, array, offset, length);
        }
        this.length += length;
        return this;
    }

    public byte[] readAndReset() {
        byte[] bytes = this.buffer;
        this.buffer = null;
        return bytes;
    }

    public byte[] readForRecycle() {
        this.length = 0;
        return this.buffer;
    }

    public int len() {
        return this.length;
    }

    public ByteBuf addUrlEncodedByteArray(byte[] value) {
        byte[] encoded = new byte[2];
        for (int index = 0; index < value.length; ++index) {
            byte i = value[index];
            if (i >= 97 && i <= 122) {
                this.addByte(i);
                continue;
            }
            if (i >= 65 && i <= 90) {
                this.addByte(i);
                continue;
            }
            if (i >= 48 && i <= 57) {
                this.addByte(i);
                continue;
            }
            if (i == 95 || i == 45 || i == 46 || i == 42) {
                this.addByte(i);
                continue;
            }
            if (i == 32) {
                this.addByte(43);
                continue;
            }
            ByteBuf.encodeByteIntoTwoAsciiCharBytes(i, encoded);
            this.addByte(37);
            this.addByte(encoded[0]);
            this.addByte(encoded[1]);
        }
        return this;
    }

    public ByteBuf addJSONEncodedByteArray(byte[] value) {
        if (value == null) {
            this.add("null");
            return this;
        }
        this.addByte(34);
        block10: for (int index = 0; index < value.length; ++index) {
            byte ch = value[index];
            switch (ch) {
                case 34: {
                    this.addByte(92);
                    this.addByte(34);
                    continue block10;
                }
                case 92: {
                    this.addByte(92);
                    this.addByte(92);
                    continue block10;
                }
                case 47: {
                    this.addByte(92);
                    this.addByte(47);
                    continue block10;
                }
                case 10: {
                    this.addByte(92);
                    this.addByte(110);
                    continue block10;
                }
                case 9: {
                    this.addByte(92);
                    this.addByte(116);
                    continue block10;
                }
                case 13: {
                    this.addByte(92);
                    this.addByte(114);
                    continue block10;
                }
                case 8: {
                    this.addByte(92);
                    this.addByte(98);
                    continue block10;
                }
                case 12: {
                    this.addByte(92);
                    this.addByte(102);
                    continue block10;
                }
                default: {
                    if (ch > 127) {
                        this.addByte(92);
                        this.addByte(117);
                        this.addByte(48);
                        this.addByte(48);
                        byte[] encoded = new byte[2];
                        ByteBuf.encodeByteIntoTwoAsciiCharBytes(ch, encoded);
                        this.addByte(encoded[0]);
                        this.addByte(encoded[1]);
                        continue block10;
                    }
                    this.addByte(ch);
                }
            }
        }
        this.addByte(34);
        return this;
    }

    protected static int encodeNibbleToHexAsciiCharByte(int nibble) {
        switch (nibble) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return nibble + 48;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return nibble + 87;
            }
        }
        Exceptions.die("illegal nibble: " + nibble);
        return -1;
    }

    public static void encodeByteIntoTwoAsciiCharBytes(int decoded, byte[] encoded) {
        Objects.requireNonNull(encoded);
        boolean ok = true;
        ok |= encoded.length == 2 || Exceptions.die("encoded array must be 2");
        encoded[0] = (byte)ByteBuf.encodeNibbleToHexAsciiCharByte(decoded >> 4 & 0xF);
        encoded[1] = (byte)ByteBuf.encodeNibbleToHexAsciiCharByte(decoded & 0xF);
    }

    public ByteBuf addUrlEncoded(String key) {
        try {
            this.addUrlEncodedByteArray(key.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Exceptions.handle(e);
        }
        return this;
    }

    public ByteBuf addJSONEncodedString(String value) {
        try {
            this.addJSONEncodedByteArray(value == null ? null : value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Exceptions.handle(e);
        }
        return this;
    }

    @Override
    public void write(int b) {
        this.addByte(b);
    }

    @Override
    public void write(byte[] b) {
        this.add(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.add(b, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        if (v) {
            this.addByte(1);
        } else {
            this.addByte(0);
        }
    }

    @Override
    public void writeByte(byte v) {
        this.addByte(v);
    }

    @Override
    public void writeUnsignedByte(short v) {
        this.addUnsignedByte(v);
    }

    public void addUnsignedByte(short value) {
        if (1 + this.length < this.capacity) {
            Byt.unsignedByteTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 1);
            this.capacity = this.buffer.length;
            Byt.unsignedByteTo(this.buffer, this.length, value);
        }
        ++this.length;
    }

    @Override
    public void writeShort(short v) {
        this.add(v);
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.addUnsignedShort(v);
    }

    public void addUnsignedShort(int value) {
        if (2 + this.length < this.capacity) {
            Byt.unsignedShortTo(this.buffer, this.length, value);
        } else {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + 2);
            this.capacity = this.buffer.length;
            Byt.unsignedShortTo(this.buffer, this.length, value);
        }
        this.length += 2;
    }

    @Override
    public void writeChar(char v) {
        this.add(v);
    }

    @Override
    public void writeInt(int v) {
        this.add(v);
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.addUnsignedInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.add(v);
    }

    @Override
    public void writeFloat(float v) {
        this.add(v);
    }

    @Override
    public void writeDouble(double v) {
        this.add(v);
    }

    @Override
    public void writeLargeString(String s) {
        byte[] bytes = Byt.bytes(s);
        this.add(bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeSmallString(String s) {
        byte[] bytes = Byt.bytes(s);
        this.addUnsignedByte((short)bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeMediumString(String s) {
        byte[] bytes = Byt.bytes(s);
        this.addUnsignedShort(bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeLargeByteArray(byte[] bytes) {
        this.add(bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeSmallByteArray(byte[] bytes) {
        this.addUnsignedByte((short)bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeMediumByteArray(byte[] bytes) {
        this.addUnsignedShort(bytes.length);
        this.add(bytes);
    }

    @Override
    public void writeLargeShortArray(short[] values) {
        int byteSize = values.length * 2 + 4;
        this.add(values.length);
        this.doWriteShortArray(values, byteSize);
    }

    @Override
    public void writeSmallShortArray(short[] values) {
        int byteSize = values.length * 2 + 1;
        this.addUnsignedByte((short)values.length);
        this.doWriteShortArray(values, byteSize);
    }

    @Override
    public void writeMediumShortArray(short[] values) {
        int byteSize = values.length * 2 + 2;
        this.addUnsignedShort(values.length);
        this.doWriteShortArray(values, byteSize);
    }

    private void doWriteShortArray(short[] values, int byteSize) {
        if (byteSize + this.length >= this.capacity) {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + byteSize);
        }
        for (int index = 0; index < values.length; ++index) {
            this.add(values[index]);
        }
    }

    @Override
    public void writeLargeIntArray(int[] values) {
        int byteSize = values.length * 4 + 4;
        this.add(values.length);
        this.doWriteIntArray(values, byteSize);
    }

    @Override
    public void writeSmallIntArray(int[] values) {
        int byteSize = values.length * 4 + 1;
        this.addUnsignedByte((short)values.length);
        this.doWriteIntArray(values, byteSize);
    }

    @Override
    public void writeMediumIntArray(int[] values) {
        int byteSize = values.length * 4 + 2;
        this.addUnsignedShort(values.length);
        this.doWriteIntArray(values, byteSize);
    }

    private void doWriteIntArray(int[] values, int byteSize) {
        if (byteSize + this.length >= this.capacity) {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + byteSize);
        }
        for (int index = 0; index < values.length; ++index) {
            this.add(values[index]);
        }
    }

    public Input input() {
        return new InputByteArray(this.buffer);
    }

    @Override
    public void writeLargeLongArray(long[] values) {
        int byteSize = values.length * 8 + 4;
        this.add(values.length);
        this.doWriteLongArray(values, byteSize);
    }

    @Override
    public void writeSmallLongArray(long[] values) {
        int byteSize = values.length * 8 + 1;
        this.addUnsignedByte((short)values.length);
        this.doWriteLongArray(values, byteSize);
    }

    @Override
    public void writeMediumLongArray(long[] values) {
        int byteSize = values.length * 8 + 2;
        this.addUnsignedShort(values.length);
        this.doWriteLongArray(values, byteSize);
    }

    private void doWriteLongArray(long[] values, int byteSize) {
        if (byteSize + this.length >= this.capacity) {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + byteSize);
        }
        for (int index = 0; index < values.length; ++index) {
            this.add(values[index]);
        }
    }

    @Override
    public void writeLargeFloatArray(float[] values) {
        int byteSize = values.length * 4 + 4;
        this.add(values.length);
        this.doWriteFloatArray(values, byteSize);
    }

    @Override
    public void writeSmallFloatArray(float[] values) {
        int byteSize = values.length * 4 + 1;
        this.addUnsignedByte((short)values.length);
        this.doWriteFloatArray(values, byteSize);
    }

    @Override
    public void writeMediumFloatArray(float[] values) {
        int byteSize = values.length * 4 + 2;
        this.addUnsignedShort(values.length);
        this.doWriteFloatArray(values, byteSize);
    }

    private void doWriteFloatArray(float[] values, int byteSize) {
        if (byteSize + this.length >= this.capacity) {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + byteSize);
        }
        for (int index = 0; index < values.length; ++index) {
            this.add(values[index]);
        }
    }

    @Override
    public void writeLargeDoubleArray(double[] values) {
        int byteSize = values.length * 8 + 4;
        this.add(values.length);
        this.doWriteDoubleArray(values, byteSize);
    }

    @Override
    public void writeSmallDoubleArray(double[] values) {
        int byteSize = values.length * 8 + 1;
        this.addUnsignedByte((short)values.length);
        this.doWriteDoubleArray(values, byteSize);
    }

    @Override
    public void writeMediumDoubleArray(double[] values) {
        int byteSize = values.length * 8 + 2;
        this.addUnsignedShort(values.length);
        this.doWriteDoubleArray(values, byteSize);
    }

    private void doWriteDoubleArray(double[] values, int byteSize) {
        if (byteSize + this.length >= this.capacity) {
            this.buffer = Byt.grow(this.buffer, this.buffer.length * 2 + byteSize);
        }
        for (int index = 0; index < values.length; ++index) {
            this.add(values[index]);
        }
    }

    public String toString() {
        int len = this.len();
        char[] chars = new char[this.buffer.length];
        for (int index = 0; index < chars.length; ++index) {
            chars[index] = (char)this.buffer[index];
        }
        return new String(chars, 0, len);
    }

    public byte[] toBytes() {
        return Byt.slc(this.buffer, 0, this.length);
    }

    public byte[] slc(int startIndex, int endIndex) {
        return Byt.slc(this.buffer, startIndex, endIndex);
    }
}

