/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Objects;
import org.boon.primitive.Byt;

public class ByteScanner {
    static final String MIN_INT_STR_NO_SIGN = String.valueOf(Integer.MIN_VALUE).substring(1);
    static final String MAX_INT_STR = String.valueOf(Integer.MAX_VALUE);
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final long L_BILLION = 1000000000L;
    private static double[] powersOf10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14};

    public static byte[][] splitExact(byte[] inputArray, int split, int resultsArrayLength) {
        int actualLength;
        Object results = new byte[resultsArrayLength][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            if (c == split) {
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
            }
            ++index;
            ++currentLineLength;
        }
        if (c != split) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < resultsArrayLength) {
            int newSize = resultsArrayLength - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitExact(byte[] inputArray, int resultsArrayLength, int ... delims) {
        int actualLength;
        Object results = new byte[resultsArrayLength][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            for (int j = 0; j < delims.length; ++j) {
                int split = delims[j];
                if (c != split) continue;
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
                break;
            }
            ++index;
            ++currentLineLength;
        }
        if (!Byt.inIntArray((byte)c, delims)) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < resultsArrayLength) {
            int newSize = resultsArrayLength - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] split(byte[] inputArray, int split) {
        int actualLength;
        Object results = new byte[16][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            if (c == split) {
                if (resultIndex == ((byte[][])results).length) {
                    results = ByteScanner._grow(results);
                }
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
            }
            ++index;
            ++currentLineLength;
        }
        if (c != split) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < ((byte[][])results).length) {
            int newSize = ((byte[][])results).length - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitByChars(byte[] inputArray, int ... delims) {
        int actualLength;
        Object results = new byte[16][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            for (int j = 0; j < delims.length; ++j) {
                int split = delims[j];
                if (c != split) continue;
                if (resultIndex == ((byte[][])results).length) {
                    results = ByteScanner._grow(results);
                }
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
                break;
            }
            ++index;
            ++currentLineLength;
        }
        if (!Byt.inIntArray((byte)c, delims)) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < ((byte[][])results).length) {
            int newSize = ((byte[][])results).length - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    private static byte[][] _grow(byte[][] array) {
        Objects.requireNonNull(array);
        byte[][] newArray = new byte[array.length * 2][];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private static byte[][] __shrink(byte[][] array, int size) {
        Objects.requireNonNull(array);
        byte[][] newArray = new byte[array.length - size][];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static boolean isInteger(byte[] digitChars, int offset, int len, boolean negative) {
        String cmpStr = negative ? MIN_INT_STR_NO_SIGN : MAX_INT_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static boolean isLong(byte[] digitChars, int offset, int len, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static int parseInt(byte[] digitChars, int offset, int len) {
        int to;
        int num = digitChars[offset] - 48;
        if (++offset < (to = len + offset)) {
            num = num * 10 + (digitChars[offset] - 48);
            if (++offset < to) {
                num = num * 10 + (digitChars[offset] - 48);
                if (++offset < to) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < to) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < to) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < to) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < to) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < to) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static int parseIntIgnoreDot(byte[] digitChars, int offset, int len) {
        int to;
        int num = digitChars[offset] - 48;
        if (++offset < (to = len + offset)) {
            int n = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
            if (++offset < to) {
                int n2 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                if (++offset < to) {
                    int n3 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                    if (++offset < to) {
                        int n4 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                        if (++offset < to) {
                            int n5 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                            if (++offset < to) {
                                int n6 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                if (++offset < to) {
                                    int n7 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                    if (++offset < to) {
                                        int n8 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                        if (++offset < to) {
                                            num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static long parseLong(byte[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)ByteScanner.parseInt(digitChars, offset, len1) * 1000000000L;
        return val + (long)ByteScanner.parseInt(digitChars, offset + len1, 9);
    }

    public static long parseLongIgnoreDot(byte[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)ByteScanner.parseIntIgnoreDot(digitChars, offset, len1) * 1000000000L;
        return val + (long)ByteScanner.parseIntIgnoreDot(digitChars, offset + len1, 9);
    }

    public static double doubleValue(byte[] buffer, int startIndex, int endIndex) {
        double sign;
        boolean simple = true;
        int digitsPastPoint = 0;
        boolean foundPoint = false;
        boolean negative = false;
        if (buffer[startIndex] == 45) {
            ++startIndex;
            negative = true;
            sign = -1.0;
        } else {
            negative = false;
            sign = 1.0;
        }
        block7: for (int index = startIndex; index < endIndex; ++index) {
            byte ch = buffer[index];
            switch (ch) {
                case 101: {
                    simple = false;
                    break block7;
                }
                case 69: {
                    simple = false;
                    break block7;
                }
                case 70: {
                    simple = false;
                    break block7;
                }
                case 102: {
                    simple = false;
                    break block7;
                }
                case 46: {
                    foundPoint = true;
                    continue block7;
                }
                default: {
                    if (!foundPoint || ++digitsPastPoint < powersOf10.length) continue block7;
                    simple = true;
                    break block7;
                }
            }
        }
        if (simple) {
            int length = endIndex - startIndex;
            long value = ByteScanner.isInteger(buffer, startIndex, length, negative) ? (long)ByteScanner.parseIntIgnoreDot(buffer, startIndex, length) : ByteScanner.parseLongIgnoreDot(buffer, startIndex, length);
            if (digitsPastPoint < powersOf10.length) {
                double power = powersOf10[digitsPastPoint] * sign;
                return (double)value / power;
            }
        }
        return Double.parseDouble(new String(buffer, startIndex, endIndex - startIndex)) * sign;
    }

    public static double simpleDouble(byte[] buffer, boolean simple, boolean negative, int digitsPastPoint, int startIndex, int endIndex) {
        double sign = negative ? -1.0 : 1.0;
        if (simple) {
            int length = endIndex - startIndex;
            long value = ByteScanner.isInteger(buffer, startIndex, length, negative) ? (long)ByteScanner.parseIntIgnoreDot(buffer, startIndex, length) : ByteScanner.parseLongIgnoreDot(buffer, startIndex, length);
            if (digitsPastPoint < powersOf10.length) {
                double power = powersOf10[digitsPastPoint] * sign;
                return (double)value / power;
            }
        }
        return Double.parseDouble(new String(buffer, startIndex, endIndex - startIndex)) * sign;
    }
}

