/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Arrays;
import java.util.Objects;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.primitive.CharScanner;

public class Chr {
    public static final char[] DEFAULT_SPLIT = new char[]{' ', '\t', ',', ':', ';'};
    public static final char[] NEWLINE_CHARS = new char[]{'\n', '\r'};

    public static char[] arrayOfChar(int size) {
        return new char[size];
    }

    @Universal
    public static char[] array(char ... array) {
        Objects.requireNonNull(array);
        return array;
    }

    @Universal
    public static char[] chars(String array) {
        return array.toCharArray();
    }

    @Universal
    public static int len(char[] array) {
        return array.length;
    }

    @Universal
    public static char idx(char[] array, int index) {
        int i = Chr.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(char[] array, int index, char value) {
        int i = Chr.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static void idx(char[] array, int index, char[] input) {
        int i = Chr.calculateIndex(array, index);
        Chr._idx(array, i, input);
    }

    @Universal
    public static char[] slc(char[] array, int startIndex, int endIndex) {
        Objects.requireNonNull(array);
        int start = Chr.calculateIndex(array, startIndex);
        int end = Chr.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static char[] slc(char[] array, int startIndex) {
        Objects.requireNonNull(array);
        int start = Chr.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static char[] slcEnd(char[] array, int endIndex) {
        int end;
        Objects.requireNonNull(array);
        int newLength = end = Chr.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(char value, char[] array) {
        for (char currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static boolean in(char value, int offset, char[] array) {
        for (int index = offset; index < array.length; ++index) {
            char currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static boolean in(char value, int offset, int end, char[] array) {
        for (int index = offset; index < end; ++index) {
            char currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static char[] grow(char[] array, int size) {
        char[] newArray = new char[array.length + size];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static char[] grow(char[] array) {
        char[] newArray = new char[array.length * 2];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static char[] shrink(char[] array, int size) {
        char[] newArray = new char[array.length - size];
        Chr.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static char[] compact(char[] array) {
        Objects.requireNonNull(array);
        int nullCount = 0;
        for (char ch : array) {
            if (ch != '\u0000') continue;
            ++nullCount;
        }
        char[] newArray = new char[array.length - nullCount];
        int j = 0;
        for (char ch : array) {
            if (ch == '\u0000') continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static char[][] split(char[] chars) {
        return CharScanner.splitByChars(chars, DEFAULT_SPLIT);
    }

    public static char[][] splitLine(char[] chars) {
        return CharScanner.splitByChars(chars, NEWLINE_CHARS);
    }

    @Universal
    public static char[] copy(char[] array) {
        Objects.requireNonNull(array);
        char[] newArray = new char[array.length];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static char[] copy(char[] array, int offset, int length) {
        Objects.requireNonNull(array);
        char[] newArray = new char[length];
        Chr.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    @Universal
    public static char[] add(char[] array, char v) {
        Objects.requireNonNull(array);
        char[] newArray = new char[array.length + 1];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static char[] add(char[] array, String str) {
        return Chr.add(array, str.toCharArray());
    }

    @Universal
    public static char[] add(char[] array, StringBuilder stringBuilder) {
        return Chr.add(array, Chr.getCharsFromStringBuilder(stringBuilder));
    }

    @Universal
    public static char[] add(char[] array, char[] array2) {
        Objects.requireNonNull(array);
        char[] newArray = new char[array.length + array2.length];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        Chr.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static char[] insert(char[] array, int idx, char v) {
        Objects.requireNonNull(array);
        if (idx >= array.length) {
            return Chr.add(array, v);
        }
        int index = Chr.calculateIndex(array, idx);
        char[] newArray = new char[array.length + 1];
        if (index != 0) {
            Chr.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            Chr.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            Chr.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, String values) {
        return Chr.insert(array, fromIndex, values.toCharArray());
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, StringBuilder values) {
        return Chr.insert(array, fromIndex, Chr.getCharsFromStringBuilder(values));
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, char[] values) {
        Objects.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Chr.add(array, values);
        }
        int index = Chr.calculateIndex(array, fromIndex);
        char[] newArray = new char[array.length + values.length];
        if (index != 0) {
            Chr.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            Chr.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            Chr.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static char[] getCharsFromStringBuilder(StringBuilder sbuf) {
        int length = sbuf.length();
        char[] array2 = new char[sbuf.length()];
        sbuf.getChars(0, sbuf.length(), array2, 0);
        return array2;
    }

    private static int calculateIndex(char[] array, int originalIndex) {
        int length = array.length;
        Objects.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    public static char[] rpad(char[] in, int size, char pad) {
        if (in.length >= size) {
            return in;
        }
        int index = 0;
        char[] newArray = new char[size];
        for (index = 0; index < in.length; ++index) {
            newArray[index] = in[index];
        }
        while (index < size) {
            newArray[index] = pad;
            ++index;
        }
        return newArray;
    }

    public static char[] lpad(char[] in, int size, char pad) {
        int index;
        if (in.length >= size) {
            return in;
        }
        int delta = size - in.length;
        char[] newArray = new char[size];
        for (index = 0; index < delta; ++index) {
            newArray[index] = pad;
        }
        for (int index2 = 0; index2 < in.length; ++index2) {
            newArray[index] = in[index2];
            ++index;
        }
        return newArray;
    }

    public static char[] underBarCase(char[] in) {
        int index;
        if (in == null || in.length == 0 || in.length == 1) {
            return in;
        }
        char[] out = null;
        int count = 0;
        boolean wasLower = false;
        for (index = 0; index < in.length; ++index) {
            char ch = in[index];
            boolean isUpper = Character.isUpperCase(ch);
            if (wasLower && isUpper) {
                ++count;
            }
            wasLower = Character.isLowerCase(ch);
        }
        out = new char[in.length + count];
        wasLower = false;
        index = 0;
        int secondIndex = 0;
        while (index < in.length) {
            char ch = in[index];
            boolean isUpper = Character.isUpperCase(ch);
            if (wasLower && isUpper) {
                out[secondIndex] = 95;
                ++secondIndex;
            }
            out[secondIndex] = ch == ' ' || ch == '-' || ch == '\t' ? 95 : Character.toUpperCase(ch);
            wasLower = Character.isLowerCase(ch);
            ++index;
            ++secondIndex;
        }
        return out;
    }

    public static char[] camelCase(char[] in, boolean upper) {
        if (in == null || in.length == 0 || in.length == 1) {
            return in;
        }
        char[] out = null;
        int count = 0;
        for (int index = 0; index < in.length; ++index) {
            char ch = in[index];
            if (ch != '_' && ch != ' ' && ch != '\t') continue;
            ++count;
        }
        out = new char[in.length - count];
        boolean upperNext = false;
        int secondIndex = 0;
        for (int index = 0; index < in.length; ++index) {
            char ch = in[index];
            if (ch == '_' || ch == ' ' || ch == '\t') {
                upperNext = true;
                continue;
            }
            out[secondIndex] = upperNext ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            upperNext = false;
            ++secondIndex;
        }
        out[0] = upper ? Character.toUpperCase(out[0]) : Character.toLowerCase(out[0]);
        return out;
    }

    public static char[][] split(char[] inputArray, char split) {
        return CharScanner.split(inputArray, split);
    }

    public static boolean contains(char[] chars, char c) {
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] chars, char c, int start, int length) {
        int to = length + start;
        for (int index = start; index < to; ++index) {
            char ch = chars[index];
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    public static void _idx(char[] buffer, int location, byte[] chars) {
        int index2 = 0;
        int endLocation = location + chars.length;
        int index = location;
        while (index < endLocation) {
            buffer[index] = (char)chars[index2];
            ++index;
            ++index2;
        }
    }

    public static void _idx(char[] array, int startIndex, char[] input) {
        try {
            Chr.arraycopy(input, 0, array, startIndex, input.length);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    private static void arraycopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static void _idx(char[] array, int startIndex, char[] input, int inputLength) {
        try {
            Chr.arraycopy(input, 0, array, startIndex, inputLength);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    public static void _idx(char[] buffer, int location, byte[] chars, int start, int end) {
        int index2 = start;
        int endLocation = location + (end - start);
        int index = location;
        while (index < endLocation) {
            buffer[index] = (char)chars[index2];
            ++index;
            ++index2;
        }
    }

    public static char[] trim(char[] buffer, int start, int to) {
        while (start < to && buffer[start] <= ' ') {
            ++start;
        }
        while (start < to && buffer[to - 1] <= ' ') {
            --to;
        }
        return start > 0 || to < buffer.length ? Arrays.copyOfRange(buffer, start, to) : buffer;
    }
}

