/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Objects;
import org.boon.Universal;

public class Flt {
    public static float[] grow(float[] array, int size) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static float[] grow(float[] array) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static float[] shrink(float[] array, int size) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static float[] compact(float[] array) {
        Objects.requireNonNull(array);
        int nullCount = 0;
        for (float ch : array) {
            if (ch != 0.0f) continue;
            ++nullCount;
        }
        float[] newArray = new float[array.length - nullCount];
        int j = 0;
        for (float ch : array) {
            if (ch == 0.0f) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static float[] arrayOfFloat(int size) {
        return new float[size];
    }

    @Universal
    public static float[] array(float ... array) {
        Objects.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(float[] array) {
        return array.length;
    }

    @Universal
    public static float idx(float[] array, int index) {
        int i = Flt.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(float[] array, int index, float value) {
        int i = Flt.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static float[] slc(float[] array, int startIndex, int endIndex) {
        Objects.requireNonNull(array);
        int start = Flt.calculateIndex(array, startIndex);
        int end = Flt.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static float[] slc(float[] array, int startIndex) {
        Objects.requireNonNull(array);
        int start = Flt.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static float[] slcEnd(float[] array, int endIndex) {
        int end;
        Objects.requireNonNull(array);
        int newLength = end = Flt.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(float value, float[] array) {
        for (float currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static float[] copy(float[] array) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static float[] add(float[] array, float v) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static float[] add(float[] array, float[] array2) {
        Objects.requireNonNull(array);
        float[] newArray = new float[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static float[] insert(float[] array, int idx, float v) {
        Objects.requireNonNull(array);
        if (idx >= array.length) {
            return Flt.add(array, v);
        }
        int index = Flt.calculateIndex(array, idx);
        float[] newArray = new float[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static float[] insert(float[] array, int fromIndex, float[] values) {
        Objects.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Flt.add(array, values);
        }
        int index = Flt.calculateIndex(array, fromIndex);
        float[] newArray = new float[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(float[] array, int originalIndex) {
        int length = array.length;
        Objects.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }
}

