/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.readers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.boon.validation.ValidatorMetaData;
import org.boon.validation.ValidatorMetaDataReader;

public class ChainValidatorMetaDataReader
implements ValidatorMetaDataReader {
    public static final String OVERRIDE_NAME = "validator.override.name";
    private List<ValidatorMetaDataReader> chain;

    public void setChain(List<ValidatorMetaDataReader> chain) {
        this.chain = chain;
    }

    @Override
    public List<ValidatorMetaData> readMetaData(Class<?> clazz, String propertyName) {
        LinkedHashMap<String, ValidatorMetaData> overrideMap = new LinkedHashMap<String, ValidatorMetaData>();
        for (ValidatorMetaDataReader reader : this.chain) {
            List<ValidatorMetaData> list = reader.readMetaData(clazz, propertyName);
            for (ValidatorMetaData data : list) {
                String overrideName = data.getName();
                if (data.getProperties() != null && data.getProperties().get(OVERRIDE_NAME) != null) {
                    overrideName = (String)data.getProperties().get(OVERRIDE_NAME);
                    data.getProperties().remove(OVERRIDE_NAME);
                }
                overrideMap.put(overrideName, data);
            }
        }
        return new ArrayList<ValidatorMetaData>(overrideMap.values());
    }
}

