/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime$;
import better.files.File;
import better.files.File$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.MapMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\f\u0019\u0001\u0005B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB-\u0001A\u0003%1\u000bC\u0003[\u0001\u0011\u00053\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\tI\n\u0001C!\u00037C\u0011\"!/\u0001#\u0003%\t!a/\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u00111\u0018\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\t9\u0010\u0001C!\u0003sDq!!@\u0001\t\u0013\tyP\u0001\u0007GS2,\u0007K]8wS\u0012,'O\u0003\u0002\u001a5\u0005A\u0001O]8wS\u0012,'O\u0003\u0002\u001c9\u000511oM7pG.T!!\b\u0010\u0002\u000f\u0019Lg\u000eZ5gs*\tq$\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001#Q1\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015+\u001b\u0005A\u0012BA\u0016\u0019\u0005!\u0001&o\u001c<jI\u0016\u0014\bCA\u00175\u001b\u0005q#BA\u00181\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\t$'\u0001\u0005usB,7/\u00194f\u0015\u0005\u0019\u0014aA2p[&\u0011QG\f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002eSJ\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e%\u001b\u0005Y$B\u0001\u001f!\u0003\u0019a$o\\8u}%\u0011a\bJ\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?I\u00051A(\u001b8jiz\"\"\u0001R#\u0011\u0005%\u0002\u0001\"\u0002\u001c\u0003\u0001\u00049\u0014aB<pe.$\u0015N]\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0006M&dWm\u001d\u0006\u0002\u001b\u00061!-\u001a;uKJL!a\u0014&\u0003\t\u0019KG.Z\u0001\to>\u00148\u000eR5sA\u0005!Q.\u001a;b+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\u0019\u0003!iW\r^1eCR\f\u0017B\u0001-V\u0005Ai\u0015\r]'fi\u0006$\u0017\r^1Ti>\u0014X-A\u0003nKR\f\u0007%A\u0007nKR\fG-\u0019;b'R|'/Z\u000b\u00029B\u0011A+X\u0005\u0003=V\u0013Q\"T3uC\u0012\fG/Y*u_J,\u0017a\u00037jgR\u0014UoY6fiN,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003Ij\t\u0001B]3ta>t7/Z\u0005\u0003M\u000e\u0014\u0001\u0003T5ti\u0006cG.T=Ck\u000e\\W\r^:\u0002\u00151L7\u000f\u001e\"vG.,G\u000fF\u0003jY:\u001cX\u000f\u0005\u0002cU&\u00111n\u0019\u0002\u000b\u0019&\u001cHOQ;dW\u0016$\b\"B7\n\u0001\u00049\u0014A\u00022vG.,G\u000fC\u0003p\u0013\u0001\u0007\u0001/\u0001\u0004qe\u00164\u0017\u000e\u001f\t\u0004GE<\u0014B\u0001:%\u0005\u0019y\u0005\u000f^5p]\")A/\u0003a\u0001a\u0006IA-\u001a7j[&$XM\u001d\u0005\u0006m&\u0001\ra^\u0001\b[\u0006D8.Z=t!\r\u0019\u0013\u000f\u001f\t\u0003GeL!A\u001f\u0013\u0003\u0007%sG/\u0001\u0007de\u0016\fG/\u001a\"vG.,G\u000fF\u0003~\u0003\u0003\t)\u0001\u0005\u0002c}&\u0011qp\u0019\u0002\r\u0007J,\u0017\r^3Ck\u000e\\W\r\u001e\u0005\u0007\u0003\u0007Q\u0001\u0019A\u001c\u0002\t9\fW.\u001a\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u00031\u0011WoY6fi\u000e{gNZ5h!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b5\u00059!/Z9vKN$\u0018\u0002BA\n\u0003\u001b\u0011\u0011d\u0011:fCR,')^2lKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006I\u0001/\u001e;PE*,7\r\u001e\u000b\u000b\u00033\ty\"!\t\u0002&\u0005U\u0002cA\u0012\u0002\u001c%\u0019\u0011Q\u0004\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006[.\u0001\ra\u000e\u0005\u0007\u0003GY\u0001\u0019A\u001c\u0002\u0007-,\u0017\u0010C\u0004\u0002(-\u0001\r!!\u000b\u0002\t\u0011\fG/\u0019\t\u0006G\u0005-\u0012qF\u0005\u0004\u0003[!#!B!se\u0006L\bcA\u0012\u00022%\u0019\u00111\u0007\u0013\u0003\t\tKH/\u001a\u0005\b\u0003oY\u0001\u0019AA\u001d\u00039y'M[3di6+G/\u00193bi\u0006\u0004B!a\u000f\u0002N5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0003n_\u0012,GN\u0003\u0003\u0002D\u0005\u0015\u0013AA:4\u0015\u0011\t9%!\u0013\u0002\u0011M,'O^5dKNT1!a\u00133\u0003%\tW.\u0019>p]\u0006<8/\u0003\u0003\u0002P\u0005u\"AD(cU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\nO\u0016$xJ\u00196fGR$b!!\u0016\u0002\\\u0005u\u0003cA\u0015\u0002X%\u0019\u0011\u0011\f\r\u0003\u001b\u001d+Go\u00142kK\u000e$H)\u0019;b\u0011\u0015iG\u00021\u00018\u0011\u0019\t\u0019\u0003\u0004a\u0001o\u00059\u0002/\u001e;PE*,7\r^'vYRL\u0007/\u0019:u'R\f'\u000f\u001e\u000b\t\u0003G\nI'a\u001b\u0002nA\u0019!-!\u001a\n\u0007\u0005\u001d4MA\u000fJ]&$\u0018.\u0019;f\u001bVdG/\u001b9beR,\u0006\u000f\\8bIJ+7/\u001e7u\u0011\u0015iW\u00021\u00018\u0011\u0019\t\u0019#\u0004a\u0001o!1a+\u0004a\u0001\u0003s\ta\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siB\u000b'\u000f\u001e\u000b\r\u00033\t\u0019(!\u001e\u0002x\u0005m\u0014q\u0010\u0005\u0006[:\u0001\ra\u000e\u0005\u0007\u0003Gq\u0001\u0019A\u001c\t\r\u0005ed\u00021\u0001y\u0003)\u0001\u0018M\u001d;Ok6\u0014WM\u001d\u0005\u0007\u0003{r\u0001\u0019A\u001c\u0002\u0011U\u0004Hn\\1e\u0013\u0012Dq!a\n\u000f\u0001\u0004\tI#\u0001\u000eqkR|%M[3di6+H\u000e^5qCJ$8i\\7qY\u0016$X\r\u0006\u0006\u0002\u0006\u0006-\u0015QRAH\u0003#\u00032AYAD\u0013\r\tIi\u0019\u0002\u001e\u0007>l\u0007\u000f\\3uK6+H\u000e^5qCJ$X\u000b\u001d7pC\u0012\u0014Vm];mi\")Qn\u0004a\u0001o!1\u00111E\bA\u0002]Ba!! \u0010\u0001\u00049\u0004bBA\b\u001f\u0001\u0007\u00111\u0013\t\u0005\u0003\u0017\t)*\u0003\u0003\u0002\u0018\u00065!aF\"p[BdW\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e\u0003)\u0019w\u000e]=PE*,7\r\u001e\u000b\r\u0003;\u000b\u0019+a*\u0002,\u0006=\u00161\u0017\t\u0004E\u0006}\u0015bAAQG\n\u00012i\u001c9z\u001f\nTWm\u0019;SKN,H\u000e\u001e\u0005\u0007\u0003K\u0003\u0002\u0019A\u001c\u0002\u0019M|WO]2f\u0005V\u001c7.\u001a;\t\r\u0005%\u0006\u00031\u00018\u0003%\u0019x.\u001e:dK.+\u0017\u0010\u0003\u0004\u0002.B\u0001\raN\u0001\u000bI\u0016\u001cHOQ;dW\u0016$\bBBAY!\u0001\u0007q'A\u0004eKN$8*Z=\t\u0013\u0005U\u0006\u0003%AA\u0002\u0005]\u0016a\u00028fo6+G/\u0019\t\u0005GE\fI$\u0001\u000bd_BLxJ\u00196fGR$C-\u001a4bk2$H%N\u000b\u0003\u0003{SC!a.\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GMC\u0002\u0002L\u0012\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty-!2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nd_BLxJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014H\u000f\u0006\u000b\u0002\u001e\u0006U\u0017q[Am\u00037\fi.!9\u0002d\u0006\u001d\u00181\u001e\u0005\u0007\u0003K\u0013\u0002\u0019A\u001c\t\r\u0005%&\u00031\u00018\u0011\u0019\tiK\u0005a\u0001o!1\u0011\u0011\u0017\nA\u0002]Ba!a8\u0013\u0001\u0004A\u0018\u0001\u00029beRDa!! \u0013\u0001\u00049\u0004BBAs%\u0001\u0007\u00010\u0001\u0005ge>l')\u001f;f\u0011\u0019\tIO\u0005a\u0001q\u00061Ao\u001c\"zi\u0016D\u0011\"!.\u0013!\u0003\u0005\r!a.\u0002;\r|\u0007/_(cU\u0016\u001cG/T;mi&\u0004\u0018M\u001d;%I\u00164\u0017-\u001e7uIe\nA\u0002Z3mKR,wJ\u00196fGR$b!!\u0007\u0002t\u0006U\b\"B7\u0015\u0001\u00049\u0004BBA\u0012)\u0001\u0007q'\u0001\u0007eK2,G/\u001a\"vG.,G\u000f\u0006\u0003\u0002\u001a\u0005m\b\"B7\u0016\u0001\u00049\u0014A\u00024s_6|5\u000fF\u00028\u0005\u0003AaAa\u0001\u0017\u0001\u00049\u0014\u0001\u00029bi\"\u0004")
public class FileProvider
implements Provider,
LazyLogging {
    private final String dir;
    private final better.files.File workDir;
    private final MapMetadataStore meta;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Option<String> normalizeDelimiter(Option<String> delimiter) {
        return Provider.normalizeDelimiter$(this, delimiter);
    }

    private Logger logger$lzycompute() {
        FileProvider fileProvider = this;
        synchronized (fileProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public better.files.File workDir() {
        return this.workDir;
    }

    private MapMetadataStore meta() {
        return this.meta;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.meta();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        List buckets = File$.MODULE$.apply(this.dir, (Seq)Nil$.MODULE$).list().map((Function1 & Serializable)f -> new Bucket(this.fromOs(f.name()), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()))).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing buckets: {}", (Object)buckets.map((Function1 & Serializable)x$1 -> x$1.name()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets);
    }

    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter, Option<Object> maxkeys) {
        Nil$ nil$;
        BoxedUnit boxedUnit;
        String prefixNoLeadingSlash = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString((String)prefix.getOrElse((Function0 & Serializable)() -> "")), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$2(BoxesRunTime.unboxToChar((Object)x$2))));
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(bucket).append("/").toString(), (Seq)Nil$.MODULE$);
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        String bucketFileString = this.fromOs(bucketFile.toString());
        Iterator bucketFiles = bucketFile.listRecursively(File.VisitOptions$.MODULE$.follow()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$3(this, bucketFileString, prefixNoLeadingSlash, f)));
        List files = bucketFiles.map((Function1 & Serializable)f -> {
            Content content;
            try (FileInputStream stream = new FileInputStream(f.toJava());){
                String md5 = DigestUtils.md5Hex((InputStream)stream);
                content = new Content(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(this.fromOs(f.toString())), bucketFileString.length() + 1)), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$6(BoxesRunTime.unboxToChar((Object)x$4)))), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()), md5, f.size(f.size$default$1()), "STANDARD");
            }
            return content;
        }).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing bucket contents: {}", (Object)files.map((Function1 & Serializable)x$5 -> x$5.key()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<String> option = this.normalizeDelimiter(delimiter);
        if (option instanceof Some) {
            Some some = (Some)option;
            String del = (String)some.value();
            nil$ = (List)((StrictOptimizedSeqOps)files.flatMap((Function1 & Serializable)f -> FileProvider.commonPrefix$1(f.key(), prefixNoLeadingSlash, del)).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ commonPrefixes = nil$;
        List filteredFiles = files.filterNot(arg_0 -> FileProvider.$anonfun$listBucket$9$adapted((List)commonPrefixes, arg_0));
        int count = BoxesRunTime.unboxToInt((Object)maxkeys.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE));
        List result = (List)filteredFiles.sortBy((Function1 & Serializable)x$6 -> x$6.key(), (Ordering)Ordering.String$.MODULE$);
        return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)result.take(count), result.size() > count);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        better.files.File bucket = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(name).toString(), (Seq)Nil$.MODULE$);
        Object object = !bucket.exists(bucket.exists$default$1()) ? bucket.createDirectory(bucket.createDirectory$default$1()) : BoxedUnit.UNIT;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("creating bucket {}", (Object)name);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, ObjectMetadata objectMetadata) {
        BoxedUnit boxedUnit;
        boolean x$2;
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        better.files.File file = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(bucket).append("/").append(key).toString(), (Seq)Nil$.MODULE$);
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        boolean x$1 = true;
        boolean x$3 = x$2 = file.createIfNotExists$default$1();
        boolean x$4 = true;
        Seq x$5 = file.createIfNotExists$default$3(x$3, true);
        Seq x$6 = file.createIfNotExists$default$4(x$3, true);
        file.createIfNotExists(x$3, true, x$5, x$6);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("writing file for s3://{}/{} to {}/{}/{}, bytes = {}", new Object[]{bucket, key, this.dir, bucket, key, BoxesRunTime.boxToInteger((int)data.length)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
        objectMetadata.setLastModified(DateTime.now().toDate());
        this.metadataStore().put(bucket, key, objectMetadata);
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        better.files.File file = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(bucket).append("/").append(key).toString(), (Seq)Nil$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("reading object for s3://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        if (!file.exists(file.exists$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        if (file.isDirectory(file.isDirectory$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
        return new GetObjectData(file.byteArray(), meta);
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key, ObjectMetadata metadata) {
        BoxedUnit boxedUnit;
        boolean x$2;
        String id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        better.files.File qual$1 = File$.MODULE$.apply(new StringBuilder(13).append(this.dir).append("/.mp/").append(bucket).append("/").append(key).append("/").append(id).append("/.keep").toString(), (Seq)Nil$.MODULE$);
        boolean x$1 = true;
        boolean x$3 = x$2 = qual$1.createIfNotExists$default$1();
        boolean x$4 = true;
        Seq x$5 = qual$1.createIfNotExists$default$3(x$3, true);
        Seq x$6 = qual$1.createIfNotExists$default$4(x$3, true);
        qual$1.createIfNotExists(x$3, true, x$5, x$6);
        this.metadataStore().put(bucket, key, metadata);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("starting multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new InitiateMultipartUploadResult(bucket, key, id);
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        better.files.File file = File$.MODULE$.apply(new StringBuilder(8).append(this.dir).append("/.mp/").append(bucket).append("/").append(key).append("/").append(uploadId).append("/").append(partNumber).toString(), (Seq)Nil$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("uploading multipart chunk {} for s3://{}/{}", new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        BoxedUnit boxedUnit;
        boolean x$2;
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        List files = request.parts().map((Function1 & Serializable)part -> File$.MODULE$.apply(new StringBuilder(8).append($this.dir).append("/.mp/").append(bucket).append("/").append(key).append("/").append(uploadId).append("/").append(part.partNumber()).toString(), (Seq)Nil$.MODULE$));
        List parts = files.map((Function1 & Serializable)f -> f.byteArray());
        better.files.File file = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(bucket).append("/").append(key).toString(), (Seq)Nil$.MODULE$);
        boolean x$1 = true;
        boolean x$3 = x$2 = file.createIfNotExists$default$1();
        boolean x$4 = true;
        Seq x$5 = file.createIfNotExists$default$3(x$3, true);
        Seq x$6 = file.createIfNotExists$default$4(x$3, true);
        file.createIfNotExists(x$3, true, x$5, x$6);
        byte[] data = (byte[])parts.fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), (Function2 & Serializable)(x$7, x$8) -> (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(x$7), x$8, (ClassTag)ClassTag$.MODULE$.Byte()));
        Iterator x$72 = Predef$.MODULE$.wrapByteArray(data).toIterator();
        Seq x$82 = file.writeBytes$default$2(x$72);
        file.writeBytes(x$72, x$82);
        better.files.File qual$1 = File$.MODULE$.apply(new StringBuilder(6).append(this.dir).append("/.mp/").append(bucket).append("/").append(key).toString(), (Seq)Nil$.MODULE$);
        boolean x$9 = qual$1.delete$default$1();
        Seq x$10 = qual$1.delete$default$2();
        qual$1.delete(x$9, x$10);
        String hash = file.md5();
        this.metadataStore().get(bucket, key).foreach((Function1 & Serializable)m -> {
            FileProvider.$anonfun$putObjectMultipartComplete$4(hash, m);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("completed multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CompleteMultipartUploadResult(bucket, key, hash);
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        BoxedUnit boxedUnit;
        boolean x$2;
        better.files.File sourceBucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(sourceBucket).toString(), (Seq)Nil$.MODULE$);
        better.files.File destBucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(destBucket).toString(), (Seq)Nil$.MODULE$);
        if (!sourceBucketFile.exists(sourceBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(sourceBucket);
        }
        if (!destBucketFile.exists(destBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(destBucket);
        }
        better.files.File sourceFile = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(sourceBucket).append("/").append(sourceKey).toString(), (Seq)Nil$.MODULE$);
        better.files.File destFile = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(destBucket).append("/").append(destKey).toString(), (Seq)Nil$.MODULE$);
        boolean x$1 = true;
        boolean x$3 = x$2 = destFile.createIfNotExists$default$1();
        boolean x$4 = true;
        Seq x$5 = destFile.createIfNotExists$default$3(x$3, true);
        Seq x$6 = destFile.createIfNotExists$default$4(x$3, true);
        destFile.createIfNotExists(x$3, true, x$5, x$6);
        better.files.File x$7 = destFile;
        boolean x$8 = true;
        Seq x$9 = sourceFile.copyTo$default$3(x$7, true);
        sourceFile.copyTo(x$7, true, x$9);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Copied s3://{}/{} to s3://{}/{}", new Object[]{sourceBucket, sourceKey, destBucket, destKey});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option sourceMeta = newMeta.orElse((Function0 & Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
        sourceMeta.foreach((Function1 & Serializable)meta -> {
            FileProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
            return BoxedUnit.UNIT;
        });
        return new CopyObjectResult(DateTime$.MODULE$.apply(sourceFile.lastModifiedTime(sourceFile.lastModifiedTime$default$1()).toEpochMilli()), destFile.md5());
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    @Override
    public CopyObjectResult copyObjectMultipart(String sourceBucket, String sourceKey, String destBucket, String destKey, int part, String uploadId, int fromByte, int toByte, Option<ObjectMetadata> newMeta) {
        byte[] data = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(this.getObject(sourceBucket, sourceKey).bytes()), fromByte, toByte + 1);
        this.putObjectMultipartPart(destBucket, destKey, part, uploadId, data);
        return new CopyObjectResult(DateTime$.MODULE$.now(), DigestUtils.md5Hex((byte[])data));
    }

    @Override
    public Option<ObjectMetadata> copyObjectMultipart$default$9() {
        return None$.MODULE$;
    }

    @Override
    public void deleteObject(String bucket, String key) {
        block3: {
            BoxedUnit boxedUnit;
            better.files.File file = File$.MODULE$.apply(new StringBuilder(2).append(this.dir).append("/").append(bucket).append("/").append(key).toString(), (Seq)Nil$.MODULE$);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("deleting object s://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!file.exists(file.exists$default$1())) {
                throw new NoSuchKeyException(bucket, key);
            }
            if (file.isDirectory(file.isDirectory$default$1())) break block3;
            file.delete(file.delete$default$1(), file.delete$default$2());
            this.metadataStore().delete(bucket, key);
        }
    }

    @Override
    public void deleteBucket(String bucket) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringBuilder(1).append(this.dir).append("/").append(bucket).toString(), (Seq)Nil$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("deleting bucket s://{}", (Object)bucket);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        bucketFile.delete(bucketFile.delete$default$1(), bucketFile.delete$default$2());
        this.metadataStore().remove(bucket);
    }

    private String fromOs(String path) {
        return path.replace(File.separatorChar, '/');
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)new StringBuilder(0).append(p).append(dir.substring(p.length(), n)).append(d).toString());
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$2(char x$2) {
        return x$2 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$4(char x$3) {
        return x$3 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$3(FileProvider $this, String bucketFileString$1, String prefixNoLeadingSlash$1, better.files.File f) {
        String fString = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString($this.fromOs(f.toString())), bucketFileString$1.length())), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$4(BoxesRunTime.unboxToChar((Object)x$3))));
        return fString.startsWith(prefixNoLeadingSlash$1) && !f.isDirectory(f.isDirectory$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$6(char x$4) {
        return x$4 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$10(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$putObjectMultipartComplete$4(String hash$1, ObjectMetadata m) {
        m.setContentMD5(hash$1);
        m.setLastModified(DateTime.now().toDate());
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(FileProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public FileProvider(String dir) {
        this.dir = dir;
        Provider.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.workDir = File$.MODULE$.apply(dir, (Seq)Nil$.MODULE$);
        Object object = !this.workDir().exists(this.workDir().exists$default$1()) ? this.workDir().createDirectories(this.workDir().createDirectories$default$1(), this.workDir().createDirectories$default$2()) : BoxedUnit.UNIT;
        this.meta = new MapMetadataStore(dir);
    }

    public static final /* synthetic */ Object $anonfun$listBucket$9$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$10(f, p))));
    }
}

