/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime;
import akka.http.scaladsl.model.DateTime$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.InMemoryProvider$BucketContents$;
import io.findify.s3mock.provider.InMemoryProvider$KeyContents$;
import io.findify.s3mock.provider.InMemoryProvider$MultipartChunk$;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.InMemoryMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapView;
import scala.collection.SeqOps;
import scala.collection.View;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map;
import scala.collection.mutable.SetOps;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.TreeSet;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0011ma\u0001\u00021b\u0001)Daa \u0001\u0005\u0002\u0005\u0005\u0001\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\t)\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\u0011y\u0005\u0001Q\u0001\n\u0005m\u0001\"\u0003B)\u0001\t\u0007I\u0011\u0002B*\u0011!\u0011)\n\u0001Q\u0001\n\tUcABA#\u0001\u0011\u000b9\u0005\u0003\u0006\u0002b!\u0011)\u001a!C\u0001\u0003GB!\"! \t\u0005#\u0005\u000b\u0011BA3\u0011)\ty\b\u0003BK\u0002\u0013\u0005\u0011\u0011\u0011\u0005\u000b\u0005[A!\u0011#Q\u0001\n\u0005\r\u0005BB@\t\t\u0003\u0011y\u0003C\u0005\u00022\"\t\t\u0011\"\u0001\u00036!I\u0011\u0011\u0018\u0005\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003#D\u0011\u0013!C\u0001\u0005wA\u0011\"a6\t\u0003\u0003%\t%!7\t\u0013\u0005%\b\"!A\u0005\u0002\u0005-\b\"CAz\u0011\u0005\u0005I\u0011\u0001B \u0011%\u0011\t\u0001CA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\u000e!\t\t\u0011\"\u0001\u0003D!I!\u0011\u0004\u0005\u0002\u0002\u0013\u0005#q\t\u0005\n\u0005?A\u0011\u0011!C!\u0005CA\u0011Ba\t\t\u0003\u0003%\tE!\n\t\u0013\t\u001d\u0002\"!A\u0005B\t-s!\u0003BL\u0001\u0005\u0005\t\u0012\u0002BM\r%\t)\u0005AA\u0001\u0012\u0013\u0011Y\n\u0003\u0004\u00007\u0011\u0005!\u0011\u0017\u0005\n\u0005GY\u0012\u0011!C#\u0005KA\u0011Ba-\u001c\u0003\u0003%\tI!.\t\u0013\tm6$!A\u0005\u0002\nufABAI\u0001\u0011\u000b\u0019\n\u0003\u0006\u0002\u0016\u0002\u0012)\u001a!C\u0001\u0003GB!\"a&!\u0005#\u0005\u000b\u0011BA3\u0011)\tI\n\tBK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003S\u0003#\u0011#Q\u0001\n\u0005u\u0005BB@!\t\u0003\tY\u000bC\u0005\u00022\u0002\n\t\u0011\"\u0001\u00024\"I\u0011\u0011\u0018\u0011\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003#\u0004\u0013\u0013!C\u0001\u0003'D\u0011\"a6!\u0003\u0003%\t%!7\t\u0013\u0005%\b%!A\u0005\u0002\u0005-\b\"CAzA\u0005\u0005I\u0011AA{\u0011%\u0011\t\u0001IA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\u000e\u0001\n\t\u0011\"\u0001\u0003\u0010!I!\u0011\u0004\u0011\u0002\u0002\u0013\u0005#1\u0004\u0005\n\u0005?\u0001\u0013\u0011!C!\u0005CA\u0011Ba\t!\u0003\u0003%\tE!\n\t\u0013\t\u001d\u0002%!A\u0005B\t%r!\u0003Bh\u0001\u0005\u0005\t\u0012\u0002Bi\r%\t\t\nAA\u0001\u0012\u0013\u0011\u0019\u000e\u0003\u0004\u0000g\u0011\u0005!q\u001b\u0005\n\u0005G\u0019\u0014\u0011!C#\u0005KA\u0011Ba-4\u0003\u0003%\tI!7\t\u0013\tm6'!A\u0005\u0002\n}gA\u0002B0\u0001\u0011\u0013\t\u0007\u0003\u0006\u0003ja\u0012)\u001a!C\u0001\u0003WD!Ba\u001b9\u0005#\u0005\u000b\u0011BAw\u0011)\tI\n\u000fBK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003SC$\u0011#Q\u0001\n\u0005u\u0005BB@9\t\u0003\u0011i\u0007C\u0004\u0003ta\"\tE!\u001e\t\u0013\u0005E\u0006(!A\u0005\u0002\tm\u0004\"CA]qE\u0005I\u0011\u0001BA\u0011%\t\t\u000eOI\u0001\n\u0003\t\u0019\u000eC\u0005\u0002Xb\n\t\u0011\"\u0011\u0002Z\"I\u0011\u0011\u001e\u001d\u0002\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003gD\u0014\u0011!C\u0001\u0005\u000bC\u0011B!\u00019\u0003\u0003%\tEa\u0001\t\u0013\t5\u0001(!A\u0005\u0002\t%\u0005\"\u0003B\rq\u0005\u0005I\u0011\tBG\u0011%\u0011y\u0002OA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003$a\n\t\u0011\"\u0011\u0003&!I!q\u0005\u001d\u0002\u0002\u0013\u0005#\u0011S\u0004\n\u0005O\u0004\u0011\u0011!E\u0005\u0005S4\u0011Ba\u0018\u0001\u0003\u0003EIAa;\t\r}dE\u0011\u0001Bx\u0011%\u0011\u0019\u0003TA\u0001\n\u000b\u0012)\u0003C\u0005\u000342\u000b\t\u0011\"!\u0003r\"I!1\u0018'\u0002\u0002\u0013\u0005%q\u001f\u0005\b\u0005\u007f\u0004A\u0011IB\u0001\u0011\u001d\u0019I\u0001\u0001C!\u0007\u0017Aqa!\u0007\u0001\t\u0003\u001aY\u0002C\u0004\u00048\u0001!\te!\u000f\t\u000f\rU\u0003\u0001\"\u0011\u0004X!91\u0011\u0011\u0001\u0005B\r\r\u0005\"CBY\u0001E\u0005I\u0011ABZ\u0011\u001d\u00199\f\u0001C!\u0007sCqa!2\u0001\t\u0003\u001a9\rC\u0004\u0004V\u0002!\tea6\t\u000f\r\u0015\b\u0001\"\u0011\u0004h\"91Q \u0001\u0005B\r}\b\"\u0003C\u0006\u0001E\u0005I\u0011ABZ\u0011\u001d!i\u0001\u0001C!\t\u001fAq\u0001\"\u0006\u0001\t\u0003\"9B\u0001\tJ]6+Wn\u001c:z!J|g/\u001b3fe*\u0011!mY\u0001\taJ|g/\u001b3fe*\u0011A-Z\u0001\u0007gNjwnY6\u000b\u0005\u0019<\u0017a\u00024j]\u0012Lg-\u001f\u0006\u0002Q\u0006\u0011\u0011n\\\u0002\u0001'\u0011\u00011.];\u0011\u00051|W\"A7\u000b\u00039\fQa]2bY\u0006L!\u0001]7\u0003\r\u0005s\u0017PU3g!\t\u00118/D\u0001b\u0013\t!\u0018M\u0001\u0005Qe>4\u0018\u000eZ3s!\t1X0D\u0001x\u0015\tA\u00180\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002{w\u0006AA/\u001f9fg\u00064WMC\u0001}\u0003\r\u0019w.\\\u0005\u0003}^\u00141\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\"!a\u0001\u0011\u0005I\u0004\u0011aB7e'R|'/Z\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\t\u0017\u0001C7fi\u0006$\u0017\r^1\n\t\u0005M\u0011Q\u0002\u0002\u0016\u0013:lU-\\8ss6+G/\u00193bi\u0006\u001cFo\u001c:f\u0003!iGm\u0015;pe\u0016\u0004\u0013a\u00042vG.,G\u000fR1uCN#xN]3\u0016\u0005\u0005m\u0001\u0003CA\u000f\u0003O\tY#!\u0011\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\r\t)#\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0015\u0003?\u0011q\u0001\u0016:jK6\u000b\u0007\u000f\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\rn\u001b\t\t\u0019DC\u0002\u00026%\fa\u0001\u0010:p_Rt\u0014bAA\u001d[\u00061\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000fn!\r\t\u0019\u0005C\u0007\u0002\u0001\tq!)^2lKR\u001cuN\u001c;f]R\u001c8C\u0002\u0005l\u0003\u0013\ny\u0005E\u0002m\u0003\u0017J1!!\u0014n\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0015\u0002\\9!\u00111KA,\u001d\u0011\t\t$!\u0016\n\u00039L1!!\u0017n\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0018\u0002`\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011\u0011L7\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003sj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003_\n\t(\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\u0011\t\u0019(!\u001e\u0002\t!$H\u000f\u001d\u0006\u0003\u0003o\nA!Y6lC&!\u00111PA5\u0005!!\u0015\r^3US6,\u0017!D2sK\u0006$\u0018n\u001c8US6,\u0007%\u0001\u0007lKf\u001c\u0018J\u001c\"vG.,G/\u0006\u0002\u0002\u0004BA\u0011QQAF\u0003W\ty)\u0004\u0002\u0002\b*!\u0011\u0011RA\u0012\u0003\u001diW\u000f^1cY\u0016LA!!$\u0002\b\n\u0019Q*\u00199\u0011\u0007\u0005\r\u0003EA\u0006LKf\u001cuN\u001c;f]R\u001c8C\u0002\u0011l\u0003\u0013\ny%\u0001\u000bmCN$Xj\u001c3jM&\u001c\u0017\r^5p]RKW.Z\u0001\u0016Y\u0006\u001cH/T8eS\u001aL7-\u0019;j_:$\u0016.\\3!\u0003\u0011!\u0017\r^1\u0016\u0005\u0005u\u0005#\u00027\u0002 \u0006\r\u0016bAAQ[\n)\u0011I\u001d:bsB\u0019A.!*\n\u0007\u0005\u001dVN\u0001\u0003CsR,\u0017!\u00023bi\u0006\u0004CCBAH\u0003[\u000by\u000bC\u0004\u0002\u0016\u0016\u0002\r!!\u001a\t\u000f\u0005eU\u00051\u0001\u0002\u001e\u0006!1m\u001c9z)\u0019\ty)!.\u00028\"I\u0011Q\u0013\u0014\u0011\u0002\u0003\u0007\u0011Q\r\u0005\n\u000333\u0003\u0013!a\u0001\u0003;\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002>*\"\u0011QMA`W\t\t\t\r\u0005\u0003\u0002D\u00065WBAAc\u0015\u0011\t9-!3\u0002\u0013Ut7\r[3dW\u0016$'bAAf[\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0017Q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003+TC!!(\u0002@\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006!A.\u00198h\u0015\t\t)/\u0001\u0003kCZ\f\u0017\u0002BA\u001f\u0003?\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!<\u0011\u00071\fy/C\u0002\u0002r6\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a>\u0002~B\u0019A.!?\n\u0007\u0005mXNA\u0002B]fD\u0011\"a@,\u0003\u0003\u0005\r!!<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0001\u0005\u0004\u0003\b\t%\u0011q_\u0007\u0003\u0003GIAAa\u0003\u0002$\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tBa\u0006\u0011\u00071\u0014\u0019\"C\u0002\u0003\u00165\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u00006\n\t\u00111\u0001\u0002x\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tYN!\b\t\u0013\u0005}h&!AA\u0002\u00055\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0012\t-\u0002\"CA\u0000c\u0005\u0005\t\u0019AA|\u00035YW-_:J]\n+8m[3uAQ1\u0011\u0011\tB\u0019\u0005gAq!!\u0019\u000e\u0001\u0004\t)\u0007C\u0004\u0002\u00005\u0001\r!a!\u0015\r\u0005\u0005#q\u0007B\u001d\u0011%\t\tG\u0004I\u0001\u0002\u0004\t)\u0007C\u0005\u0002\u00009\u0001\n\u00111\u0001\u0002\u0004V\u0011!Q\b\u0016\u0005\u0003\u0007\u000by\f\u0006\u0003\u0002x\n\u0005\u0003\"CA\u0000'\u0005\u0005\t\u0019AAw)\u0011\u0011\tB!\u0012\t\u0013\u0005}X#!AA\u0002\u0005]H\u0003BAn\u0005\u0013B\u0011\"a@\u0017\u0003\u0003\u0005\r!!<\u0015\t\tE!Q\n\u0005\n\u0003\u007fL\u0012\u0011!a\u0001\u0003o\f\u0001CY;dW\u0016$H)\u0019;b'R|'/\u001a\u0011\u0002%5,H\u000e^5qCJ$H+Z7q'R|'/Z\u000b\u0003\u0005+\u0002\u0002\"!\b\u0002(\u0005-\"q\u000b\t\u0007\u0003\u000b\u0013IF!\u0018\n\t\tm\u0013q\u0011\u0002\n'>\u0014H/\u001a3TKR\u00042!a\u00119\u00059iU\u000f\u001c;ja\u0006\u0014Ho\u00115v].\u001c\u0002\u0002O6\u0003d\u0005%\u0013q\n\t\u0007\u0003#\u0012)G!\u0018\n\t\t\u001d\u0014q\f\u0002\b\u001fJ$WM]3e\u0003\u0019\u0001\u0018M\u001d;O_\u00069\u0001/\u0019:u\u001d>\u0004CC\u0002B/\u0005_\u0012\t\bC\u0004\u0003ju\u0002\r!!<\t\u000f\u0005eU\b1\u0001\u0002\u001e\u000691m\\7qCJ,G\u0003BAw\u0005oBqA!\u001f?\u0001\u0004\u0011i&\u0001\u0003uQ\u0006$HC\u0002B/\u0005{\u0012y\bC\u0005\u0003j}\u0002\n\u00111\u0001\u0002n\"I\u0011\u0011T \u0011\u0002\u0003\u0007\u0011QT\u000b\u0003\u0005\u0007SC!!<\u0002@R!\u0011q\u001fBD\u0011%\ty\u0010RA\u0001\u0002\u0004\ti\u000f\u0006\u0003\u0003\u0012\t-\u0005\"CA\u0000\r\u0006\u0005\t\u0019AA|)\u0011\tYNa$\t\u0013\u0005}x)!AA\u0002\u00055H\u0003\u0002B\t\u0005'C\u0011\"a@K\u0003\u0003\u0005\r!a>\u0002'5,H\u000e^5qCJ$H+Z7q'R|'/\u001a\u0011\u0002\u001d\t+8m[3u\u0007>tG/\u001a8ugB\u0019\u00111I\u000e\u0014\u000bm\u0011iJ!+\u0011\u0015\t}%QUA3\u0003\u0007\u000b\t%\u0004\u0002\u0003\"*\u0019!1U7\u0002\u000fI,h\u000e^5nK&!!q\u0015BQ\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005W\u0013y+\u0004\u0002\u0003.*\u0019\u0001.a9\n\t\u0005u#Q\u0016\u000b\u0003\u00053\u000bQ!\u00199qYf$b!!\u0011\u00038\ne\u0006bBA1=\u0001\u0007\u0011Q\r\u0005\b\u0003\u007fr\u0002\u0019AAB\u0003\u001d)h.\u00199qYf$BAa0\u0003LB)AN!1\u0003F&\u0019!1Y7\u0003\r=\u0003H/[8o!\u001da'qYA3\u0003\u0007K1A!3n\u0005\u0019!V\u000f\u001d7fe!I!QZ\u0010\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\u0002\u0014aC&fs\u000e{g\u000e^3oiN\u00042!a\u00114'\u0015\u0019$Q\u001bBU!)\u0011yJ!*\u0002f\u0005u\u0015q\u0012\u000b\u0003\u0005#$b!a$\u0003\\\nu\u0007bBAKm\u0001\u0007\u0011Q\r\u0005\b\u000333\u0004\u0019AAO)\u0011\u0011\tO!:\u0011\u000b1\u0014\tMa9\u0011\u000f1\u00149-!\u001a\u0002\u001e\"I!QZ\u001c\u0002\u0002\u0003\u0007\u0011qR\u0001\u000f\u001bVdG/\u001b9beR\u001c\u0005.\u001e8l!\r\t\u0019\u0005T\n\u0006\u0019\n5(\u0011\u0016\t\u000b\u0005?\u0013)+!<\u0002\u001e\nuCC\u0001Bu)\u0019\u0011iFa=\u0003v\"9!\u0011N(A\u0002\u00055\bbBAM\u001f\u0002\u0007\u0011Q\u0014\u000b\u0005\u0005s\u0014i\u0010E\u0003m\u0005\u0003\u0014Y\u0010E\u0004m\u0005\u000f\fi/!(\t\u0013\t5\u0007+!AA\u0002\tu\u0013!D7fi\u0006$\u0017\r^1Ti>\u0014X-\u0006\u0002\u0004\u0004A!\u00111BB\u0003\u0013\u0011\u00199!!\u0004\u0003\u001b5+G/\u00193bi\u0006\u001cFo\u001c:f\u0003-a\u0017n\u001d;Ck\u000e\\W\r^:\u0016\u0005\r5\u0001\u0003BB\b\u0007+i!a!\u0005\u000b\u0007\rM1-\u0001\u0005sKN\u0004xN\\:f\u0013\u0011\u00199b!\u0005\u0003!1K7\u000f^!mY6K()^2lKR\u001c\u0018A\u00037jgR\u0014UoY6fiRQ1QDB\u0012\u0007O\u0019ic!\r\u0011\t\r=1qD\u0005\u0005\u0007C\u0019\tB\u0001\u0006MSN$()^2lKRDqa!\nT\u0001\u0004\tY#\u0001\u0004ck\u000e\\W\r\u001e\u0005\b\u0007S\u0019\u0006\u0019AB\u0016\u0003\u0019\u0001(/\u001a4jqB)AN!1\u0002,!91qF*A\u0002\r-\u0012!\u00033fY&l\u0017\u000e^3s\u0011\u001d\u0019\u0019d\u0015a\u0001\u0007k\tq!\\1yW\u0016L8\u000fE\u0003m\u0005\u0003\fi/\u0001\u0007de\u0016\fG/\u001a\"vG.,G\u000f\u0006\u0004\u0004<\r\u00053Q\t\t\u0005\u0007\u001f\u0019i$\u0003\u0003\u0004@\rE!\u0001D\"sK\u0006$XMQ;dW\u0016$\bbBB\")\u0002\u0007\u00111F\u0001\u0005]\u0006lW\rC\u0004\u0004HQ\u0003\ra!\u0013\u0002\u0019\t,8m[3u\u0007>tg-[4\u0011\t\r-3\u0011K\u0007\u0003\u0007\u001bR1aa\u0014d\u0003\u001d\u0011X-];fgRLAaa\u0015\u0004N\tI2I]3bi\u0016\u0014UoY6fi\u000e{gNZ5hkJ\fG/[8o\u0003%\u0001X\u000f^(cU\u0016\u001cG\u000f\u0006\u0006\u0004Z\r}3\u0011MB3\u0007O\u00022\u0001\\B.\u0013\r\u0019i&\u001c\u0002\u0005+:LG\u000fC\u0004\u0004&U\u0003\r!a\u000b\t\u000f\r\rT\u000b1\u0001\u0002,\u0005\u00191.Z=\t\u000f\u0005eU\u000b1\u0001\u0002\u001e\"91\u0011N+A\u0002\r-\u0014AD8cU\u0016\u001cG/T3uC\u0012\fG/\u0019\t\u0005\u0007[\u001ai(\u0004\u0002\u0004p)!\u00111NB9\u0015\u0011\u0019\u0019h!\u001e\u0002\u0005M\u001c$\u0002BB<\u0007s\n\u0001b]3sm&\u001cWm\u001d\u0006\u0004\u0007wZ\u0018!C1nCj|g.Y<t\u0013\u0011\u0019yha\u001c\u0003\u001d=\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\u0006\u00192m\u001c9z\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siR!2QQBF\u0007\u001f\u001b\u0019ja&\u0004\u001c\u000e}51UBT\u0007W\u0003Baa\u0004\u0004\b&!1\u0011RB\t\u0005A\u0019u\u000e]=PE*,7\r\u001e*fgVdG\u000fC\u0004\u0004\u000eZ\u0003\r!a\u000b\u0002\u0019M|WO]2f\u0005V\u001c7.\u001a;\t\u000f\rEe\u000b1\u0001\u0002,\u0005I1o\\;sG\u0016\\U-\u001f\u0005\b\u0007+3\u0006\u0019AA\u0016\u0003)!Wm\u001d;Ck\u000e\\W\r\u001e\u0005\b\u000733\u0006\u0019AA\u0016\u0003\u001d!Wm\u001d;LKfDqa!(W\u0001\u0004\ti/\u0001\u0003qCJ$\bbBBQ-\u0002\u0007\u00111F\u0001\tkBdw.\u00193JI\"91Q\u0015,A\u0002\u00055\u0018\u0001\u00034s_6\u0014\u0015\u0010^3\t\u000f\r%f\u000b1\u0001\u0002n\u00061Ao\u001c\"zi\u0016D\u0011b!,W!\u0003\u0005\raa,\u0002\u000f9,w/T3uCB)AN!1\u0004l\u0005i2m\u001c9z\u001f\nTWm\u0019;Nk2$\u0018\u000e]1si\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u00046*\"1qVA`\u0003%9W\r^(cU\u0016\u001cG\u000f\u0006\u0004\u0004<\u000e\u000571\u0019\t\u0004e\u000eu\u0016bAB`C\niq)\u001a;PE*,7\r\u001e#bi\u0006Dqa!\nY\u0001\u0004\tY\u0003C\u0004\u0004da\u0003\r!a\u000b\u0002/A,Ho\u00142kK\u000e$X*\u001e7uSB\f'\u000f^*uCJ$H\u0003CBe\u0007\u001f\u001c\tna5\u0011\t\r=11Z\u0005\u0005\u0007\u001b\u001c\tBA\u000fJ]&$\u0018.\u0019;f\u001bVdG/\u001b9beR,\u0006\u000f\\8bIJ+7/\u001e7u\u0011\u001d\u0019)#\u0017a\u0001\u0003WAqaa\u0019Z\u0001\u0004\tY\u0003C\u0004\u0002\u0010e\u0003\raa\u001b\u0002-A,Ho\u00142kK\u000e$X*\u001e7uSB\f'\u000f\u001e)beR$Bb!\u0017\u0004Z\u000em7Q\\Bq\u0007GDqa!\n[\u0001\u0004\tY\u0003C\u0004\u0004di\u0003\r!a\u000b\t\u000f\r}'\f1\u0001\u0002n\u0006Q\u0001/\u0019:u\u001dVl'-\u001a:\t\u000f\r\u0005&\f1\u0001\u0002,!9\u0011\u0011\u0014.A\u0002\u0005u\u0015A\u00079vi>\u0013'.Z2u\u001bVdG/\u001b9beR\u001cu.\u001c9mKR,GCCBu\u0007_\u001c\tpa=\u0004vB!1qBBv\u0013\u0011\u0019io!\u0005\u0003;\r{W\u000e\u001d7fi\u0016lU\u000f\u001c;ja\u0006\u0014H/\u00169m_\u0006$'+Z:vYRDqa!\n\\\u0001\u0004\tY\u0003C\u0004\u0004dm\u0003\r!a\u000b\t\u000f\r\u00056\f1\u0001\u0002,!91qJ.A\u0002\r]\b\u0003BB&\u0007sLAaa?\u0004N\t92i\\7qY\u0016$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\rZ\u0001\u000bG>\u0004\u0018p\u00142kK\u000e$H\u0003DBC\t\u0003!\u0019\u0001\"\u0002\u0005\b\u0011%\u0001bBBG9\u0002\u0007\u00111\u0006\u0005\b\u0007#c\u0006\u0019AA\u0016\u0011\u001d\u0019)\n\u0018a\u0001\u0003WAqa!']\u0001\u0004\tY\u0003C\u0005\u0004.r\u0003\n\u00111\u0001\u00040\u0006!2m\u001c9z\u001f\nTWm\u0019;%I\u00164\u0017-\u001e7uIU\nA\u0002Z3mKR,wJ\u00196fGR$ba!\u0017\u0005\u0012\u0011M\u0001bBB\u0013=\u0002\u0007\u00111\u0006\u0005\b\u0007Gr\u0006\u0019AA\u0016\u00031!W\r\\3uK\n+8m[3u)\u0011\u0019I\u0006\"\u0007\t\u000f\r\u0015r\f1\u0001\u0002,\u0001")
public class InMemoryProvider
implements Provider,
LazyLogging {
    private volatile InMemoryProvider$BucketContents$ BucketContents$module;
    private volatile InMemoryProvider$KeyContents$ KeyContents$module;
    private volatile InMemoryProvider$MultipartChunk$ MultipartChunk$module;
    private final InMemoryMetadataStore mdStore;
    private final TrieMap<String, BucketContents> bucketDataStore;
    private final TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Option<String> normalizeDelimiter(Option<String> delimiter) {
        return Provider.normalizeDelimiter$(this, delimiter);
    }

    private InMemoryProvider$BucketContents$ BucketContents() {
        if (this.BucketContents$module == null) {
            this.BucketContents$lzycompute$1();
        }
        return this.BucketContents$module;
    }

    private InMemoryProvider$KeyContents$ KeyContents() {
        if (this.KeyContents$module == null) {
            this.KeyContents$lzycompute$1();
        }
        return this.KeyContents$module;
    }

    private InMemoryProvider$MultipartChunk$ MultipartChunk() {
        if (this.MultipartChunk$module == null) {
            this.MultipartChunk$lzycompute$1();
        }
        return this.MultipartChunk$module;
    }

    private Logger logger$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private InMemoryMetadataStore mdStore() {
        return this.mdStore;
    }

    private TrieMap<String, BucketContents> bucketDataStore() {
        return this.bucketDataStore;
    }

    private TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore() {
        return this.multipartTempStore;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.mdStore();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        Iterable buckets = (Iterable)this.bucketDataStore().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            BucketContents data = (BucketContents)tuple2._2();
            Bucket bucket = new Bucket(name, data.creationTime());
            return bucket;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing buckets: {}", buckets.map((Function1 & Serializable)x$1 -> x$1.name()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter, Option<Object> maxkeys) {
        String prefix2 = (String)prefix.getOrElse((Function0 & Serializable)() -> "");
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Nil$ nil$;
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            MapView matchingKeys = bucketContent.keysInBucket().filterKeys((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(prefix2)));
            View matchResults = (View)matchingKeys.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                KeyContents content = (KeyContents)tuple2._2();
                Content content2 = new Content(name, content.lastModificationTime(), DigestUtils.md5Hex((byte[])content.data()), content.data().length, "STANDARD");
                return content2;
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("listing bucket contents: {}", matchResults.map((Function1 & Serializable)x$3 -> x$3.key()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<String> option2 = this.normalizeDelimiter(delimiter);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String del = (String)some2.value();
                nil$ = (List)((SeqOps)((IterableOnceOps)matchResults.flatMap((Function1 & Serializable)f -> InMemoryProvider.commonPrefix$1(f.key(), prefix2, del))).toList().sorted((Ordering)Ordering.String$.MODULE$)).distinct();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                nil$ = Nil$.MODULE$;
            }
            Nil$ commonPrefixes = nil$;
            List filteredFiles = ((IterableOnceOps)matchResults.filterNot(arg_0 -> InMemoryProvider.$anonfun$listBucket$6$adapted((List)commonPrefixes, arg_0))).toList();
            int count = BoxesRunTime.unboxToInt((Object)maxkeys.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE));
            List result = (List)filteredFiles.sortBy((Function1 & Serializable)x$4 -> x$4.key(), (Ordering)Ordering.String$.MODULE$);
            return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)result.take(count).take(count), result.size() > count);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        this.bucketDataStore().putIfAbsent((Object)name, (Object)new BucketContents(this, DateTime$.MODULE$.now(), (Map<String, KeyContents>)new TrieMap()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("creating bucket {}", (Object)name);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, ObjectMetadata objectMetadata) {
        BucketContents bucketContent;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            bucketContent = (BucketContents)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("putting object for s3://{}/{}, bytes = {}", new Object[]{bucket, key, BoxesRunTime.boxToInteger((int)data.length)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), data));
        objectMetadata.setLastModified(org.joda.time.DateTime.now().toDate());
        this.metadataStore().put(bucket, key, objectMetadata);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public CopyObjectResult copyObjectMultipart(String sourceBucket, String sourceKey, String destBucket, String destKey, int part, String uploadId, int fromByte, int toByte, Option<ObjectMetadata> newMeta) {
        byte[] data = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(this.getObject(sourceBucket, sourceKey).bytes()), fromByte, toByte + 1);
        this.putObjectMultipartPart(destBucket, destKey, part, uploadId, data);
        return new CopyObjectResult(DateTime$.MODULE$.now(), DigestUtils.md5Hex((byte[])data));
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        GetObjectData getObjectData;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            KeyContents keyContent;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                Some some2 = (Some)option2;
                keyContent = (KeyContents)some2.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("reading object for s://{}/{}", (Object[])new String[]{bucket, key});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new NoSuchKeyException(bucket, key);
                }
                throw new MatchError((Object)option2);
            }
            Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
            getObjectData = new GetObjectData(keyContent.data(), meta);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        GetObjectData getObjectData2 = getObjectData;
        return getObjectData2;
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key, ObjectMetadata metadata) {
        String id;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
            this.multipartTempStore().putIfAbsent((Object)id, (Object)new TreeSet(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
            this.metadataStore().put(bucket, key, metadata);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("starting multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult(bucket, key, id);
        return initiateMultipartUploadResult;
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("uploading multipart chunk {} for s3://{}/{}", new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        ((SetOps)this.multipartTempStore().getOrElseUpdate((Object)uploadId, (Function0 & Serializable)() -> new TreeSet(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())))).add((Object)new MultipartChunk(this, partNumber, data));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        byte[] completeBytes;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            completeBytes = (byte[])((IterableOnceOps)((IterableOnceOps)this.multipartTempStore().apply((Object)uploadId)).toSeq().map((Function1 & Serializable)x$5 -> x$5.data())).fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), (Function2 & Serializable)(x$6, x$7) -> (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(x$6), x$7, (ClassTag)ClassTag$.MODULE$.Byte()));
            bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), completeBytes));
            this.multipartTempStore().remove((Object)uploadId);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("completed multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        String hash = DigestUtils.md5Hex((byte[])completeBytes);
        this.metadataStore().get(bucket, key).foreach((Function1 & Serializable)m -> {
            InMemoryProvider.$anonfun$putObjectMultipartComplete$3(hash, m);
            return BoxedUnit.UNIT;
        });
        CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult(bucket, key, hash);
        return completeMultipartUploadResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        Tuple2 tuple2 = new Tuple2((Object)this.bucketDataStore().get((Object)sourceBucket), (Object)this.bucketDataStore().get((Object)destBucket));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                BucketContents srcBucketContent = (BucketContents)some.value();
                if (option2 instanceof Some) {
                    DateTime destFileModTime;
                    KeyContents srcKeyContent;
                    Some some2 = (Some)option2;
                    BucketContents dstBucketContent = (BucketContents)some2.value();
                    Option option3 = srcBucketContent.keysInBucket().get((Object)sourceKey);
                    if (option3 instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some3 = (Some)option3;
                        srcKeyContent = (KeyContents)some3.value();
                        destFileModTime = DateTime$.MODULE$.now();
                        dstBucketContent.keysInBucket().put((Object)destKey, (Object)new KeyContents(this, destFileModTime, (byte[])srcKeyContent.data().clone()));
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Copied s3://{}/{} to s3://{}/{}", new Object[]{sourceBucket, sourceKey, destBucket, destKey});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                        throw new NoSuchKeyException(sourceBucket, sourceKey);
                    }
                    Option sourceMeta = newMeta.orElse((Function0 & Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
                    sourceMeta.foreach((Function1 & Serializable)meta -> {
                        InMemoryProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
                        return BoxedUnit.UNIT;
                    });
                    CopyObjectResult copyObjectResult = new CopyObjectResult(destFileModTime, DigestUtils.md5Hex((byte[])srcKeyContent.data()));
                    return copyObjectResult;
                }
            }
        }
        if (tuple2 == null) throw new NoSuchBucketException(destBucket);
        Option option = (Option)tuple2._1();
        if (!None$.MODULE$.equals(option)) throw new NoSuchBucketException(destBucket);
        throw new NoSuchBucketException(sourceBucket);
    }

    @Override
    public Option<ObjectMetadata> copyObjectMultipart$default$9() {
        return None$.MODULE$;
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteObject(String bucket, String key) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("deleting object s://{}/{}", (Object[])new String[]{bucket, key});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bucketContent.keysInBucket().remove((Object)key);
                this.metadataStore().delete(bucket, key);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                Option option3 = bucketContent.keysInBucket().keys().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(key)));
                if (option3 instanceof Some) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("recursive delete by prefix is not supported by S3");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("key does not exist");
                        boxedUnit = BoxedUnit.UNIT;
                        throw new NoSuchKeyException(bucket, key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NoSuchKeyException(bucket, key);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new NoSuchBucketException(bucket);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void deleteBucket(String bucket) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("deleting bucket s://{}", (Object)bucket);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        this.bucketDataStore().remove((Object)bucket);
        this.metadataStore().remove(bucket);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void BucketContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.BucketContents$module == null) {
                this.BucketContents$module = new InMemoryProvider$BucketContents$(this);
            }
        }
    }

    private final void KeyContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.KeyContents$module == null) {
                this.KeyContents$module = new InMemoryProvider$KeyContents$(this);
            }
        }
    }

    private final void MultipartChunk$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.MultipartChunk$module == null) {
                this.MultipartChunk$module = new InMemoryProvider$MultipartChunk$(this);
            }
        }
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)new StringBuilder(0).append(p).append(dir.substring(p.length(), n)).append(d).toString());
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$7(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$putObjectMultipartComplete$3(String hash$1, ObjectMetadata m) {
        m.setContentMD5(hash$1);
        m.setLastModified(org.joda.time.DateTime.now().toDate());
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(InMemoryProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public InMemoryProvider() {
        Provider.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.mdStore = new InMemoryMetadataStore();
        this.bucketDataStore = new TrieMap();
        this.multipartTempStore = new TrieMap();
    }

    public static final /* synthetic */ Object $anonfun$listBucket$6$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)InMemoryProvider.$anonfun$listBucket$7(f, p))));
    }

    public class BucketContents
    implements Product,
    Serializable {
        private final DateTime creationTime;
        private final Map<String, KeyContents> keysInBucket;
        public final /* synthetic */ InMemoryProvider $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DateTime creationTime() {
            return this.creationTime;
        }

        public Map<String, KeyContents> keysInBucket() {
            return this.keysInBucket;
        }

        public BucketContents copy(DateTime creationTime, Map<String, KeyContents> keysInBucket) {
            return new BucketContents(this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer(), creationTime, keysInBucket);
        }

        public DateTime copy$default$1() {
            return this.creationTime();
        }

        public Map<String, KeyContents> copy$default$2() {
            return this.keysInBucket();
        }

        public String productPrefix() {
            return "BucketContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.creationTime();
                    break;
                }
                case 1: {
                    object = this.keysInBucket();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BucketContents;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "creationTime";
                    break;
                }
                case 1: {
                    string = "keysInBucket";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BucketContents)) return false;
            if (((BucketContents)object).io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BucketContents bucketContents = (BucketContents)x$1;
            DateTime dateTime = this.creationTime();
            DateTime dateTime2 = bucketContents.creationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            Map<String, KeyContents> map = this.keysInBucket();
            Map<String, KeyContents> map2 = bucketContents.keysInBucket();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!bucketContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() {
            return this.$outer;
        }

        public BucketContents(InMemoryProvider $outer, DateTime creationTime, Map<String, KeyContents> keysInBucket) {
            this.creationTime = creationTime;
            this.keysInBucket = keysInBucket;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class KeyContents
    implements Product,
    Serializable {
        private final DateTime lastModificationTime;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DateTime lastModificationTime() {
            return this.lastModificationTime;
        }

        public byte[] data() {
            return this.data;
        }

        public KeyContents copy(DateTime lastModificationTime, byte[] data) {
            return new KeyContents(this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer(), lastModificationTime, data);
        }

        public DateTime copy$default$1() {
            return this.lastModificationTime();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "KeyContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.lastModificationTime();
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyContents;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "lastModificationTime";
                    break;
                }
                case 1: {
                    string = "data";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KeyContents)) return false;
            if (((KeyContents)object).io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyContents keyContents = (KeyContents)x$1;
            DateTime dateTime = this.lastModificationTime();
            DateTime dateTime2 = keyContents.lastModificationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (this.data() != keyContents.data()) return false;
            if (!keyContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() {
            return this.$outer;
        }

        public KeyContents(InMemoryProvider $outer, DateTime lastModificationTime, byte[] data) {
            this.lastModificationTime = lastModificationTime;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class MultipartChunk
    implements Ordered<MultipartChunk>,
    Product,
    Serializable {
        private final int partNo;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public int partNo() {
            return this.partNo;
        }

        public byte[] data() {
            return this.data;
        }

        public int compare(MultipartChunk that) {
            return Predef$.MODULE$.int2Integer(this.partNo()).compareTo(Predef$.MODULE$.int2Integer(that.partNo()));
        }

        public MultipartChunk copy(int partNo, byte[] data) {
            return new MultipartChunk(this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer(), partNo, data);
        }

        public int copy$default$1() {
            return this.partNo();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "MultipartChunk";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.partNo());
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MultipartChunk;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "partNo";
                    break;
                }
                case 1: {
                    string = "data";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.partNo());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MultipartChunk)) return false;
            if (((MultipartChunk)object).io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MultipartChunk multipartChunk = (MultipartChunk)x$1;
            if (this.partNo() != multipartChunk.partNo()) return false;
            if (this.data() != multipartChunk.data()) return false;
            if (!multipartChunk.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() {
            return this.$outer;
        }

        public MultipartChunk(InMemoryProvider $outer, int partNo, byte[] data) {
            this.partNo = partNo;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

