/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.DummyCoercing;
import io.fria.lilo.IntrospectionFetchingMode;
import io.fria.lilo.SchemaMerger;
import io.fria.lilo.SchemaSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiloContext {
    private static final Set<String> PREDEFINED_SCALARS = Set.of("Boolean", "Float", "Int", "ID", "String");
    private static final TypeResolver INTERFACE_TYPE_RESOLVER = env -> null;
    private static final TypeResolver UNION_TYPE_RESOLVER = env -> {
        Map result = (Map)env.getObject();
        if (!result.containsKey("__typename")) {
            throw new IllegalArgumentException("Please provide __typename for union types");
        }
        return env.getSchema().getObjectType(result.get("__typename").toString());
    };
    private final DataFetcherExceptionHandler dataFetcherExceptionHandler;
    private final IntrospectionFetchingMode introspectionFetchingMode;
    private final boolean retrySchemaLoad;
    private Map<String, SchemaSource> sourceMap;
    private GraphQL graphQL;
    private boolean schemasAreNotLoaded = true;

    LiloContext(@NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull IntrospectionFetchingMode introspectionFetchingMode, boolean retrySchemaLoad, SchemaSource ... schemaSources) {
        this.dataFetcherExceptionHandler = Objects.requireNonNull(dataFetcherExceptionHandler);
        this.introspectionFetchingMode = Objects.requireNonNull(introspectionFetchingMode);
        this.retrySchemaLoad = retrySchemaLoad;
        this.sourceMap = LiloContext.toSourceMap(Arrays.stream(schemaSources));
    }

    @NotNull
    private static RuntimeWiring finalizeWiring(@NotNull TypeDefinitionRegistry typeRegistry, @NotNull RuntimeWiring.Builder runtimeWiringBuilder) {
        DummyCoercing dummyCoercing = new DummyCoercing();
        typeRegistry.scalars().values().stream().filter(sd -> !PREDEFINED_SCALARS.contains(sd.getName())).forEach(sd -> runtimeWiringBuilder.scalar(GraphQLScalarType.newScalar().name(sd.getName()).coercing((Coercing)dummyCoercing).build()));
        typeRegistry.types().values().stream().filter(t -> t instanceof InterfaceTypeDefinition || t instanceof UnionTypeDefinition).forEach(t -> {
            if (t instanceof InterfaceTypeDefinition) {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(INTERFACE_TYPE_RESOLVER));
            } else {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(UNION_TYPE_RESOLVER));
            }
        });
        return runtimeWiringBuilder.build();
    }

    @NotNull
    private static Map<String, SchemaSource> toSourceMap(@NotNull Stream<SchemaSource> schemaSourcesStream) {
        return schemaSourcesStream.collect(Collectors.toMap(SchemaSource::getName, ss -> ss));
    }

    @NotNull
    public DataFetcherExceptionHandler getDataFetcherExceptionHandler() {
        return this.dataFetcherExceptionHandler;
    }

    @NotNull
    public GraphQL getGraphQL() {
        return this.getGraphQL(null);
    }

    @NotNull
    public CompletableFuture<GraphQL> getGraphQLAsync() {
        return this.getGraphQLAsync(null);
    }

    @NotNull
    public IntrospectionFetchingMode getIntrospectionFetchingMode() {
        return this.introspectionFetchingMode;
    }

    @NotNull
    public Map<String, SchemaSource> getSchemaSources() {
        return Map.copyOf(this.sourceMap);
    }

    public void invalidate(@NotNull String schemaName) {
        if (!this.sourceMap.containsKey(Objects.requireNonNull(schemaName))) {
            return;
        }
        SchemaSource schemaSource = this.sourceMap.get(schemaName);
        schemaSource.invalidate();
        this.schemasAreNotLoaded = true;
    }

    public void invalidateAll() {
        this.sourceMap.values().forEach(SchemaSource::invalidate);
        this.schemasAreNotLoaded = true;
    }

    @NotNull
    public CompletableFuture<GraphQL> reloadGraphQL(@Nullable Object localContext) {
        return this.loadSources(localContext).thenApply(sourceMapClone -> {
            this.graphQL = this.createGraphQL((List<SchemaSource>)sourceMapClone);
            this.sourceMap = LiloContext.toSourceMap(sourceMapClone.stream());
            return this.graphQL;
        });
    }

    @NotNull
    GraphQL getGraphQL(@Nullable ExecutionInput executionInput) {
        try {
            return this.getGraphQLAsync(executionInput).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    CompletableFuture<GraphQL> getGraphQLAsync(@Nullable ExecutionInput executionInput) {
        if (this.schemasAreNotLoaded()) {
            return this.reloadGraphQL(executionInput == null ? null : executionInput.getLocalContext());
        }
        return CompletableFuture.supplyAsync(() -> this.graphQL);
    }

    @NotNull
    private GraphQL createGraphQL(@NotNull List<SchemaSource> schemaSourceList) {
        TypeDefinitionRegistry combinedRegistry = new TypeDefinitionRegistry();
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        SchemaMerger.mergeSchemas(schemaSourceList, combinedRegistry, runtimeWiringBuilder);
        RuntimeWiring runtimeWiring = LiloContext.finalizeWiring(combinedRegistry, runtimeWiringBuilder);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(combinedRegistry, runtimeWiring);
        return GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).defaultDataFetcherExceptionHandler(this.dataFetcherExceptionHandler).build();
    }

    @NotNull
    private CompletableFuture<List<SchemaSource>> loadSources(@Nullable Object localContext) {
        CompletionStage<List<SchemaSource>> combined = CompletableFuture.supplyAsync(ArrayList::new);
        List futures = this.sourceMap.values().stream().map(ss -> {
            if (ss.isSchemaNotLoaded()) {
                return ss.loadSchema(this, localContext);
            }
            return CompletableFuture.supplyAsync(() -> ss);
        }).collect(Collectors.toList());
        for (CompletableFuture future : futures) {
            combined = combined.thenCombine((CompletionStage)future, (combinedSchemaSources, baseSchemaSource) -> {
                combinedSchemaSources.add(baseSchemaSource);
                return combinedSchemaSources;
            });
        }
        return combined;
    }

    private boolean schemasAreNotLoaded() {
        if (this.schemasAreNotLoaded) {
            int sourceCount;
            Collection<SchemaSource> sources = this.sourceMap.values();
            long notLoadedCount = this.sourceMap.values().stream().filter(SchemaSource::isSchemaNotLoaded).count();
            this.schemasAreNotLoaded = notLoadedCount == (long)(sourceCount = sources.size()) ? true : (notLoadedCount == 0L ? false : this.retrySchemaLoad);
        }
        return this.schemasAreNotLoaded;
    }
}

