/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Ga$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dsAB\u0007\u000f\u0011\u0003qAC\u0002\u0004\u0017\u001d!\u0005ab\u0006\u0005\u0006=\u0005!\t\u0001\t\u0005\u0006C\u0005!\tA\t\u0004\u0006-9\u0001\u0001\u0003\n\u0005\t_\u0011\u0011\t\u0011)A\u0005a!A\u0001\b\u0002B\u0001B\u0003%\u0011\b\u0003\u0005B\t\t\u0005\t\u0015!\u0003C\u0011\u0015qB\u0001\"\u0001K\u0011\u0019qE\u0001\"\u0001\u000f\u001f\")A\f\u0002C\t;\")A\u000f\u0002C\u0005k\"1q\u000f\u0002C\t!a\faAU;o]\u0016\u0014(BA\b\u0011\u0003\r\t\u0007\u000f\u001d\u0006\u0003#I\tqaZ1uY&twMC\u0001\u0014\u0003\tIw\u000e\u0005\u0002\u0016\u00035\taB\u0001\u0004Sk:tWM]\n\u0003\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003Q\tQ!\u00199qYf$RaIA\"\u0003\u000b\u0002\"!\u0006\u0003\u0014\u0007\u0011AR\u0005\u0005\u0002'[5\tqE\u0003\u0002)S\u0005a1oY1mC2|wmZ5oO*\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!AL\u0014\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0006C\u000e$xN\u001d\u0006\u0002k\u0005!\u0011m[6b\u0013\t9$GA\u0006BGR|'oU=ti\u0016l\u0017!B2m_\u000e\\\u0007C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0005y\u0002\u0012aB2p[6|gn]\u0005\u0003\u0001n\u0012Qa\u00117pG.\fQbY8oM&<WO]1uS>t\u0007CA\"I\u001b\u0005!%BA#G\u0003\u0019\u0019wN\u001c4jO*\u0011q\tE\u0001\u0005G>\u0014X-\u0003\u0002J\t\n!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:$BaI&M\u001b\")q\u0006\u0003a\u0001a!)\u0001\b\u0003a\u0001s!)\u0011\t\u0003a\u0001\u0005\u0006\u0019!/\u001e8\u0015\u0005A\u001b\u0006CA\u000bR\u0013\t\u0011fBA\u0005Sk:\u0014Vm];mi\")A+\u0003a\u0001+\u000692/\u001a7fGR,GmU5nk2\fG/[8o\u00072\f7o\u001d\t\u0003-fs!!F,\n\u0005as\u0011a\u00029bG.\fw-Z\u0005\u00035n\u0013qcU3mK\u000e$X\rZ*j[Vd\u0017\r^5p]\u000ec\u0017m]:\u000b\u0005as\u0011A\u00048foN#\u0018\r^:F]\u001eLg.\u001a\u000b\u0004=\u0012d\u0007CA0c\u001b\u0005\u0001'BA1G\u0003\u0015\u0019H/\u0019;t\u0013\t\u0019\u0007MA\u0006Ti\u0006$8/\u00128hS:,\u0007\"B3\u000b\u0001\u00041\u0017\u0001E:j[Vd\u0017\r^5p]B\u000b'/Y7t!\t9'.D\u0001i\u0015\tIg)\u0001\u0005tG\u0016t\u0017M]5p\u0013\tY\u0007N\u0001\tTS6,H.\u0019;j_:\u0004\u0016M]1ng\")QN\u0003a\u0001]\u0006Q!/\u001e8NKN\u001c\u0018mZ3\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0004\u0017AB<sSR,'/\u0003\u0002ta\nQ!+\u001e8NKN\u001c\u0018mZ3\u0002\tI,h\u000e\r\u000b\u0003!ZDQ\u0001V\u0006A\u0002U\u000bQa\u001d;beR$r!_A\u000b\u0003/\t9\u0004M\u0002{\u0003\u0007\u00012a_?\u0000\u001b\u0005a(B\u0001\u001f\u001b\u0013\tqHPA\u0002Uef\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003\u0019\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00132#\u0011\tI!a\u0004\u0011\u0007e\tY!C\u0002\u0002\u000ei\u0011qAT8uQ&tw\rE\u0002\u001a\u0003#I1!a\u0005\u001b\u0005\r\te.\u001f\u0005\u0006K2\u0001\rA\u001a\u0005\b\u00033a\u0001\u0019AA\u000e\u0003%\u00198-\u001a8be&|7\u000f\u0005\u0004\u0002\u001e\u0005-\u0012\u0011\u0007\b\u0005\u0003?\tIC\u0004\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)cH\u0001\u0007yI|w\u000e\u001e \n\u0003mI!\u0001\u0017\u000e\n\t\u00055\u0012q\u0006\u0002\u0005\u0019&\u001cHO\u0003\u0002Y5A\u0019q-a\r\n\u0007\u0005U\u0002N\u0001\u0005TG\u0016t\u0017M]5p\u0011\u001d\tI\u0004\u0004a\u0001\u0003w\tabY8sK\u000e{W\u000e]8oK:$8\u000f\u0005\u0003\u0002>\u0005}R\"\u0001$\n\u0007\u0005\u0005cI\u0001\bD_J,7i\\7q_:,g\u000e^:\t\u000b=\u001a\u0001\u0019\u0001\u0019\t\u000b\u0005\u001b\u0001\u0019\u0001\"")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public static Runner apply(ActorSystem actorSystem, GatlingConfiguration gatlingConfiguration) {
        return Runner$.MODULE$.apply(actorSystem, gatlingConfiguration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RunResult run(Option<Class<Simulation>> selectedSimulationClass) {
        RunResult runResult;
        Option option = this.configuration.core().directory().reportsOnly();
        if (option instanceof Some) {
            Some some = (Some)option;
            String runId = (String)some.value();
            runResult = new RunResult(runId, true);
        } else {
            if (this.configuration.http().enableGA()) {
                Ga$.MODULE$.send(this.configuration.core().version());
            }
            runResult = this.run0(selectedSimulationClass);
        }
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    private RunResult run0(Option<Class<Simulation>> selectedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.clock_$eq(this.clock);
        Predef$.MODULE$.configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(selectedSimulationClass, this.configuration);
        Simulation simulation = selection.simulationClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation instantiated");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        SimulationParams simulationParams = simulation.params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulation.executeBefore();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hooks executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), this.configuration.core().version());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Throttler throttler = Throttler$.MODULE$.apply(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams, this.configuration), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector, this.clock);
        CoreComponents coreComponents = new CoreComponents(this.system, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List scenarios = simulationParams.scenarios(coreComponents);
        System.gc();
        Try<?> try_ = this.start(simulationParams, (List<Scenario>)scenarios, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulation.executeAfter();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hooks executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public Try<?> start(SimulationParams simulationParams, List<Scenario> scenarios, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarios);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public Runner(ActorSystem system, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
    }
}

