/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.AssertionsTableComponent;
import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.GlobalStatsTableComponent;
import io.gatling.charts.component.SimulationCardComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.GlobalReportGenerator$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.stats.UserSeries;
import io.gatling.charts.template.GlobalPageTemplate;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.model.assertion.AssertionResult;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.ZoneId;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%uA\u0002\u0013&\u0011\u00039SF\u0002\u00040K!\u0005q\u0005\r\u0005\u0006o\u0005!\t!\u000f\u0005\bu\u0005\u0011\r\u0011\"\u0001<\u0011\u00199\u0015\u0001)A\u0005y!9\u0001*\u0001b\u0001\n\u0003Y\u0004BB%\u0002A\u0003%A\bC\u0004K\u0003\t\u0007I\u0011A\u001e\t\r-\u000b\u0001\u0015!\u0003=\u0011\u001da\u0015A1A\u0005\u0002mBa!T\u0001!\u0002\u0013a\u0004b\u0002(\u0002\u0005\u0004%\ta\u000f\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002\u001f\t\u000fA\u000b!\u0019!C\u0001w!1\u0011+\u0001Q\u0001\nqBqAU\u0001C\u0002\u0013\u00051\b\u0003\u0004T\u0003\u0001\u0006I\u0001\u0010\u0005\b)\u0006\u0011\r\u0011\"\u0001<\u0011\u0019)\u0016\u0001)A\u0005y\u0019)q&\n\u0002(-\"A!l\u0005B\u0001B\u0003%1\f\u0003\u0005b'\t\u0005\t\u0015!\u0003c\u0011!)8C!A!\u0002\u00131\b\u0002C=\u0014\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u00051C!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u0010M\u0011\t\u0011)A\u0005\u0003#A!\"!\t\u0014\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\t\td\u0005B\u0001B\u0003%\u00111\u0007\u0005\u0007oM!\t!!\u0011\t\u000f\u0005U3\u0003\"\u0003\u0002X!9\u0011\u0011M\n\u0005\n\u0005\r\u0004bBA4'\u0011%\u0011\u0011\u000e\u0005\b\u0003[\u001aB\u0011BA8\u0011\u001d\t\u0019h\u0005C\u0005\u0003kBq!!\u001f\u0014\t\u0013\tY\bC\u0004\u0002\u0000M!\t!!!\u0002+\u001dcwNY1m%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011aeJ\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005!J\u0013AB2iCJ$8O\u0003\u0002+W\u00059q-\u0019;mS:<'\"\u0001\u0017\u0002\u0005%|\u0007C\u0001\u0018\u0002\u001b\u0005)#!F$m_\n\fGNU3q_J$x)\u001a8fe\u0006$xN]\n\u0003\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00035\n\u0001$V:feN#\u0018M\u001d;SCR,7i\u001c8uC&tWM]%e+\u0005a\u0004CA\u001fE\u001d\tq$\t\u0005\u0002@g5\t\u0001I\u0003\u0002Bq\u00051AH]8pizJ!aQ\u001a\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007N\n\u0011$V:feN#\u0018M\u001d;SCR,7i\u001c8uC&tWM]%eA\u0005iR*\u0019=D_:\u001cWO\u001d:f]R,6/\u001a:t\u0007>tG/Y5oKJLE-\u0001\u0010NCb\u001cuN\\2veJ,g\u000e^+tKJ\u001c8i\u001c8uC&tWM]%eA\u00059\"+Z:q_:\u001cX\rV5nK\u000e{g\u000e^1j]\u0016\u0014\u0018\nZ\u0001\u0019%\u0016\u001c\bo\u001c8tKRKW.Z\"p]R\f\u0017N\\3s\u0013\u0012\u0004\u0013a\u0005*fcV,7\u000f^:D_:$\u0018-\u001b8fe&#\u0017\u0001\u0006*fcV,7\u000f^:D_:$\u0018-\u001b8fe&#\u0007%\u0001\u000bSKN\u0004xN\\:fg\u000e{g\u000e^1j]\u0016\u0014\u0018\nZ\u0001\u0016%\u0016\u001c\bo\u001c8tKN\u001cuN\u001c;bS:,'/\u00133!\u0003\r\u0012Vm\u001d9p]N,G+[7f\t&\u001cHO]5ckRLwN\\\"p]R\f\u0017N\\3s\u0013\u0012\fAEU3ta>t7/\u001a+j[\u0016$\u0015n\u001d;sS\n,H/[8o\u0007>tG/Y5oKJLE\rI\u0001\u0012%\u0006tw-Z:D_:$\u0018-\u001b8fe&#\u0017A\u0005*b]\u001e,7oQ8oi\u0006Lg.\u001a:JI\u0002\n\u0001c\u0015;biN\u001cuN\u001c;bS:,'/\u00133\u0002#M#\u0018\r^:D_:$\u0018-\u001b8fe&#\u0007eE\u0002\u0014c]\u0003\"A\f-\n\u0005e+#a\u0004*fa>\u0014HoR3oKJ\fGo\u001c:\u0002\u00171|wMR5mK\u0012\u000bG/\u0019\t\u00039~k\u0011!\u0018\u0006\u0003=\u001e\nQa\u001d;biNL!\u0001Y/\u0003\u00171{wMR5mK\u0012\u000bG/Y\u0001\u0011CN\u001cXM\u001d;j_:\u0014Vm];miN\u00042a\u00195l\u001d\t!gM\u0004\u0002@K&\tA'\u0003\u0002hg\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\u0011a\u0015n\u001d;\u000b\u0005\u001d\u001c\u0004C\u00017t\u001b\u0005i'B\u00018p\u0003%\t7o]3si&|gN\u0003\u0002qc\u0006)Qn\u001c3fY*\u0011!/K\u0001\u0007g\"\f'/\u001a3\n\u0005Ql'aD!tg\u0016\u0014H/[8o%\u0016\u001cX\u000f\u001c;\u0002\u001bI|w\u000e^\"p]R\f\u0017N\\3s!\tqs/\u0003\u0002yK\tqqI]8va\u000e{g\u000e^1j]\u0016\u0014\u0018aC2iCJ$8OR5mKN\u0004\"a\u001f@\u000e\u0003qT!!`\u0014\u0002\r\r|gNZ5h\u0013\tyHPA\u0006DQ\u0006\u0014Ho\u001d$jY\u0016\u001c\u0018\u0001E2p[B|g.\u001a8u\u0019&\u0014'/\u0019:z!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005O\u0005I1m\\7q_:,g\u000e^\u0005\u0005\u0003\u001b\t9A\u0001\tD_6\u0004xN\\3oi2K'M]1ss\u00061!p\u001c8f\u0013\u0012\u0004B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003uS6,'BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011Q\u0003\u0002\u00075>tW-\u00133\u0002\u000f\rD\u0017M]:fiB!\u0011QEA\u0017\u001b\t\t9C\u0003\u0003\u0002\"\u0005%\"\u0002BA\u0016\u00033\t1A\\5p\u0013\u0011\ty#a\n\u0003\u000f\rC\u0017M]:fi\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!!\u000e\u0002>5\u0011\u0011q\u0007\u0006\u0004{\u0006e\"bAA\u001eS\u0005!1m\u001c:f\u0013\u0011\ty$a\u000e\u0003)I+\u0007o\u001c:ug\u000e{gNZ5hkJ\fG/[8o)I\t\u0019%!\u0012\u0002H\u0005%\u00131JA'\u0003\u001f\n\t&a\u0015\u0011\u00059\u001a\u0002\"\u0002.\u001d\u0001\u0004Y\u0006\"B1\u001d\u0001\u0004\u0011\u0007\"B;\u001d\u0001\u00041\b\"B=\u001d\u0001\u0004Q\bbBA\u00019\u0001\u0007\u00111\u0001\u0005\b\u0003\u001fa\u0002\u0019AA\t\u0011\u001d\t\t\u0003\ba\u0001\u0003GAq!!\r\u001d\u0001\u0004\t\u0019$\u0001\fvg\u0016\u00148\u000b^1siJ\u000bG/Z\"p[B|g.\u001a8u)\u0011\tI&a\u0018\u0011\t\u0005\u0015\u00111L\u0005\u0005\u0003;\n9AA\u0005D_6\u0004xN\\3oi\")!,\ba\u00017\u0006\u0019S.\u0019=Ok6\u0014WM](g\u0007>t7-\u001e:sK:$Xk]3sg\u000e{W\u000e]8oK:$H\u0003BA-\u0003KBQA\u0017\u0010A\u0002m\u000baE]3ta>t7/\u001a+j[\u0016$\u0015n\u001d;sS\n,H/[8o\u0007\"\f'\u000f^\"p[B|g.\u001a8u)\u0011\tI&a\u001b\t\u000bi{\u0002\u0019A.\u00025I,7\u000f]8og\u0016$\u0016.\\3DQ\u0006\u0014HoQ8na>tWM\u001c;\u0015\t\u0005e\u0013\u0011\u000f\u0005\u00065\u0002\u0002\raW\u0001\u0017e\u0016\fX/Z:ug\u000eC\u0017M\u001d;D_6\u0004xN\\3oiR!\u0011\u0011LA<\u0011\u0015Q\u0016\u00051\u0001\\\u0003]\u0011Xm\u001d9p]N,7o\u00115beR\u001cu.\u001c9p]\u0016tG\u000f\u0006\u0003\u0002Z\u0005u\u0004\"\u0002.#\u0001\u0004Y\u0016\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u0005\u0005\r\u0005c\u0001\u001a\u0002\u0006&\u0019\u0011qQ\u001a\u0003\tUs\u0017\u000e\u001e")
public final class GlobalReportGenerator
implements ReportGenerator {
    private final LogFileData logFileData;
    private final List<AssertionResult> assertionResults;
    private final GroupContainer rootContainer;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final ZoneId zoneId;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    public static String StatsContainerId() {
        return GlobalReportGenerator$.MODULE$.StatsContainerId();
    }

    public static String RangesContainerId() {
        return GlobalReportGenerator$.MODULE$.RangesContainerId();
    }

    public static String ResponseTimeDistributionContainerId() {
        return GlobalReportGenerator$.MODULE$.ResponseTimeDistributionContainerId();
    }

    public static String ResponsesContainerId() {
        return GlobalReportGenerator$.MODULE$.ResponsesContainerId();
    }

    public static String RequestsContainerId() {
        return GlobalReportGenerator$.MODULE$.RequestsContainerId();
    }

    public static String ResponseTimeContainerId() {
        return GlobalReportGenerator$.MODULE$.ResponseTimeContainerId();
    }

    public static String MaxConcurrentUsersContainerId() {
        return GlobalReportGenerator$.MODULE$.MaxConcurrentUsersContainerId();
    }

    public static String UserStartRateContainerId() {
        return GlobalReportGenerator$.MODULE$.UserStartRateContainerId();
    }

    private Component userStartRateComponent(LogFileData logFileData) {
        List userStartRateSeries = logFileData.scenarioNames().map((Function1 & Serializable)scenarioName -> new UserSeries((String)scenarioName, logFileData.userStartRatePerSecond((Option<String>)new Some(scenarioName)))).reverse();
        return this.componentLibrary.getUserStartRateComponent(GlobalReportGenerator$.MODULE$.UserStartRateContainerId(), logFileData.runInfo().injectStart(), new UserSeries("All users", logFileData.userStartRatePerSecond((Option<String>)None$.MODULE$)), (Seq<UserSeries>)userStartRateSeries);
    }

    private Component maxNumberOfConcurrentUsersComponent(LogFileData logFileData) {
        List userStartRateSeries = logFileData.scenarioNames().map((Function1 & Serializable)scenarioName -> new UserSeries((String)scenarioName, logFileData.maxNumberOfConcurrentUsersPerSecond((Option<String>)new Some(scenarioName)))).reverse();
        return this.componentLibrary.getMaxConcurrentUsersComponent(GlobalReportGenerator$.MODULE$.MaxConcurrentUsersContainerId(), logFileData.runInfo().injectStart(), new UserSeries("All users", logFileData.maxNumberOfConcurrentUsersPerSecond((Option<String>)None$.MODULE$)), (Seq<UserSeries>)userStartRateSeries);
    }

    private Component responseTimeDistributionChartComponent(LogFileData logFileData) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = logFileData.responseTimeDistribution(100, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        return this.componentLibrary.getDistributionComponent(GlobalReportGenerator$.MODULE$.ResponseTimeDistributionContainerId(), "Response Time", "Requests", (Seq<PercentVsTimePlot>)okDistribution2, (Seq<PercentVsTimePlot>)koDistribution2);
    }

    private Component responseTimeChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getPercentilesOverTimeComponent(GlobalReportGenerator$.MODULE$.ResponseTimeContainerId(), "Response Time Percentiles over Time (" + Series$.MODULE$.OK() + ")", "Response Time", logFileData.runInfo().injectStart(), logFileData.responseTimePercentilesOverTime((Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$));
    }

    private Component requestsChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getRequestsComponent(GlobalReportGenerator$.MODULE$.RequestsContainerId(), logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)logFileData.numberOfRequestsPerSecond((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    private Component responsesChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getResponsesComponent(GlobalReportGenerator$.MODULE$.ResponsesContainerId(), logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)logFileData.numberOfResponsesPerSecond((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    @Override
    public void generate() {
        Ranges ranges = this.logFileData.numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        GlobalPageTemplate template = new GlobalPageTemplate(this.logFileData.runInfo(), this.rootContainer, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent(GlobalReportGenerator$.MODULE$.RangesContainerId(), "Response Time Ranges", "requests", ranges, false), this.componentLibrary.getRequestCountPolarComponent(this.rootContainer), new SimulationCardComponent(this.logFileData.runInfo(), this.zoneId)})), new AssertionsTableComponent(this.assertionResults), new GlobalStatsTableComponent(GlobalReportGenerator$.MODULE$.StatsContainerId(), this.rootContainer, this.configuration.indicators()), new ErrorsTableComponent(this.logFileData.errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)), this.userStartRateComponent(this.logFileData), this.maxNumberOfConcurrentUsersComponent(this.logFileData), this.responseTimeDistributionChartComponent(this.logFileData), this.responseTimeChartComponent(this.logFileData), this.requestsChartComponent(this.logFileData), this.responsesChartComponent(this.logFileData)}));
        new TemplateWriter(this.chartsFiles.globalFile()).writeToFile(template.getOutput(), this.charset);
    }

    public GlobalReportGenerator(LogFileData logFileData, List<AssertionResult> assertionResults, GroupContainer rootContainer, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, ZoneId zoneId, Charset charset, ReportsConfiguration configuration) {
        this.logFileData = logFileData;
        this.assertionResults = assertionResults;
        this.rootContainer = rootContainer;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.zoneId = zoneId;
        this.charset = charset;
        this.configuration = configuration;
    }
}

