/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats;

import io.gatling.charts.stats.LogFileParser$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.stats.writer.StringInternals;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ms!\u0002\u0011\"\u0011\u0013Qc!\u0002\u0017\"\u0011\u0013i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007w\u0005\u0001\u000b\u0011\u0002\u001d\u0007\u000b1\n\u0013\u0011\u0002\u001f\t\u0011%+!\u0011!Q\u0001\n)CQ\u0001N\u0003\u0005\u0002=Cq!X\u0003C\u0002\u0013%a\f\u0003\u0004c\u000b\u0001\u0006Ia\u0018\u0005\bG\u0016\u0011\r\u0011\"\u0003e\u0011\u0019YW\u0001)A\u0005K\"9A.\u0002b\u0001\n\u0013i\u0007BB@\u0006A\u0003%a\u000eC\u0004\u0002\u0002\u0015!\t\"a\u0001\t\u000f\u0005\u0015Q\u0001\"\u0005\u0002\b!9\u0011\u0011B\u0003\u0005\u0012\u0005-\u0001bBA\n\u000b\u0011E\u00111\u0001\u0005\b\u0003+)A\u0011CA\f\u0011\u001d\tI\"\u0002C\t\u00037Aq!a\t\u0006\t#\t)\u0003C\u0004\u0002(\u0015!I!!\u000b\t\u000f\u0005=R\u0001\"\u0005\u0002&!9\u0011\u0011G\u0003\u0005\u0012\u0005\u0015\u0002bBA\u001a\u000b\u0011E\u0011Q\u0007\u0005\b\u0003\u0003*A\u0011CA\"\u0011\u001d\t)%\u0002C\t\u0003\u0007Bq!a\u0012\u0006\t#\t\u0019\u0005C\u0004\u0002J\u0015!\t\"a\u0011\t\u000f\u0005-S\u0001\"\u0005\u0002D!9\u0011QJ\u0003\u0005B\u0005\r\u0003bBA(\u000b\u0019\u0005\u0011\u0011K\u0001\u000e\u0019><g)\u001b7f!\u0006\u00148/\u001a:\u000b\u0005\t\u001a\u0013!B:uCR\u001c(B\u0001\u0013&\u0003\u0019\u0019\u0007.\u0019:ug*\u0011aeJ\u0001\bO\u0006$H.\u001b8h\u0015\u0005A\u0013AA5p\u0007\u0001\u0001\"aK\u0001\u000e\u0003\u0005\u0012Q\u0002T8h\r&dW\rU1sg\u0016\u00148CA\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AK\u0001\b\u0019><7\u000b^3q+\u0005A\u0004CA\u0018:\u0013\tQ\u0004GA\u0002J]R\f\u0001\u0002T8h'R,\u0007\u000fI\u000b\u0003{M\u001b2!\u0002 G!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u00142kK\u000e$\bCA H\u0013\tA\u0005IA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\bY><g)\u001b7f!\tYU*D\u0001M\u0015\tA#)\u0003\u0002O\u0019\n!a)\u001b7f)\t\u0001F\fE\u0002,\u000bE\u0003\"AU*\r\u0001\u0011)A+\u0002b\u0001+\n\tA+\u0005\u0002W3B\u0011qfV\u0005\u00031B\u0012qAT8uQ&tw\r\u0005\u000205&\u00111\f\r\u0002\u0004\u0003:L\b\"B%\b\u0001\u0004Q\u0015AA5t+\u0005y\u0006CA&a\u0013\t\tGJA\bECR\f\u0017J\u001c9viN#(/Z1n\u0003\rI7\u000fI\u0001\u000bg.L\u0007OQ;gM\u0016\u0014X#A3\u0011\u0007=2\u0007.\u0003\u0002ha\t)\u0011I\u001d:bsB\u0011q&[\u0005\u0003UB\u0012AAQ=uK\u0006Y1o[5q\u0005V4g-\u001a:!\u0003-\u0019HO]5oO\u000e\u000b7\r[3\u0016\u00039\u0004Ba\u001c:9i6\t\u0001O\u0003\u0002r\u0005\u0006!Q\u000f^5m\u0013\t\u0019\bOA\u0004ICNDW*\u00199\u0011\u0005UdhB\u0001<{!\t9\b'D\u0001y\u0015\tI\u0018&\u0001\u0004=e>|GOP\u0005\u0003wB\na\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u00111\u0010M\u0001\rgR\u0014\u0018N\\4DC\u000eDW\rI\u0001\u0005e\u0016\fG\rF\u00019\u0003!\u0011X-\u00193CsR,G#\u00015\u0002\u0017I,\u0017\r\u001a\"p_2,\u0017M\u001c\u000b\u0003\u0003\u001b\u00012aLA\b\u0013\r\t\t\u0002\r\u0002\b\u0005>|G.Z1o\u0003\u001d\u0011X-\u00193J]R\fQB]3bI\nKH/Z!se\u0006LH#A3\u0002\u0011I,\u0017\r\u001a'p]\u001e$\"!!\b\u0011\u0007=\ny\"C\u0002\u0002\"A\u0012A\u0001T8oO\u0006Q!/Z1e'R\u0014\u0018N\\4\u0015\u0003Q\f\u0001b]1oSRL'0\u001a\u000b\u0004i\u0006-\u0002BBA\u0017+\u0001\u0007A/A\u0001t\u0003M\u0011X-\u00193TC:LG/\u001b>fIN#(/\u001b8h\u0003e\u0011X-\u00193DC\u000eDW\rZ*b]&$\u0018N_3e'R\u0014\u0018N\\4\u0002\tM\\\u0017\u000e\u001d\u000b\u0005\u0003o\ti\u0004E\u00020\u0003sI1!a\u000f1\u0005\u0011)f.\u001b;\t\r\u0005}\u0002\u00041\u00019\u0003\raWM\\\u0001\tg.L\u0007OQ=uKR\u0011\u0011qG\u0001\bg.L\u0007/\u00138u\u0003!\u00198.\u001b9M_:<\u0017AC:lSB\u001cFO]5oO\u0006\u00012o[5q\u0007\u0006\u001c\u0007.\u001a3TiJLgnZ\u0001\u0006G2|7/Z\u0001\u0006a\u0006\u00148/\u001a\u000b\u0002#\u0002")
public abstract class LogFileParser<T>
implements AutoCloseable {
    private final DataInputStream is;
    private final byte[] skipBuffer;
    private final HashMap<Object, String> stringCache;

    public static int LogStep() {
        return LogFileParser$.MODULE$.LogStep();
    }

    private DataInputStream is() {
        return this.is;
    }

    private byte[] skipBuffer() {
        return this.skipBuffer;
    }

    private HashMap<Object, String> stringCache() {
        return this.stringCache;
    }

    public int read() {
        return this.is().read();
    }

    public byte readByte() {
        return this.is().readByte();
    }

    public boolean readBoolean() {
        return this.is().readBoolean();
    }

    public int readInt() {
        return this.is().readInt();
    }

    public byte[] readByteArray() {
        return this.is().readNBytes(this.readInt());
    }

    public long readLong() {
        return this.is().readLong();
    }

    public String readString() {
        int length = this.readInt();
        if (length == 0) {
            return "";
        }
        byte[] value = this.is().readNBytes(length);
        byte coder = this.readByte();
        return StringInternals.newString((byte[])value, (byte)coder);
    }

    private String sanitize(String s) {
        return StringHelper.RichString$.MODULE$.replaceIf$extension(StringHelper$.MODULE$.RichString(s), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)LogFileParser.$anonfun$sanitize$1(BoxesRunTime.unboxToChar((Object)c))), ' ');
    }

    public String readSanitizedString() {
        return this.sanitize(this.readString());
    }

    public String readCachedSanitizedString() {
        int cachedIndex = this.readInt();
        if (cachedIndex >= 0) {
            String string = this.sanitize(this.readString());
            this.stringCache().put(BoxesRunTime.boxToInteger((int)cachedIndex), string);
            return string;
        }
        String cachedString = this.stringCache().get(BoxesRunTime.boxToInteger((int)(-cachedIndex)));
        Predef$.MODULE$.assert(cachedString != null, (Function0 & Serializable)() -> "Cached string missing for " + -cachedIndex + " index");
        return cachedString;
    }

    public void skip(int len) {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.is().read(this.skipBuffer(), 0, package$.MODULE$.min(len - n, this.skipBuffer().length));
            if (count >= 0) continue;
            throw new EOFException("Failed to skip " + len + " bytes");
        }
    }

    public void skipByte() {
        this.skip(1);
    }

    public void skipInt() {
        this.skip(4);
    }

    public void skipLong() {
        this.skip(8);
    }

    public void skipString() {
        int length = this.readInt();
        if (length > 0) {
            this.skip(length + 1);
            return;
        }
    }

    public void skipCachedString() {
        if (this.readInt() >= 0) {
            this.skipString();
            return;
        }
    }

    @Override
    public void close() {
        this.is().close();
    }

    public abstract T parse();

    public static final /* synthetic */ boolean $anonfun$sanitize$1(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    public LogFileParser(File logFile) {
        this.is = new DataInputStream(new BufferedInputStream(Files.newInputStream(logFile.toPath(), new OpenOption[0])));
        this.skipBuffer = new byte[1024];
        this.stringCache = new HashMap();
    }
}

