/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.pause.Constant$;
import io.gatling.core.pause.Disabled$;
import io.gatling.core.pause.Exponential$;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public abstract class PauseType {
    public static final PauseType Disabled = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Disabled$.MODULE$;
        }
    };
    public static final PauseType Constant = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Constant$.MODULE$;
        }
    };
    public static final PauseType Exponential = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Exponential$.MODULE$;
        }
    };

    private PauseType() {
    }

    public abstract io.gatling.core.pause.PauseType asScala();

    public static final class UniformDuration
    extends PauseType {
        private final Duration plusOrMinus;

        public UniformDuration(@NonNull Duration duration) {
            this.plusOrMinus = duration;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.UniformDuration(Converters.toScalaDuration(this.plusOrMinus));
        }
    }

    public static final class UniformPercentage
    extends PauseType {
        private final double plusOrMinus;

        UniformPercentage(double d) {
            this.plusOrMinus = d;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.UniformPercentage(this.plusOrMinus);
        }
    }

    public static final class Custom
    extends PauseType {
        private final Function<Session, Long> f;

        Custom(@NonNull Function<Session, Long> function) {
            this.f = function;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.Custom(Expressions.javaLongFunctionToExpression(this.f));
        }
    }

    public static final class NormalWithStdDevDuration
    extends PauseType {
        private final Duration stdDev;

        NormalWithStdDevDuration(@NonNull Duration duration) {
            this.stdDev = duration;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.NormalWithStdDevDuration(Converters.toScalaDuration(this.stdDev));
        }
    }

    public static final class NormalWithPercentageDuration
    extends PauseType {
        private final double stdDev;

        NormalWithPercentageDuration(double d) {
            this.stdDev = d;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.NormalWithPercentageDuration(this.stdDev);
        }
    }
}

