/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.Part;
import io.gatling.http.client.body.multipart.impl.MessageEndPartImpl;
import io.gatling.http.client.body.multipart.impl.MultipartChunkedInput;
import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.gatling.netty.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartFormDataRequestBody
extends RequestBody.Base<List<Part<?>>> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartFormDataRequestBody.class);
    private final byte[] boundary;
    private final String patchedContentType;

    MultipartFormDataRequestBody(List<Part<?>> list, String string, byte[] byArray) {
        super(list);
        this.boundary = byArray;
        this.patchedContentType = string;
    }

    private MultipartChunkedInput toChunkedInput() {
        ArrayList<PartImpl> arrayList = new ArrayList<PartImpl>(((List)this.content).size() + 1);
        for (Part part : (List)this.content) {
            arrayList.add(part.toImpl(this.boundary));
        }
        arrayList.add(new MessageEndPartImpl(this.boundary));
        return new MultipartChunkedInput(arrayList);
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        MultipartChunkedInput multipartChunkedInput = this.toChunkedInput();
        return new WritableContent(multipartChunkedInput, multipartChunkedInput.length());
    }

    @Override
    public RequestBodyBuilder newBuilder() {
        return new MultipartFormDataRequestBodyBuilder((List)this.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        MultipartChunkedInput multipartChunkedInput = this.toChunkedInput();
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(ByteBufAllocator.DEFAULT, false, Integer.MAX_VALUE);
        try {
            ByteBuf byteBuf;
            do {
                byteBuf = multipartChunkedInput.readChunk(ByteBufAllocator.DEFAULT).content();
                compositeByteBuf.addComponent(true, byteBuf);
            } while (byteBuf != null);
            byte[] byArray = ByteBufUtils.byteBuf2Bytes((ByteBuf)compositeByteBuf);
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("An exception occurred while getting the bytes of the parts", (Throwable)exception);
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            compositeByteBuf.release();
        }
    }

    @Override
    public String getPatchedContentType() {
        return this.patchedContentType;
    }

    @Override
    public String print(int n) {
        StringBuilder stringBuilder = new StringBuilder("MultipartFormDataRequestBody{");
        stringBuilder.append("boundary=").append(Arrays.toString(this.boundary));
        stringBuilder.append(", patchedContentType='").append(this.patchedContentType).append('\'');
        stringBuilder.append(", content=");
        ((List)this.content).forEach(part -> stringBuilder.append(this.truncate(part.toString(), n)).append("\n"));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

