/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.pool.ChannelPool;
import io.gatling.http.client.util.HttpUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpAppHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAppHandler.class);
    static final IOException PREMATURE_CLOSE = new IOException("Premature close"){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private final DefaultHttpClient client;
    private final ChannelPool channelPool;
    private HttpTx tx;
    private boolean httpResponseReceived;

    HttpAppHandler(DefaultHttpClient defaultHttpClient, ChannelPool channelPool) {
        this.client = defaultHttpClient;
        this.channelPool = channelPool;
    }

    public boolean isSharable() {
        return false;
    }

    private void setActive(HttpTx httpTx) {
        this.tx = httpTx;
    }

    private void setInactive() {
        this.tx = null;
        this.httpResponseReceived = false;
    }

    private boolean isInactive() {
        return this.tx == null || this.tx.requestTimeout.isDone();
    }

    private void releasePendingRequestExpectingContinue() {
        if (this.tx != null) {
            this.tx.releasePendingRequestExpectingContinue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl, HttpTx httpTx) {
        this.releasePendingRequestExpectingContinue();
        try {
            httpTx.requestTimeout.cancel();
            httpTx.listener.onThrowable(throwable);
            this.setInactive();
        }
        catch (Exception exception) {
            LOGGER.error("Exception while handling HTTP/1.1 crash, please report to Gatling maintainers", (Throwable)exception);
        }
        finally {
            if (bl) {
                channelHandlerContext.close();
            }
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpTx httpTx = (HttpTx)object;
        this.setActive(httpTx);
        if (httpTx.requestTimeout.isDone()) {
            this.setInactive();
            return;
        }
        try {
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), false, httpTx.listener);
            LOGGER.debug("Write request {}", (Object)writableRequest);
            httpTx.listener.onWrite(channelHandlerContext.channel());
            if (HttpUtil.is100ContinueExpected((HttpMessage)writableRequest.getRequest())) {
                LOGGER.debug("Delaying body write");
                httpTx.pendingRequestExpectingContinue = writableRequest;
                writableRequest.writeWithoutContent(channelHandlerContext);
            } else {
                writableRequest.write(channelHandlerContext);
            }
        }
        catch (Exception exception) {
            this.exceptionCaught(channelHandlerContext, exception);
        }
    }

    private boolean exitOnDecodingFailure(ChannelHandlerContext channelHandlerContext, DecoderResultProvider decoderResultProvider) {
        Throwable throwable = decoderResultProvider.decoderResult().cause();
        if (throwable != null) {
            this.exceptionCaught(channelHandlerContext, throwable);
            return true;
        }
        return false;
    }

    private void channelReadHttpResponse(ChannelHandlerContext channelHandlerContext, HttpResponse httpResponse) {
        HttpResponseStatus httpResponseStatus = httpResponse.status();
        if (this.tx.pendingRequestExpectingContinue != null) {
            if (httpResponseStatus.equals((Object)HttpResponseStatus.CONTINUE)) {
                LOGGER.debug("Received 100-Continue");
                return;
            }
            LOGGER.debug("Request was sent with Expect:100-Continue but received response with status {}, dropping", (Object)httpResponseStatus);
            this.tx.releasePendingRequestExpectingContinue();
        }
        this.httpResponseReceived = true;
        if (this.exitOnDecodingFailure(channelHandlerContext, (DecoderResultProvider)httpResponse)) {
            return;
        }
        this.tx.listener.onHttpResponse(httpResponseStatus, httpResponse.headers());
        this.tx.closeConnection = this.tx.closeConnection || HttpUtils.isConnectionClose(httpResponse.headers());
    }

    private void channelReadHttpContent(ChannelHandlerContext channelHandlerContext, HttpContent httpContent, boolean bl) {
        if (this.exitOnDecodingFailure(channelHandlerContext, (DecoderResultProvider)httpContent)) {
            return;
        }
        if (this.tx.pendingRequestExpectingContinue != null) {
            if (bl) {
                LOGGER.debug("Received 100-Continue' LastHttpContent, sending body");
                this.tx.pendingRequestExpectingContinue.writeContent(channelHandlerContext);
                this.tx.pendingRequestExpectingContinue = null;
            }
            return;
        }
        HttpTx httpTx = this.tx;
        if (bl) {
            httpTx.requestTimeout.cancel();
            this.setInactive();
            if (httpTx.closeConnection) {
                channelHandlerContext.channel().close();
            } else {
                this.channelPool.offer(channelHandlerContext.channel());
            }
        }
        try {
            httpTx.listener.onHttpResponseBodyChunk(httpContent.content(), bl);
        }
        catch (Throwable throwable) {
            this.crash(channelHandlerContext, throwable, true, httpTx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.isInactive()) {
            return;
        }
        LOGGER.debug("Read msg='{}'", object);
        if (object instanceof DefaultHttpResponse) {
            this.channelReadHttpResponse(channelHandlerContext, (HttpResponse)((DefaultHttpResponse)object));
        } else if (object == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.channelReadHttpContent(channelHandlerContext, (HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, true);
        } else {
            if (object instanceof DefaultLastHttpContent) {
                DefaultLastHttpContent defaultLastHttpContent = (DefaultLastHttpContent)object;
                try {
                    this.channelReadHttpContent(channelHandlerContext, (HttpContent)defaultLastHttpContent, true);
                }
                finally {
                    defaultLastHttpContent.release();
                }
            }
            if (object instanceof DefaultHttpContent) {
                DefaultHttpContent defaultHttpContent = (DefaultHttpContent)object;
                try {
                    this.channelReadHttpContent(channelHandlerContext, (HttpContent)defaultHttpContent, false);
                }
                finally {
                    defaultHttpContent.release();
                }
            }
            if (object instanceof HttpResponse) {
                try {
                    this.channelReadHttpResponse(channelHandlerContext, (HttpResponse)object);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
            }
            if (object instanceof HttpContent) {
                try {
                    this.channelReadHttpContent(channelHandlerContext, (HttpContent)object, object instanceof LastHttpContent);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
            }
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.releasePendingRequestExpectingContinue();
        if (this.isInactive()) {
            return;
        }
        HttpTx httpTx = this.tx;
        this.setInactive();
        httpTx.requestTimeout.cancel();
        if (!this.httpResponseReceived && this.client.canRetry(httpTx)) {
            this.client.retry(httpTx, channelHandlerContext.channel().eventLoop());
        } else {
            this.crash(channelHandlerContext, PREMATURE_CLOSE, false, httpTx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.releasePendingRequestExpectingContinue();
        if (throwable instanceof Error) {
            LOGGER.error("Fatal error", throwable);
            System.exit(1);
        }
        if (this.isInactive()) {
            return;
        }
        this.crash(channelHandlerContext, throwable, true, this.tx);
    }
}

