/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.form;

import io.gatling.http.client.Param;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.netty.util.StringBuilderPool;
import io.gatling.netty.util.Utf8UrlEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class FormUrlEncodedRequestBody
extends RequestBody<List<Param>> {
    public FormUrlEncodedRequestBody(List<Param> list, String string, Charset charset) {
        super(list, string, charset);
    }

    @Override
    public WritableContent build(boolean bl, ByteBufAllocator byteBufAllocator) {
        StringBuilder stringBuilder = this.encode();
        ByteBuf byteBuf = ByteBufUtil.writeAscii((ByteBufAllocator)byteBufAllocator, (CharSequence)stringBuilder);
        return new WritableContent(byteBuf, byteBuf.readableBytes());
    }

    private StringBuilder encode() {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        for (Param param : (List)this.content) {
            FormUrlEncodedRequestBody.encodeAndAppendFormParam(stringBuilder, param.getName(), param.getValue(), this.charset);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder;
    }

    private static void encodeAndAppendFormParam(StringBuilder stringBuilder, String string, String string2, Charset charset) {
        FormUrlEncodedRequestBody.encodeAndAppendFormField(stringBuilder, string, charset);
        if (string2 != null) {
            stringBuilder.append('=');
            FormUrlEncodedRequestBody.encodeAndAppendFormField(stringBuilder, string2, charset);
        }
        stringBuilder.append('&');
    }

    private static void encodeAndAppendFormField(StringBuilder stringBuilder, String string, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            Utf8UrlEncoder.encodeAndAppendFormElement((StringBuilder)stringBuilder, (CharSequence)string);
        } else {
            try {
                stringBuilder.append(URLEncoder.encode(string, charset.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public RequestBodyBuilder<List<Param>> newBuilder() {
        return new FormUrlEncodedRequestBodyBuilder((List)this.content);
    }

    @Override
    public byte[] getBytes() {
        return this.encode().toString().getBytes();
    }

    public String toString() {
        return "FormUrlEncodedRequestBody{content=" + this.content + ", contentType=" + this.contentType + ", charset=" + this.charset + '}';
    }
}

