/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Consumer;

public class Request {
    private final String name;
    private final HttpMethod method;
    private final Uri uri;
    private final HttpHeaders headers;
    private final List<Cookie> cookies;
    private final RequestBody body;
    private final long requestTimeout;
    private final String virtualHost;
    private final boolean autoOrigin;
    private final InetAddress localIpV4Address;
    private final InetAddress localIpV6Address;
    private final Realm realm;
    private final ProxyServer proxyServer;
    private final Consumer<Request> signatureCalculator;
    private final InetAddressNameResolver nameResolver;
    private final boolean http2Enabled;
    private final boolean alpnRequired;
    private final boolean http2PriorKnowledge;
    private final String wsSubprotocol;

    public Request(String string, HttpMethod httpMethod, Uri uri, HttpHeaders httpHeaders, List<Cookie> list, RequestBody requestBody, long l, String string2, boolean bl, InetAddress inetAddress, InetAddress inetAddress2, Realm realm, ProxyServer proxyServer, Consumer<Request> consumer, InetAddressNameResolver inetAddressNameResolver, boolean bl2, boolean bl3, boolean bl4, String string3) {
        this.name = string;
        this.method = httpMethod;
        this.uri = uri;
        this.headers = httpHeaders;
        this.cookies = list;
        this.body = requestBody;
        this.requestTimeout = l;
        this.virtualHost = string2;
        this.autoOrigin = bl;
        this.localIpV4Address = inetAddress;
        this.localIpV6Address = inetAddress2;
        this.realm = realm;
        this.proxyServer = proxyServer;
        this.signatureCalculator = consumer;
        this.nameResolver = inetAddressNameResolver;
        this.http2Enabled = bl2;
        this.alpnRequired = bl3;
        this.http2PriorKnowledge = bl4;
        this.wsSubprotocol = string3;
    }

    public Request copyWithAlpnRequiredAndPriorKnowledge(boolean bl, boolean bl2) {
        return new Request(this.name, this.method, this.uri, this.headers, this.cookies, this.body, this.requestTimeout, this.virtualHost, this.autoOrigin, this.localIpV4Address, this.localIpV6Address, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, bl, bl2, this.wsSubprotocol);
    }

    public String getName() {
        return this.name;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Uri getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public boolean isAutoOrigin() {
        return this.autoOrigin;
    }

    public InetAddress getLocalIpV4Address() {
        return this.localIpV4Address;
    }

    public InetAddress getLocalIpV6Address() {
        return this.localIpV6Address;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public Consumer<Request> getSignatureCalculator() {
        return this.signatureCalculator;
    }

    public InetAddressNameResolver getNameResolver() {
        return this.nameResolver;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public boolean isAlpnRequired() {
        return this.alpnRequired;
    }

    public boolean isHttp2PriorKnowledge() {
        return this.http2PriorKnowledge;
    }

    public String getWsSubprotocol() {
        return this.wsSubprotocol;
    }

    public String toString() {
        return "Request{method=" + this.method + ", uri=" + this.uri + ", headers=" + this.headers + ", cookies=" + this.cookies + ", body=" + this.body + ", requestTimeout=" + this.requestTimeout + ", virtualHost='" + this.virtualHost + '\'' + ", localIpV4Address=" + this.localIpV4Address + ", localIpV6Address=" + this.localIpV6Address + ", realm=" + this.realm + ", proxyServer=" + this.proxyServer + ", signatureCalculator=" + this.signatureCalculator + ", nameResolver=" + this.nameResolver + ", http2Enabled=" + this.http2Enabled + ", alpnRequired=" + this.alpnRequired + ", http2PriorKnowledge=" + this.http2PriorKnowledge + ", wsSubprotocol=" + this.wsSubprotocol + '}';
    }
}

