/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001]4AAC\u0006\u0001-!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b5\u0003A\u0011\u0001(\t\u000bU\u0003A\u0011\u0001,\t\u000b\u0011\u0004A\u0011B3\t\u000b-\u0004A\u0011\u00027\t\u000bE\u0004A\u0011\u0002:\u0003/A{G\u000e\\3s%\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014(B\u0001\u0007\u000e\u0003\u001d\u0001x\u000e\u001c7j]\u001eT!AD\b\u0002\r\u0005\u001cG/[8o\u0015\t\u0001\u0012#\u0001\u0003iiR\u0004(B\u0001\n\u0014\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001F\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001/u9\u0003C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u0005a1oY1mC2|wmZ5oO*\u0011!eI\u0001\tif\u0004Xm]1gK*\tA%A\u0002d_6L!AJ\u0010\u0003\u001bM#(/[2u\u0019><w-\u001b8h!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003vi&d'B\u0001\u0017\u0012\u0003\u0011\u0019wN]3\n\u00059J#a\u0002(b[\u0016<UM\\\u0001\u0003ib\u0004\"!M\u001b\u000e\u0003IR!aL\u001a\u000b\u0005Qz\u0011AB3oO&tW-\u0003\u00027e\t1\u0001\n\u001e;q)b\f\u0001c]3tg&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u001a\u0014\u0001\u0003:fgB|gn]3\n\u0005uR$\u0001E*fgNLwN\u001c)s_\u000e,7o]8s\u00039\u0019H/\u0019;t!J|7-Z:t_J\u0004\"!\u000f!\n\u0005\u0005S$AD*uCR\u001c\bK]8dKN\u001cxN]\u0001\u000fI\u00164\u0017-\u001e7u\u0007\"\f'o]3u!\t!5*D\u0001F\u0015\t1u)A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005!K\u0015a\u00018j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'F\u0005\u001d\u0019\u0005.\u0019:tKR\fa\u0001P5oSRtD#B(R%N#\u0006C\u0001)\u0001\u001b\u0005Y\u0001\"B\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001c\u0006\u0001\u0004A\u0004\"\u0002 \u0006\u0001\u0004y\u0004\"\u0002\"\u0006\u0001\u0004\u0019\u0015AC8o\u0007>l\u0007\u000f\\3uKR\u0011q+\u0018\t\u00031nk\u0011!\u0017\u0006\u00035.\nqa]3tg&|g.\u0003\u0002]3\n91+Z:tS>t\u0007\"\u00020\u0007\u0001\u0004y\u0016A\u0002:fgVdG\u000f\u0005\u0002aE6\t\u0011M\u0003\u0002<\u001f%\u00111-\u0019\u0002\u000b\u0011R$\bOU3tk2$\u0018!\u00045b]\u0012dWMR1jYV\u0014X\r\u0006\u0002XM\")qm\u0002a\u0001Q\u00069a-Y5mkJ,\u0007C\u00011j\u0013\tQ\u0017MA\u0006IiR\u0004h)Y5mkJ,\u0017A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0003/6DQa\u000f\u0005A\u00029\u0004\"\u0001Y8\n\u0005A\f'\u0001\u0003*fgB|gn]3\u0002\u001f!\fg\u000e\u001a7f%\u0016\u001c\bo\u001c8tKB\"\"a\u001d<\u0011\u0005e\"\u0018BA;;\u0005=\u0001&o\\2fgN|'OU3tk2$\b\"B\u001e\n\u0001\u0004q\u0007")
public class PollerResponseProcessor
implements StrictLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final Charset defaultCharset;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Session onComplete(HttpResult result) {
        Session session;
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            session = this.handleResponse(response);
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            session = this.handleFailure(httpFailure);
        } else {
            throw new MatchError((Object)httpResult);
        }
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private Session handleFailure(HttpFailure failure) {
        void var3_2;
        Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.session(), failure.startTimestamp(), failure.endTimestamp());
        try {
            this.statsProcessor.reportStats(this.tx.fullRequestName(), this.tx.request().clientRequest(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
        return var3_2;
    }

    private Session handleResponse(Response response) {
        Session session;
        Request clientRequest = this.tx.request().clientRequest();
        ProcessorResult processorResult = this.handleResponse0(response);
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)status, response, errorMessage);
            session = newSession;
        } else if (processorResult instanceof Redirect) {
            BoxedUnit boxedUnit;
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, redirectTx.session(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Polling support doesn't support redirect atm");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            session = this.tx.session().markAsFailed();
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.session(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            session = newSession;
        } else {
            throw new MatchError((Object)processorResult);
        }
        return session;
    }

    private ProcessorResult handleResponse0(Response response) {
        ProcessorResult processorResult;
        block16: {
            try {
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    if (this.tx.redirectCount() >= this.tx.request().requestConfig().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(this.tx.request().requestConfig().maxRedirects()).toString());
                    } else {
                        Crash crash;
                        Option<String> option = response.header(HeaderNames$.MODULE$.Location());
                        if (option instanceof Some) {
                            ProcessorResult processorResult2;
                            Some some = (Some)option;
                            String location = (String)some.value();
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                            Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.session(), response, redirectUri);
                            Validation<Request> validation = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                            if (validation instanceof Success) {
                                Success success = (Success)validation;
                                Request redirectRequest = (Request)success.value();
                                HttpTx fresh$macro$3 = this.tx;
                                HttpTx fresh$macro$6 = (HttpTx)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> fresh$macro$1.copy((Session)fresh$macro$2.apply((Object)fresh$macro$1.session()), fresh$macro$1.copy$default$2(), fresh$macro$1.copy$default$3(), fresh$macro$1.copy$default$4(), fresh$macro$1.copy$default$5(), fresh$macro$1.copy$default$6())).setTo((Object)newSession);
                                HttpTx fresh$macro$9 = (HttpTx)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable & scala.Serializable)(fresh$macro$4, fresh$macro$5) -> {
                                    Request x$1 = (Request)fresh$macro$5.apply((Object)fresh$macro$4.request().clientRequest());
                                    String x$2 = fresh$macro$4.request().copy$default$1();
                                    HttpRequestConfig x$3 = fresh$macro$4.request().copy$default$3();
                                    HttpRequest x$4 = fresh$macro$4.request().copy(x$2, x$1, x$3);
                                    Session x$5 = fresh$macro$4.copy$default$1();
                                    Function1<Request, ResponseBuilder> x$6 = fresh$macro$4.copy$default$3();
                                    Action x$7 = fresh$macro$4.copy$default$4();
                                    Option<ResourceTx> x$8 = fresh$macro$4.copy$default$5();
                                    int x$9 = fresh$macro$4.copy$default$6();
                                    return fresh$macro$4.copy(x$5, x$4, x$6, x$7, x$8, x$9);
                                }).setTo((Object)redirectRequest);
                                processorResult2 = new Redirect((HttpTx)new package.PathModify((Object)fresh$macro$9, (Function2 & Serializable & scala.Serializable)(fresh$macro$7, fresh$macro$8) -> {
                                    int x$10 = fresh$macro$8.apply$mcII$sp(fresh$macro$7.redirectCount());
                                    Session x$11 = fresh$macro$7.copy$default$1();
                                    HttpRequest x$12 = fresh$macro$7.copy$default$2();
                                    Function1<Request, ResponseBuilder> x$13 = fresh$macro$7.copy$default$3();
                                    Action x$14 = fresh$macro$7.copy$default$4();
                                    Option<ResourceTx> x$15 = fresh$macro$7.copy$default$5();
                                    return fresh$macro$7.copy(x$11, x$12, x$13, x$14, x$15, x$10);
                                }).using((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$4 -> x$4 + 1));
                            } else if (validation instanceof Failure) {
                                Failure failure = (Failure)validation;
                                String message = failure.message();
                                processorResult2 = new Crash(message);
                            } else {
                                throw new MatchError(validation);
                            }
                            crash = processorResult2;
                        } else {
                            crash = new Crash("Redirect status, yet no Location header");
                        }
                        processorResult = crash;
                    }
                    break block16;
                }
                Tuple2<Session, Option<String>> tuple2 = this.sessionProcessor.updatedSession(this.tx.session(), response);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Session newSession = (Session)tuple2._1();
                Option errorMessage = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                Tuple2 tuple23 = tuple22;
                Session newSession2 = (Session)tuple23._1();
                Option errorMessage2 = (Option)tuple23._2();
                processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
            }
            catch (Throwable throwable) {
                Throwable t;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    t = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Crash crash = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
                processorResult = crash;
            }
        }
        return processorResult;
    }

    public PollerResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.defaultCharset = defaultCharset;
        StrictLogging.$init$((StrictLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

