/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.NextExecutor;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0007\u000f\u0001eA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\"B*\u0001\t\u0003!\u0006\"B.\u0001\t\u0003a\u0006\"B4\u0001\t\u0013A\u0007\"\u00028\u0001\t\u0013y\u0007\"B;\u0001\t\u00131\b\"\u0002?\u0001\t\u0013i\bbBA\b\u0001\u0011%\u0011\u0011\u0003\u0002\u0019\t\u00164\u0017-\u001e7u%\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014(BA\b\u0011\u0003!\u0011Xm\u001d9p]N,'BA\t\u0013\u0003\u0019)gnZ5oK*\u00111\u0003F\u0001\u0005QR$\bO\u0003\u0002\u0016-\u00059q-\u0019;mS:<'\"A\f\u0002\u0005%|7\u0001A\n\u0006\u0001i\u0001CE\f\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\b\n\u0005\rr!!\u0005*fgB|gn]3Qe>\u001cWm]:peB\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003S)\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002W\u0005\u00191m\\7\n\u000552#!D*ue&\u001cG\u000fT8hO&tw\r\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005!Q\u000f^5m\u0015\t\u0019D#\u0001\u0003d_J,\u0017BA\u001b1\u0005\u001dq\u0015-\\3HK:\f!\u0001\u001e=\u0011\u0005aRT\"A\u001d\u000b\u0005Y\u0002\u0012BA\u001e:\u0005\u0019AE\u000f\u001e9Uq\u0006\u00012/Z:tS>t\u0007K]8dKN\u001cxN\u001d\t\u0003CyJ!a\u0010\b\u0003!M+7o]5p]B\u0013xnY3tg>\u0014\u0018AD:uCR\u001c\bK]8dKN\u001cxN\u001d\t\u0003C\tK!a\u0011\b\u0003\u001dM#\u0018\r^:Qe>\u001cWm]:pe\u0006aa.\u001a=u\u000bb,7-\u001e;peB\u0011\u0011ER\u0005\u0003\u000f:\u0011ABT3yi\u0016CXmY;u_J\fa\u0002Z3gCVdGo\u00115beN,G\u000f\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u000691\r[1sg\u0016$(B\u0001(P\u0003\rq\u0017n\u001c\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u00116JA\u0004DQ\u0006\u00148/\u001a;\u0002\rqJg.\u001b;?)\u0019)fk\u0016-Z5B\u0011\u0011\u0005\u0001\u0005\u0006m\u0019\u0001\ra\u000e\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006\u0011\u001a\u0001\r!S\u0001\u000b_:\u001cu.\u001c9mKR,GCA/a!\tYb,\u0003\u0002`9\t!QK\\5u\u0011\u0015\tw\u00011\u0001c\u0003\u0019\u0011Xm];miB\u00111-Z\u0007\u0002I*\u0011qBE\u0005\u0003M\u0012\u0014!\u0002\u0013;uaJ+7/\u001e7u\u00035A\u0017M\u001c3mK\u001a\u000b\u0017\u000e\\;sKR\u0011Q,\u001b\u0005\u0006U\"\u0001\ra[\u0001\bM\u0006LG.\u001e:f!\t\u0019G.\u0003\u0002nI\nY\u0001\n\u001e;q\r\u0006LG.\u001e:f\u00039A\u0017M\u001c3mKJ+7\u000f]8og\u0016$\"!\u00189\t\u000bEL\u0001\u0019\u0001:\u0002\u0017I\fwOU3ta>t7/\u001a\t\u0003GNL!\u0001\u001e3\u0003\u0011I+7\u000f]8og\u0016\fq\u0001\u001d:pG\u0016,G\rF\u0002^obDQa\u0004\u0006A\u0002IDQ!\u0019\u0006A\u0002e\u0004\"!\t>\n\u0005mt!a\u0004)s_\u000e,7o]8s%\u0016\u001cX\u000f\u001c;\u00021\u0005\u0004\b\u000f\\=SKN\u0004xN\\:f)J\fgn\u001d4pe6,'\u000fF\u0002\u007f\u0003\u001b\u0001Ba`A\u0005e6\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0006wC2LG-\u0019;j_:T1!a\u0002\u0015\u0003\u001d\u0019w.\\7p]NLA!a\u0003\u0002\u0002\tQa+\u00197jI\u0006$\u0018n\u001c8\t\u000bE\\\u0001\u0019\u0001:\u0002\u001fA\u0014xnY3tgJ+7\u000f]8og\u0016$2!_A\n\u0011\u0015yA\u00021\u0001s\u0001")
public class DefaultResponseProcessor
implements ResponseProcessor,
StrictLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final NextExecutor nextExecutor;
    private final Charset defaultCharset;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            this.handleResponse(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            this.handleFailure(httpFailure);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpResult);
        }
    }

    private void handleFailure(HttpFailure failure) {
        block8: {
            Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), failure.startTimestamp(), failure.endTimestamp());
            try {
                try {
                    this.statsProcessor.reportStats(this.tx.fullRequestName(), this.tx.request().clientRequest(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable t = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                this.nextExecutor.executeNextOnCrash(sessionWithUpdatedStats, failure.endTimestamp());
            }
        }
    }

    private void handleResponse(Response rawResponse) {
        Validation<Response> validation = this.applyResponseTransformer(rawResponse);
        if (validation instanceof Failure) {
            Failure failure = (Failure)validation;
            String errorMessage = failure.message();
            this.proceed(rawResponse, new Crash(errorMessage));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validation instanceof Success) {
            Success success = (Success)validation;
            Response response = (Response)success.value();
            this.proceed(response, this.processResponse(response));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(validation);
        }
    }

    private void proceed(Response response, ProcessorResult result) {
        Request clientRequest = this.tx.request().clientRequest();
        ProcessorResult processorResult = result;
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)status, response, errorMessage);
            this.nextExecutor.executeNext(newSession, (Status)status, response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Redirect) {
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, redirectTx.currentSession(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            this.nextExecutor.executeRedirect(redirectTx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            this.nextExecutor.executeNextOnCrash(newSession, response.endTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)processorResult);
        }
    }

    private Validation<Response> applyResponseTransformer(Response rawResponse) {
        Validation validation;
        Option<Function2<Session, Response, Validation<Response>>> option = this.tx.request().requestConfig().responseTransformer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 transformer = (Function2)some.value();
            validation = package$.MODULE$.safely((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(30).append("Response transformer crashed: ").append((String)x$1).toString(), (Function0 & Serializable & scala.Serializable)() -> (Validation)transformer.apply((Object)$this.tx.currentSession(), (Object)rawResponse));
        } else {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)rawResponse));
        }
        return validation;
    }

    private ProcessorResult processResponse(Response response) {
        ProcessorResult processorResult;
        block16: {
            try {
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    if (this.tx.redirectCount() >= this.tx.request().requestConfig().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(this.tx.request().requestConfig().maxRedirects()).toString());
                    } else {
                        Crash crash;
                        Option<String> option = response.header(HeaderNames$.MODULE$.Location());
                        if (option instanceof Some) {
                            ProcessorResult processorResult2;
                            Some some = (Some)option;
                            String location = (String)some.value();
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                            Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.currentSession(), response, redirectUri);
                            Validation<Request> validation = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                            if (validation instanceof Success) {
                                Success success = (Success)validation;
                                Request redirectRequest = (Request)success.value();
                                HttpTx fresh$macro$3 = this.tx;
                                HttpTx fresh$macro$6 = (HttpTx)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> fresh$macro$1.copy((Session)fresh$macro$2.apply((Object)fresh$macro$1.session()), fresh$macro$1.copy$default$2(), fresh$macro$1.copy$default$3(), fresh$macro$1.copy$default$4(), fresh$macro$1.copy$default$5(), fresh$macro$1.copy$default$6())).setTo((Object)newSession);
                                HttpTx fresh$macro$9 = (HttpTx)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable & scala.Serializable)(fresh$macro$4, fresh$macro$5) -> {
                                    Request x$1 = (Request)fresh$macro$5.apply((Object)fresh$macro$4.request().clientRequest());
                                    String x$2 = fresh$macro$4.request().copy$default$1();
                                    HttpRequestConfig x$3 = fresh$macro$4.request().copy$default$3();
                                    HttpRequest x$4 = fresh$macro$4.request().copy(x$2, x$1, x$3);
                                    Session x$5 = fresh$macro$4.copy$default$1();
                                    Function1<Request, ResponseBuilder> x$6 = fresh$macro$4.copy$default$3();
                                    Action x$7 = fresh$macro$4.copy$default$4();
                                    Option<ResourceTx> x$8 = fresh$macro$4.copy$default$5();
                                    int x$9 = fresh$macro$4.copy$default$6();
                                    return fresh$macro$4.copy(x$5, x$4, x$6, x$7, x$8, x$9);
                                }).setTo((Object)redirectRequest);
                                processorResult2 = new Redirect((HttpTx)new package.PathModify((Object)fresh$macro$9, (Function2 & Serializable & scala.Serializable)(fresh$macro$7, fresh$macro$8) -> {
                                    int x$10 = fresh$macro$8.apply$mcII$sp(fresh$macro$7.redirectCount());
                                    Session x$11 = fresh$macro$7.copy$default$1();
                                    HttpRequest x$12 = fresh$macro$7.copy$default$2();
                                    Function1<Request, ResponseBuilder> x$13 = fresh$macro$7.copy$default$3();
                                    Action x$14 = fresh$macro$7.copy$default$4();
                                    Option<ResourceTx> x$15 = fresh$macro$7.copy$default$5();
                                    return fresh$macro$7.copy(x$11, x$12, x$13, x$14, x$15, x$10);
                                }).using((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$5 -> x$5 + 1));
                            } else if (validation instanceof Failure) {
                                Failure failure = (Failure)validation;
                                String message = failure.message();
                                processorResult2 = new Crash(message);
                            } else {
                                throw new MatchError(validation);
                            }
                            crash = processorResult2;
                        } else {
                            crash = new Crash("Redirect status, yet no Location header");
                        }
                        processorResult = crash;
                    }
                    break block16;
                }
                Tuple2<Session, Option<String>> tuple2 = this.sessionProcessor.updatedSession(this.tx.currentSession(), response);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Session newSession = (Session)tuple2._1();
                Option errorMessage = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                Tuple2 tuple23 = tuple22;
                Session newSession2 = (Session)tuple23._1();
                Option errorMessage2 = (Option)tuple23._2();
                processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
            }
            catch (Throwable throwable) {
                Throwable t;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    t = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Crash crash = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
                processorResult = crash;
            }
        }
        return processorResult;
    }

    public DefaultResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, NextExecutor nextExecutor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.nextExecutor = nextExecutor;
        this.defaultCharset = defaultCharset;
        StrictLogging.$init$((StrictLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

